/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.mapper;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.starter.mapper.ConfigurationCustomizer;
import org.aoju.bus.starter.mapper.MapperFactoryBean;
import org.aoju.bus.starter.mapper.MybatisPluginBuilder;
import org.aoju.bus.starter.mapper.MybatisProperties;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@ConditionalOnMissingBean(value={MapperFactoryBean.class})
@EnableConfigurationProperties(value={MybatisProperties.class})
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
@AutoConfigureBefore(name={"org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration"})
public class MapperConfiguration
implements InitializingBean {
    private final Environment environment;
    private final MybatisProperties properties;
    private final Interceptor[] interceptors;
    private final ResourceLoader resourceLoader;
    private final List<ConfigurationCustomizer> configurationCustomizers;

    public MapperConfiguration(Environment environment, MybatisProperties properties, ObjectProvider<Interceptor[]> interceptorsProvider, ResourceLoader resourceLoader, ObjectProvider<List<ConfigurationCustomizer>> configurationCustomizersProvider) {
        this.environment = environment;
        this.properties = properties;
        this.interceptors = (Interceptor[])interceptorsProvider.getIfAvailable();
        this.resourceLoader = resourceLoader;
        this.configurationCustomizers = (List)configurationCustomizersProvider.getIfAvailable();
    }

    public void afterPropertiesSet() {
        if (this.properties.isCheckConfigLocation() && StringKit.hasText(this.properties.getConfigLocation())) {
            Resource resource = this.resourceLoader.getResource(this.properties.getConfigLocation());
            Assert.state(resource.exists(), "Cannot find config location: " + String.valueOf(resource) + " (please add config file or check your Mybatis configuration)", new Object[0]);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource) throws Exception {
        Configuration configuration;
        SqlSessionFactoryBean factory = new SqlSessionFactoryBean();
        factory.setDataSource(dataSource);
        factory.setVfs(SpringBootVFS.class);
        if (StringKit.hasText(this.properties.getConfigLocation())) {
            factory.setConfigLocation(this.resourceLoader.getResource(this.properties.getConfigLocation()));
        }
        if ((configuration = this.properties.getConfiguration()) == null && !StringKit.hasText(this.properties.getConfigLocation())) {
            configuration = new Configuration();
        }
        if (configuration != null && !CollKit.isEmpty(this.configurationCustomizers)) {
            for (ConfigurationCustomizer customizer : this.configurationCustomizers) {
                customizer.customize(configuration);
            }
        }
        factory.setConfiguration(configuration);
        if (this.properties.getConfigurationProperties() != null) {
            factory.setConfigurationProperties(this.properties.getConfigurationProperties());
        }
        if (ArrayKit.isNotEmpty(this.interceptors)) {
            factory.setPlugins(this.interceptors);
        } else {
            factory.setPlugins(MybatisPluginBuilder.build(this.environment));
        }
        if (StringKit.hasLength(this.properties.getTypeAliasesPackage())) {
            factory.setTypeAliasesPackage(this.properties.getTypeAliasesPackage());
        }
        if (this.properties.getTypeAliasesSuperType() != null) {
            factory.setTypeAliasesSuperType(this.properties.getTypeAliasesSuperType());
        }
        if (StringKit.hasLength(this.properties.getTypeHandlersPackage())) {
            factory.setTypeHandlersPackage(this.properties.getTypeHandlersPackage());
        }
        if (!ObjectKit.isEmpty(this.properties.resolveMapperLocations())) {
            factory.setMapperLocations(this.properties.resolveMapperLocations());
        }
        return factory.getObject();
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        ExecutorType executorType = this.properties.getExecutorType();
        if (executorType != null) {
            return new SqlSessionTemplate(sqlSessionFactory, executorType);
        }
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    class SpringBootVFS
    extends VFS {
        private final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver(((Object)((Object)this)).getClass().getClassLoader());

        private String preserveSubpackageName(URI uri, String rootPath) {
            String url = uri.toString();
            return url.substring(url.indexOf(rootPath));
        }

        public boolean isValid() {
            return true;
        }

        protected List<String> list(URL url, String path) throws IOException {
            Resource[] resources = this.resourceResolver.getResources("classpath*:" + path + "/**/*.class");
            ArrayList<String> resourcePaths = new ArrayList<String>();
            for (Resource resource : resources) {
                resourcePaths.add(this.preserveSubpackageName(resource.getURI(), path));
            }
            return resourcePaths;
        }
    }
}

