/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.sensitive;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.BooleanKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.mapper.handler.AbstractSqlHandler;
import org.aoju.bus.sensitive.Provider;
import org.aoju.bus.sensitive.annotation.NShield;
import org.aoju.bus.sensitive.annotation.Privacy;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.aoju.bus.sensitive.annotation.Shield;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class SensitiveStatementHandler
extends AbstractSqlHandler
implements Interceptor {
    private boolean debug;
    private String type;
    private String key;

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)SensitiveStatementHandler.realTarget(invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = SensitiveStatementHandler.getMappedStatement(metaObject);
        SqlCommandType commandType = mappedStatement.getSqlCommandType();
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        Object params = boundSql.getParameterObject();
        if (params instanceof Map) {
            return invocation.proceed();
        }
        if (this.debug) {
            Sensitive sensitive;
            Sensitive sensitive2 = sensitive = null != params ? params.getClass().getAnnotation(Sensitive.class) : null;
            if (ObjectKit.isNotEmpty(sensitive)) {
                this.handleParameters(sensitive, mappedStatement.getConfiguration(), boundSql, params, commandType);
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object object) {
        if (object instanceof StatementHandler) {
            return Plugin.wrap((Object)object, (Interceptor)this);
        }
        return object;
    }

    public void setProperties(Properties properties) {
        this.debug = BooleanKit.toBoolean(properties.getProperty("debug"));
        this.key = properties.getProperty("key");
        this.type = properties.getProperty("type");
    }

    private void handleParameters(Sensitive sensitive, Configuration configuration, BoundSql boundSql, Object param, SqlCommandType commandType) {
        HashMap<String, Object> newValues = new HashMap<String, Object>(16);
        MetaObject metaObject = configuration.newMetaObject(param);
        for (Field field : param.getClass().getDeclaredFields()) {
            Privacy privacy;
            Object value = metaObject.getValue(field.getName());
            if (value instanceof CharSequence && this.isWriteCommand(commandType) && !Provider.alreadyBeSentisived(value) && ("ALL".equals(sensitive.value()) || "SENS".equals(sensitive.value()) && ("ALL".equals(sensitive.stage()) || "IN".equals(sensitive.stage())))) {
                Logger.debug("Write data sensitive enabled ...", new Object[0]);
                value = this.handleSensitive(field, value);
            }
            if (!ObjectKit.isNotEmpty(value)) continue;
            if (("ALL".equals(sensitive.value()) || "SAFE".equals(sensitive.value()) && ("ALL".equals(sensitive.stage()) || "IN".equals(sensitive.stage()))) && ObjectKit.isNotEmpty(privacy = field.getAnnotation(Privacy.class)) && StringKit.isNotEmpty(privacy.value()) && ("ALL".equals(privacy.value()) || "IN".equals(privacy.value()))) {
                Logger.debug("Write data encryption enabled ...", new Object[0]);
                value = Builder.encrypt(this.type, this.key, value.toString(), Charset.UTF_8);
            }
            newValues.put(field.getName(), value);
        }
        for (Map.Entry entry : newValues.entrySet()) {
            boundSql.setAdditionalParameter((String)entry.getKey(), entry.getValue());
        }
    }

    private boolean isWriteCommand(SqlCommandType commandType) {
        return SqlCommandType.UPDATE.equals((Object)commandType) || SqlCommandType.INSERT.equals((Object)commandType);
    }

    private Object handleSensitive(Field field, Object value) {
        NShield json;
        Shield sensitiveField = field.getAnnotation(Shield.class);
        if (ObjectKit.isNotEmpty(sensitiveField)) {
            org.aoju.bus.sensitive.Builder.on(value);
        }
        if (ObjectKit.isNotEmpty(json = field.getAnnotation(NShield.class)) && ObjectKit.isNotEmpty(value)) {
            Shield[] keys;
            Map<String, Object> map = Provider.parseToObjectMap(value.toString());
            for (Shield f : keys = json.value()) {
                String key = f.key();
                Object data = map.get(key);
                if (null == data) continue;
                map.put(key, org.aoju.bus.sensitive.Builder.on(data));
            }
            value = Provider.parseMaptoJSONString(map);
        }
        return value;
    }
}

