/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.StreamKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.storage.Builder;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Message;
import org.aoju.bus.storage.provider.AbstractProvider;

public class LocalFileProvider
extends AbstractProvider {
    public LocalFileProvider(Context context) {
        this.context = context;
        Assert.notBlank(this.context.getRegion(), "[region] not defined", new Object[0]);
    }

    @Override
    public Message download(String fileName) {
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).data(new File(this.context.getRegion() + "/" + fileName)).build();
    }

    @Override
    public Message download(String bucket, String fileName) {
        return this.download(this.context.getRegion() + "/" + bucket + "/" + fileName);
    }

    @Override
    public Message download(String bucket, String fileName, File file) {
        return null;
    }

    @Override
    public Message download(String fileName, File file) {
        return null;
    }

    @Override
    public Message rename(String oldName, String newName) {
        return null;
    }

    @Override
    public Message rename(String bucket, String oldName, String newName) {
        return null;
    }

    @Override
    public Message upload(String fileName, byte[] content) {
        return null;
    }

    @Override
    public Message upload(String bucket, String fileName, InputStream content) {
        try {
            boolean result;
            File dest = new File(this.context.getRegion() + "/" + bucket + "/", fileName);
            if (!new File(dest.getParent()).exists() && !(result = new File(dest.getParent()).mkdirs())) {
                return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
            }
            OutputStream out = Files.newOutputStream(dest.toPath(), new OpenOption[0]);
            StreamKit.copy(content, out);
            content.close();
            out.close();
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).build();
        }
        catch (IOException e) {
            Logger.error("file upload failed", e.getMessage());
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
    }

    @Override
    public Message upload(String bucket, String fileName, byte[] content) {
        return null;
    }

    @Override
    public Message remove(String fileName) {
        return null;
    }

    @Override
    public Message remove(String bucket, String fileName) {
        return null;
    }

    @Override
    public Message remove(String bucket, Path path) {
        return null;
    }
}

