/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.validate.strategy;

import java.util.Collection;
import java.util.Map;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.validate.Context;
import org.aoju.bus.validate.annotation.Length;
import org.aoju.bus.validate.validators.Matcher;

public class LengthStrategy
implements Matcher<Object, Length> {
    @Override
    public boolean on(Object object, Length annotation, Context context) {
        int num;
        if (ObjectKit.isEmpty(object)) {
            return false;
        }
        if (object instanceof String) {
            num = ((String)object).length();
        } else if (object.getClass().isArray()) {
            num = ((Object[])object).length;
        } else if (object instanceof Collection) {
            num = ((Collection)object).size();
        } else if (object instanceof Map) {
            num = ((Map)object).keySet().size();
        } else {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u68c0\u67e5\u957f\u5ea6\u7684\u5bf9\u8c61\u7c7b\u578b:" + String.valueOf(object.getClass()));
        }
        return annotation.zeroAble() && num == 0 || num >= annotation.min() && num <= annotation.max();
    }
}

