/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.boot.env;

import java.util.Properties;
import org.aoju.bus.Version;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=-2147483648)
public class BusEnvironment
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Properties properties = this.getProperties();
        PropertiesPropertySource propertySource = new PropertiesPropertySource("BusEnvironment", properties);
        environment.getPropertySources().addLast((PropertySource)propertySource);
        environment.setRequiredProperties(new String[]{"spring.application.name"});
    }

    protected Properties getProperties() {
        Properties properties = new Properties();
        String version = this.getVersion();
        properties.setProperty("bus-boot.version", version);
        properties.setProperty("bus-boot.formatted-version", version.isEmpty() ? "" : String.format(" (v%s)", version));
        return properties;
    }

    protected String getVersion() {
        return Version.get() == null ? "" : Version.get();
    }
}

