/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.boot.builtin;

import java.util.Properties;
import org.aoju.bus.Version;
import org.aoju.bus.boot.banner.BusBanner;
import org.aoju.bus.boot.metric.BusListener;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=-2147483648)
public class GenieBuilder
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        PropertiesPropertySource propertySource = new PropertiesPropertySource("GenieBuilder", this.getProperties());
        environment.getPropertySources().addLast((PropertySource)propertySource);
        environment.setRequiredProperties(new String[]{"spring.application.name"});
        application.addListeners(new ApplicationListener[]{new BusListener()});
        application.setBanner((Banner)new BusBanner());
    }

    protected Properties getProperties() {
        Properties properties = new Properties();
        String version = Version.get() == null ? "" : Version.get();
        properties.setProperty("bus-boot.version", version);
        properties.setProperty("bus-boot.formatted-version", version.isEmpty() ? "" : String.format(" (v%s)", version));
        return properties;
    }
}

