/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.provider;

import com.google.common.base.StandardSystemProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.aoju.bus.cache.provider.AbstractProvider;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class SqliteProvider
extends AbstractProvider {
    public SqliteProvider() {
        this(StandardSystemProperty.USER_HOME.value() + "/.sqlite.db");
    }

    public SqliteProvider(String dbPath) {
        super(dbPath, Collections.emptyMap());
    }

    @Override
    protected Supplier<JdbcOperations> jdbcOperationsSupplier(String dbPath, Map<String, Object> context) {
        return () -> {
            SingleConnectionDataSource dataSource = new SingleConnectionDataSource();
            dataSource.setDriverClassName("org.sqlite.JDBC");
            dataSource.setUrl(String.format("jdbc:sqlite:%s", dbPath));
            JdbcTemplate template = new JdbcTemplate((DataSource)dataSource);
            template.execute("CREATE TABLE IF NOT EXISTS hi_hit_rate(id BIGINT     IDENTITY PRIMARY KEY,pattern       VARCHAR(64) NOT NULL UNIQUE,hit_count     BIGINT      NOT NULL     DEFAULT 0,require_count BIGINT      NOT NULL     DEFAULT 0,version       BIGINT      NOT NULL     DEFAULT 0)");
            return template;
        };
    }

    @Override
    protected Stream<AbstractProvider.DataDO> transferResults(List<Map<String, Object>> mapResults) {
        return mapResults.stream().map(result -> {
            AbstractProvider.DataDO dataDO = new AbstractProvider.DataDO();
            dataDO.setHitCount(((Integer)result.get("hit_count")).intValue());
            dataDO.setPattern((String)result.get("pattern"));
            dataDO.setRequireCount(((Integer)result.get("require_count")).intValue());
            dataDO.setVersion(((Integer)result.get("version")).intValue());
            return dataDO;
        });
    }
}

