/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.reader;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.aoju.bus.cache.CacheConfig;
import org.aoju.bus.cache.CacheManager;
import org.aoju.bus.cache.entity.CacheHolder;
import org.aoju.bus.cache.entity.CacheMethod;
import org.aoju.bus.cache.invoker.BaseInvoker;
import org.aoju.bus.cache.provider.BaseProvider;
import org.aoju.bus.cache.reader.AbstractCacheReader;
import org.aoju.bus.cache.support.KeyGenerator;
import org.aoju.bus.cache.support.PatternGenerator;
import org.aoju.bus.cache.support.PreventObjects;
import org.aoju.bus.logger.Logger;

@Singleton
public class SingleCacheReader
extends AbstractCacheReader {
    @Inject
    private CacheManager cacheManager;
    @Inject
    private CacheConfig config;
    @Inject(optional=true)
    private BaseProvider baseProvider;

    @Override
    public Object read(CacheHolder cacheHolder, CacheMethod cacheMethod, BaseInvoker baseInvoker, boolean needWrite) throws Throwable {
        String key = KeyGenerator.generateSingleKey(cacheHolder, baseInvoker.getArgs());
        Object readResult = this.cacheManager.readSingle(cacheHolder.getCache(), key);
        this.doRecord(readResult, key, cacheHolder);
        if (readResult != null) {
            if (PreventObjects.isPrevent(readResult)) {
                return null;
            }
            return readResult;
        }
        Object invokeResult = this.doLogInvoke(baseInvoker::proceed);
        if (invokeResult != null && cacheMethod.getInnerReturnType() == null) {
            cacheMethod.setInnerReturnType(invokeResult.getClass());
        }
        if (!needWrite) {
            return invokeResult;
        }
        if (invokeResult != null) {
            this.cacheManager.writeSingle(cacheHolder.getCache(), key, invokeResult, cacheHolder.getExpire());
            return invokeResult;
        }
        if (this.config.isPreventOn()) {
            this.cacheManager.writeSingle(cacheHolder.getCache(), key, PreventObjects.getPreventObject(), cacheHolder.getExpire());
        }
        return null;
    }

    private void doRecord(Object result, String key, CacheHolder cacheHolder) {
        Logger.info((String)"single cache hit rate: {}/1, key: {}", (Object[])new Object[]{result == null ? 0 : 1, key});
        if (this.baseProvider != null) {
            String pattern = PatternGenerator.generatePattern(cacheHolder);
            if (result != null) {
                this.baseProvider.hitIncr(pattern, 1);
            }
            this.baseProvider.reqIncr(pattern, 1);
        }
    }
}

