/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.support;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.aoju.bus.cache.annotation.CacheKey;
import org.aoju.bus.cache.annotation.Cached;
import org.aoju.bus.cache.annotation.CachedGet;
import org.aoju.bus.cache.annotation.Invalid;
import org.aoju.bus.cache.entity.CacheHolder;
import org.aoju.bus.cache.entity.CacheMethod;
import org.aoju.bus.cache.entity.Pair;
import org.aoju.bus.logger.Logger;

public class CacheInfoContainer {
    private static final ConcurrentMap<Method, Pair<CacheHolder, CacheMethod>> cacheMap = new ConcurrentHashMap<Method, Pair<CacheHolder, CacheMethod>>();

    public static Pair<CacheHolder, CacheMethod> getCacheInfo(Method method) {
        return cacheMap.computeIfAbsent(method, CacheInfoContainer::doGetMethodInfo);
    }

    private static Pair<CacheHolder, CacheMethod> doGetMethodInfo(Method method) {
        CacheHolder cacheHolder = CacheInfoContainer.getAnnoHolder(method);
        CacheMethod cacheMethod = CacheInfoContainer.getMethodHolder(method, cacheHolder);
        return Pair.of(cacheHolder, cacheMethod);
    }

    private static CacheHolder getAnnoHolder(Method method) {
        CacheHolder.Builder builder = CacheHolder.Builder.newBuilder(method);
        Annotation[][] pAnnotations = method.getParameterAnnotations();
        CacheInfoContainer.scanKeys(builder, pAnnotations);
        if (method.isAnnotationPresent(Cached.class)) {
            CacheInfoContainer.scanCached(builder, method.getAnnotation(Cached.class));
        } else if (method.isAnnotationPresent(CachedGet.class)) {
            CacheInfoContainer.scanCachedGet(builder, method.getAnnotation(CachedGet.class));
        } else {
            CacheInfoContainer.scanInvalid(builder, method.getAnnotation(Invalid.class));
        }
        return builder.build();
    }

    private static CacheHolder.Builder scanKeys(CacheHolder.Builder builder, Annotation[][] pAnnotations) {
        int multiIndex = -1;
        String id = "";
        LinkedHashMap<Integer, CacheKey> cacheKeyMap = new LinkedHashMap<Integer, CacheKey>(pAnnotations.length);
        for (int pIndex = 0; pIndex < pAnnotations.length; ++pIndex) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = pAnnotations[pIndex]) {
                if (!(annotation instanceof CacheKey)) continue;
                CacheKey cacheKey = (CacheKey)annotation;
                cacheKeyMap.put(pIndex, cacheKey);
                if (!CacheInfoContainer.isMulti(cacheKey)) continue;
                multiIndex = pIndex;
                id = cacheKey.field();
            }
        }
        return builder.setCacheKeyMap(cacheKeyMap).setMultiIndex(multiIndex).setId(id);
    }

    private static CacheHolder.Builder scanCached(CacheHolder.Builder builder, Cached cached) {
        return builder.setCache(cached.value()).setPrefix(cached.prefix()).setExpire(cached.expire());
    }

    private static CacheHolder.Builder scanCachedGet(CacheHolder.Builder builder, CachedGet cachedGet) {
        return builder.setCache(cachedGet.value()).setPrefix(cachedGet.prefix()).setExpire(-1);
    }

    private static CacheHolder.Builder scanInvalid(CacheHolder.Builder builder, Invalid invalid) {
        return builder.setCache(invalid.value()).setPrefix(invalid.prefix()).setExpire(-1);
    }

    private static CacheMethod getMethodHolder(Method method, CacheHolder cacheHolder) {
        boolean isCollectionReturn = Collection.class.isAssignableFrom(method.getReturnType());
        boolean isMapReturn = Map.class.isAssignableFrom(method.getReturnType());
        CacheInfoContainer.staticAnalyze(method.getParameterTypes(), cacheHolder, isCollectionReturn, isMapReturn);
        return new CacheMethod(isCollectionReturn);
    }

    private static void staticAnalyze(Class<?>[] pTypes, CacheHolder cacheHolder, boolean isCollectionReturn, boolean isMapReturn) {
        if (CacheInfoContainer.isInvalidParam(pTypes, cacheHolder)) {
            throw new RuntimeException("cache need at least one param key");
        }
        if (CacheInfoContainer.isInvalidMultiCount(cacheHolder.getCacheKeyMap())) {
            throw new RuntimeException("only one multi key");
        }
        Map<Integer, CacheKey> cacheKeyMap = cacheHolder.getCacheKeyMap();
        for (Map.Entry<Integer, CacheKey> entry : cacheKeyMap.entrySet()) {
            Integer argIndex = entry.getKey();
            CacheKey cacheKey = entry.getValue();
            if (CacheInfoContainer.isMulti(cacheKey) && CacheInfoContainer.isInvalidMulti(pTypes[argIndex])) {
                throw new RuntimeException("multi need a collection instance param");
            }
            if (CacheInfoContainer.isMulti(cacheKey) && CacheInfoContainer.isInvalidResult(isCollectionReturn, cacheKey.field())) {
                throw new RuntimeException("multi cache && collection method return need a result field");
            }
            if (!CacheInfoContainer.isInvalidIdentifier(isMapReturn, isCollectionReturn, cacheKey.field())) continue;
            throw new RuntimeException("id method a collection return method");
        }
    }

    private static boolean isMulti(CacheKey cacheKey) {
        if (cacheKey == null) {
            return false;
        }
        String value = cacheKey.value();
        if (Strings.isNullOrEmpty((String)value)) {
            return false;
        }
        return value.contains("#i");
    }

    private static boolean isInvalidParam(Class<?>[] pTypes, CacheHolder cacheHolder) {
        Map<Integer, CacheKey> cacheKeyMap = cacheHolder.getCacheKeyMap();
        String prefix = cacheHolder.getPrefix();
        return (pTypes == null || pTypes.length == 0 || cacheKeyMap.isEmpty()) && Strings.isNullOrEmpty((String)prefix);
    }

    private static boolean isInvalidMultiCount(Map<Integer, CacheKey> keyMap) {
        int multiCount = 0;
        for (CacheKey cacheKey : keyMap.values()) {
            if (CacheInfoContainer.isMulti(cacheKey) && ++multiCount > 1) break;
        }
        return multiCount > 1;
    }

    private static boolean isInvalidIdentifier(boolean isMapReturn, boolean isCollectionReturn, String field) {
        if (isMapReturn && !Strings.isNullOrEmpty((String)field)) {
            Logger.warn((String)"@CacheKey's 'field = \"{}\"' is useless.", (Object[])new Object[]{field});
            return false;
        }
        return !Strings.isNullOrEmpty((String)field) && !isCollectionReturn;
    }

    private static boolean isInvalidResult(boolean isCollectionReturn, String id) {
        return isCollectionReturn && Strings.isNullOrEmpty((String)id);
    }

    private static boolean isInvalidMulti(Class<?> paramType) {
        return !Collection.class.isAssignableFrom(paramType) && !paramType.isArray();
    }
}

