/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.support.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.aoju.bus.cache.support.cache.Cache;

public class MemoryCache
implements Cache {
    private ConcurrentMap<String, Object> map = new ConcurrentHashMap<String, Object>();

    @Override
    public Object read(String key) {
        return this.map.get(key);
    }

    @Override
    public void write(String key, Object value, long expire) {
        this.map.put(key, value);
    }

    @Override
    public Map<String, Object> read(Collection<String> keys) {
        HashMap<String, Object> subCache = new HashMap<String, Object>(keys.size());
        for (String key : keys) {
            subCache.put(key, this.read(key));
        }
        return subCache;
    }

    @Override
    public void write(Map<String, Object> keyValueMap, long expire) {
        this.map.putAll(keyValueMap);
    }

    @Override
    public void remove(String ... keys) {
        for (String key : keys) {
            this.map.remove(key);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

