/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache;

import java.lang.reflect.Method;
import java.util.Map;
import org.aoju.bus.cache.Complex;
import org.aoju.bus.cache.Context;
import org.aoju.bus.cache.Module;
import org.aoju.bus.cache.annotation.Cached;
import org.aoju.bus.cache.annotation.CachedGet;
import org.aoju.bus.cache.annotation.Invalid;
import org.aoju.bus.cache.proxy.AspectJoinPoint;
import org.aoju.bus.cache.support.cache.Cache;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class Aspectj {
    private Complex core;

    public Aspectj(Map<String, Cache> caches) {
        this(Context.newConfig(caches));
    }

    public Aspectj(Context config) {
        this.core = Module.coreInstance(config);
    }

    @Around(value="@annotation(org.aoju.bus.cache.annotation.CachedGet)")
    public Object read(ProceedingJoinPoint point) throws Throwable {
        Method method = this.getMethod((JoinPoint)point);
        CachedGet cachedGet = method.getAnnotation(CachedGet.class);
        return this.core.read(cachedGet, method, new AspectJoinPoint(point));
    }

    @Around(value="@annotation(org.aoju.bus.cache.annotation.Cached)")
    public Object readWrite(ProceedingJoinPoint point) throws Throwable {
        Method method = this.getMethod((JoinPoint)point);
        Cached cached = method.getAnnotation(Cached.class);
        return this.core.readWrite(cached, method, new AspectJoinPoint(point));
    }

    @After(value="@annotation(org.aoju.bus.cache.annotation.Invalid)")
    public void remove(JoinPoint point) throws Throwable {
        Method method = this.getMethod(point);
        Invalid invalid = method.getAnnotation(Invalid.class);
        this.core.remove(invalid, method, point.getArgs());
    }

    private Method getMethod(JoinPoint point) throws NoSuchMethodException {
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        if (method.getDeclaringClass().isInterface()) {
            method = point.getTarget().getClass().getDeclaredMethod(ms.getName(), method.getParameterTypes());
        }
        return method;
    }
}

