/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.metric;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aoju.bus.cache.CacheX;
import org.aoju.bus.core.utils.MapUtils;

public class MemoryCache
implements CacheX {
    public static long timeout = 180000L;
    public static boolean schedulePrune = true;
    private static Map<String, CacheState> map = new ConcurrentHashMap<String, CacheState>();
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock(true);
    private final Lock writeLock = this.cacheLock.writeLock();
    private final Lock readLock = this.cacheLock.readLock();

    public MemoryCache() {
        if (schedulePrune) {
            this.schedulePrune(timeout);
        }
    }

    @Override
    public void write(Map<String, Object> keyValueMap, long expire) {
        if (MapUtils.isNotEmpty(keyValueMap)) {
            keyValueMap.forEach((key, value) -> this.write((String)key, value, expire));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String key, Object value, long expire) {
        this.writeLock.lock();
        try {
            map.put(key, new CacheState(value, expire));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read(String key) {
        this.readLock.lock();
        try {
            CacheState cacheState = map.get(key);
            if (null == cacheState || cacheState.isExpired()) {
                Object var3_3 = null;
                return var3_3;
            }
            Object object = cacheState.getState();
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Map<String, Object> read(Collection<String> keys) {
        HashMap<String, Object> subCache = new HashMap<String, Object>(keys.size());
        for (String key : keys) {
            subCache.put(key, this.read(key));
        }
        return subCache;
    }

    @Override
    public void clear() {
        Iterator<CacheState> values = map.values().iterator();
        while (values.hasNext()) {
            CacheState cache = values.next();
            if (!cache.isExpired()) continue;
            values.remove();
        }
    }

    @Override
    public void remove(String ... keys) {
        for (String key : keys) {
            map.remove(key);
        }
    }

    public void schedulePrune(long delay) {
        CacheScheduler.INSTANCE.schedule(this::clear, delay);
    }

    private class CacheState
    implements Serializable {
        private Object state;
        private long expire;

        CacheState(Object state, long expire) {
            this.state = state;
            this.expire = System.currentTimeMillis() + expire;
        }

        boolean isExpired() {
            return System.currentTimeMillis() > this.expire;
        }

        public Object getState() {
            return this.state;
        }

        public long getExpire() {
            return this.expire;
        }

        public void setState(Object state) {
            this.state = state;
        }

        public void setExpire(long expire) {
            this.expire = expire;
        }
    }

    static enum CacheScheduler {
        INSTANCE;

        private AtomicInteger cacheTaskNumber = new AtomicInteger(1);
        private ScheduledExecutorService scheduler;

        private CacheScheduler() {
            this.create();
        }

        private void create() {
            this.shutdown();
            this.scheduler = new ScheduledThreadPoolExecutor(10, r -> new Thread(r, String.format("OAuth-Task-%s", this.cacheTaskNumber.getAndIncrement())));
        }

        private void shutdown() {
            if (null != this.scheduler) {
                this.scheduler.shutdown();
            }
        }

        public void schedule(Runnable task, long delay) {
            this.scheduler.scheduleAtFixedRate(task, delay, delay, TimeUnit.MILLISECONDS);
        }
    }
}

