/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.magic;

import org.aoju.bus.cache.Context;
import org.aoju.bus.cache.Hitting;
import org.aoju.bus.cache.Manage;
import org.aoju.bus.cache.magic.AbstractReader;
import org.aoju.bus.cache.magic.AnnoHolder;
import org.aoju.bus.cache.magic.MethodHolder;
import org.aoju.bus.cache.support.KeyGenerator;
import org.aoju.bus.cache.support.PatternGenerator;
import org.aoju.bus.cache.support.PreventObjects;
import org.aoju.bus.core.annotation.Inject;
import org.aoju.bus.core.annotation.Singleton;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.proxy.invoker.ProxyChain;

@Singleton
public class SingleCacheReader
extends AbstractReader {
    @Inject
    private Manage cacheManager;
    @Inject
    private Context config;
    @Inject(optional=true)
    private Hitting baseHitting;

    @Override
    public Object read(AnnoHolder annoHolder, MethodHolder methodHolder, ProxyChain baseInvoker, boolean needWrite) throws Throwable {
        String key = KeyGenerator.generateSingleKey(annoHolder, baseInvoker.getArguments());
        Object readResult = this.cacheManager.readSingle(annoHolder.getCache(), key);
        this.doRecord(readResult, key, annoHolder);
        if (readResult != null) {
            if (PreventObjects.isPrevent(readResult)) {
                return null;
            }
            return readResult;
        }
        Object invokeResult = this.doLogInvoke(() -> ((ProxyChain)baseInvoker).proceed());
        if (invokeResult != null && methodHolder.getInnerReturnType() == null) {
            methodHolder.setInnerReturnType(invokeResult.getClass());
        }
        if (!needWrite) {
            return invokeResult;
        }
        if (invokeResult != null) {
            this.cacheManager.writeSingle(annoHolder.getCache(), key, invokeResult, annoHolder.getExpire());
            return invokeResult;
        }
        if (this.config.isPreventOn()) {
            this.cacheManager.writeSingle(annoHolder.getCache(), key, PreventObjects.getPreventObject(), annoHolder.getExpire());
        }
        return null;
    }

    private void doRecord(Object result, String key, AnnoHolder annoHolder) {
        Logger.info((String)"single cache hit rate: {}/1, key: {}", (Object[])new Object[]{result == null ? 0 : 1, key});
        if (this.baseHitting != null) {
            String pattern = PatternGenerator.generatePattern(annoHolder);
            if (result != null) {
                this.baseHitting.hitIncr(pattern, 1);
            }
            this.baseHitting.reqIncr(pattern, 1);
        }
    }
}

