/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.provider;

import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import org.aoju.bus.cache.Hitting;
import org.aoju.bus.cache.magic.CachePair;
import org.springframework.jdbc.core.JdbcOperations;
import org.yaml.snakeyaml.Yaml;

public abstract class AbstractHitting
implements Hitting {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setName("cache:db-writer");
        thread.setDaemon(true);
        return thread;
    });
    private static final Lock lock = new ReentrantLock();
    private volatile boolean isShutdown = false;
    private BlockingQueue<CachePair<String, Integer>> hitQueue = new LinkedTransferQueue<CachePair<String, Integer>>();
    private BlockingQueue<CachePair<String, Integer>> requireQueue = new LinkedTransferQueue<CachePair<String, Integer>>();
    private JdbcOperations jdbcOperations;
    private Properties sqls;

    protected AbstractHitting(Map<String, Object> context) {
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream("META-INF/caches/bus-cache.yaml");
        this.sqls = (Properties)new Yaml().loadAs(resource, Properties.class);
        this.jdbcOperations = this.jdbcOperationsSupplier(context).get();
        executor.submit(() -> {
            while (!this.isShutdown) {
                this.dumpToDB(this.hitQueue, "hit_count");
                this.dumpToDB(this.requireQueue, "require_count");
            }
        });
    }

    public AbstractHitting(String url, String username, String password) {
        this(AbstractHitting.newHashMap("url", url, "username", username, "password", password));
    }

    public static Map<String, Object> newHashMap(Object ... keyValues) {
        HashMap<String, Object> map = new HashMap<String, Object>(keyValues.length / 2);
        for (int i = 0; i < keyValues.length; i += 2) {
            String key = (String)keyValues[i];
            Object value = keyValues[i + 1];
            map.put(key, value);
        }
        return map;
    }

    protected abstract Supplier<JdbcOperations> jdbcOperationsSupplier(Map<String, Object> var1);

    protected abstract Stream<DataDO> transferResults(List<Map<String, Object>> var1);

    private void dumpToDB(BlockingQueue<CachePair<String, Integer>> queue, String column) {
        CachePair head;
        HashMap<String, AtomicLong> holdMap = new HashMap<String, AtomicLong>();
        for (long times = 0L; (head = (CachePair)queue.poll()) != null && times <= 100L; ++times) {
            holdMap.computeIfAbsent((String)head.getLeft(), key -> new AtomicLong(0L)).addAndGet(((Integer)head.getRight()).intValue());
        }
        holdMap.forEach((pattern, count) -> this.countAddCas(column, (String)pattern, count.get()));
    }

    @Override
    public void hitIncr(String pattern, int count) {
        if (count != 0) {
            this.hitQueue.add(CachePair.of(pattern, count));
        }
    }

    @Override
    public void reqIncr(String pattern, int count) {
        if (count != 0) {
            this.requireQueue.add(CachePair.of(pattern, count));
        }
    }

    @Override
    public Map<String, Hitting.HittingDO> getHitting() {
        List<DataDO> dataDOS = this.queryAll();
        AtomicLong statisticsHit = new AtomicLong(0L);
        AtomicLong statisticsRequired = new AtomicLong(0L);
        Map result = dataDOS.stream().collect(Collectors.toMap(DataDO::getPattern, dataDO -> {
            statisticsHit.addAndGet(((DataDO)dataDO).hitCount);
            statisticsRequired.addAndGet(((DataDO)dataDO).requireCount);
            return Hitting.HittingDO.newInstance(((DataDO)dataDO).hitCount, ((DataDO)dataDO).requireCount);
        }, Hitting.HittingDO::mergeShootingDO, LinkedHashMap::new));
        result.put(this.summaryName(), Hitting.HittingDO.newInstance(statisticsHit.get(), statisticsRequired.get()));
        return result;
    }

    @Override
    public void reset(String pattern) {
        this.jdbcOperations.update(this.sqls.getProperty("delete"), new Object[]{pattern});
    }

    @Override
    public void resetAll() {
        this.jdbcOperations.update(this.sqls.getProperty("truncate"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countAddCas(String column, String pattern, long count) {
        Optional<DataDO> dataOptional = this.queryObject(pattern);
        if (dataOptional.isPresent()) {
            DataDO dataDO = dataOptional.get();
            while (this.update(column, pattern, this.getObjectCount(dataDO, column, count), dataDO.version) <= 0) {
                dataDO = this.queryObject(pattern).get();
            }
        } else {
            lock.lock();
            try {
                dataOptional = this.queryObject(pattern);
                if (dataOptional.isPresent()) {
                    this.update(column, pattern, count, dataOptional.get().version);
                }
                this.insert(column, pattern, count);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private Optional<DataDO> queryObject(String pattern) {
        String selectSql = this.sqls.getProperty("select");
        List mapResults = this.jdbcOperations.queryForList(selectSql, new Object[]{pattern});
        return this.transferResults(mapResults).findFirst();
    }

    private List<DataDO> queryAll() {
        String selectAllQuery = this.sqls.getProperty("select_all");
        List mapResults = this.jdbcOperations.queryForList(selectAllQuery);
        return this.transferResults(mapResults).collect(Collectors.toList());
    }

    private int insert(String column, String pattern, long count) {
        String insertSql = String.format(this.sqls.getProperty("insert"), column);
        return this.jdbcOperations.update(insertSql, new Object[]{pattern, count});
    }

    private int update(String column, String pattern, long count, long version) {
        String updateSql = String.format(this.sqls.getProperty("update"), column);
        return this.jdbcOperations.update(updateSql, new Object[]{count, pattern, version});
    }

    private long getObjectCount(DataDO data, String column, long countOffset) {
        long lastCount = column.equals("hit_count") ? data.hitCount : data.requireCount;
        return lastCount + countOffset;
    }

    @PreDestroy
    public void tearDown() {
        while (this.hitQueue.size() > 0 || this.requireQueue.size() > 0) {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.isShutdown = true;
    }

    protected static final class DataDO {
        private String pattern;
        private long hitCount;
        private long requireCount;
        private long version;

        protected DataDO() {
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public void setHitCount(long hitCount) {
            this.hitCount = hitCount;
        }

        public void setRequireCount(long requireCount) {
            this.requireCount = requireCount;
        }

        public void setVersion(long version) {
            this.version = version;
        }
    }
}

