/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.support;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.logger.Logger;

public class ArgNameGenerator {
    private static final String X_ARGS_PREFIX = "args";
    private static final ConcurrentMap<Method, String[]> methodParameterNames = new ConcurrentHashMap<Method, String[]>();
    private static String[] X_ARGS = new String[]{"args0", "args1", "args2", "args3", "args4", "args5", "args6", "args7", "args8", "args9", "args10", "args11", "args12", "args13", "args14", "args15", "args16", "args17", "args18", "args19"};
    private static boolean isFirst = true;

    public static String[] getArgNames(Method method) {
        return methodParameterNames.computeIfAbsent(method, ArgNameGenerator::doGetArgNamesWithJava8);
    }

    public static String[] getXArgNames(int valueSize) {
        if (valueSize == 0) {
            return Normal.EMPTY_STRING_ARRAY;
        }
        String[] xArgs = new String[valueSize];
        for (int i = 0; i < valueSize; ++i) {
            xArgs[i] = i < X_ARGS.length ? X_ARGS[i] : X_ARGS_PREFIX + i;
        }
        return xArgs;
    }

    private static String[] doGetArgNamesWithJava8(Method method) {
        Parameter[] parameters = method.getParameters();
        String[] argNames = (String[])Arrays.stream(parameters).map(Parameter::getName).toArray(String[]::new);
        if (isFirst && argNames.length != 0 && argNames[0].equals("arg0")) {
            Logger.warn((String)"compile not set '\u2013parameters', used default method parameter names", (Object[])new Object[0]);
            isFirst = false;
        }
        return argNames;
    }
}

