/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.support;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.toolkit.CollKit;

public class Addables {
    public static Addable newAddable(Class<?> type, int size) {
        if (Map.class.isAssignableFrom(type)) {
            return new MapAddable().init(type, size);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return new CollectionAddable().init((Class<Collection>)type, size);
        }
        return new ArrayAddable().init((Class<Object[]>)type, size);
    }

    public static Collection newCollection(Class<?> type, Collection initCollection) {
        try {
            Collection collection = (Collection)type.newInstance();
            if (CollKit.isNotEmpty((Collection)initCollection)) {
                collection.addAll(initCollection);
            }
            return collection;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("could not invoke collection: " + type.getName() + "'s no param (default) constructor!", e);
        }
    }

    public static Map newMap(Class<?> type, Map initMap) {
        try {
            Map map = (Map)type.newInstance();
            if (CollKit.isNotEmpty((Map)initMap)) {
                map.putAll(initMap);
            }
            return map;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("could not invoke map: " + type.getName() + "'s no param (default) constructor!", e);
        }
    }

    private static class MapAddable
    implements Addable<Map> {
        private Map instance;

        private MapAddable() {
        }

        @Override
        public Addable init(Class<Map> type, int initSize) {
            try {
                this.instance = type.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("could not invoke Map: " + type.getName() + "'s no param (default) constructor!", e);
            }
            return this;
        }

        @Override
        public Addable addAll(List<Object> list) {
            if (CollKit.isEmpty(list)) {
                return this;
            }
            list.stream().map(obj -> (Map.Entry)obj).forEach(entry -> this.instance.put(entry.getKey(), entry.getValue()));
            return this;
        }

        @Override
        public Map getResult() {
            return this.instance;
        }
    }

    private static class CollectionAddable
    implements Addable<Collection> {
        private Collection instance;

        private CollectionAddable() {
        }

        @Override
        public Addable init(Class<Collection> type, int initSize) {
            try {
                this.instance = type.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("could not invoke collection: " + type.getName() + "'s no param (default) constructor!", e);
            }
            return this;
        }

        @Override
        public Addable addAll(List<Object> list) {
            this.instance.addAll(list);
            return this;
        }

        @Override
        public Collection getResult() {
            return this.instance;
        }
    }

    private static class ArrayAddable
    implements Addable<Object[]> {
        private Object[] instance;

        private ArrayAddable() {
        }

        @Override
        public Addable init(Class<Object[]> type, int initSize) {
            this.instance = new Object[initSize];
            return this;
        }

        @Override
        public Addable addAll(List<Object> list) {
            for (int i = 0; i < list.size(); ++i) {
                this.instance[i] = list.get(i);
            }
            return this;
        }

        @Override
        public Object[] getResult() {
            return this.instance;
        }
    }

    public static interface Addable<T> {
        public Addable init(Class<T> var1, int var2);

        public Addable addAll(List<Object> var1);

        public T getResult();
    }
}

