/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.support;

import org.aoju.bus.cache.support.ArgNameGenerator;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.StringKit;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpelCalculator {
    private static final ExpressionParser parser = new SpelExpressionParser();

    public static Object calcSpelValueWithContext(String spel, String[] argNames, Object[] argValues, Object defaultValue) {
        if (StringKit.isEmpty((CharSequence)spel)) {
            return defaultValue;
        }
        StandardEvaluationContext context = new StandardEvaluationContext();
        Assert.isTrue((argNames.length == argValues.length ? 1 : 0) != 0);
        for (int i = 0; i < argValues.length; ++i) {
            context.setVariable(argNames[i], argValues[i]);
        }
        String[] xArgNames = ArgNameGenerator.getXArgNames(argValues.length);
        for (int i = 0; i < argValues.length; ++i) {
            context.setVariable(xArgNames[i], argValues[i]);
        }
        return parser.parseExpression(spel).getValue((EvaluationContext)context);
    }

    public static Object calcSpelWithNoContext(String spel, Object defaultValue) {
        if (StringKit.isEmpty((CharSequence)spel)) {
            return defaultValue;
        }
        return parser.parseExpression(spel).getValue(defaultValue);
    }
}

