/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.watch;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.io.watch.Watcher;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.URLUtils;

public class WatchMonitor
extends Thread
implements Closeable {
    public static final WatchEvent.Kind<?> OVERFLOW = StandardWatchEventKinds.OVERFLOW;
    public static final WatchEvent.Kind<?> ENTRY_MODIFY = StandardWatchEventKinds.ENTRY_MODIFY;
    public static final WatchEvent.Kind<?> ENTRY_CREATE = StandardWatchEventKinds.ENTRY_CREATE;
    public static final WatchEvent.Kind<?> ENTRY_DELETE = StandardWatchEventKinds.ENTRY_DELETE;
    public static final WatchEvent.Kind<?>[] EVENTS_ALL = new WatchEvent.Kind[]{StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE};
    private Path path;
    private int maxDepth;
    private Path filePath;
    private WatchService watchService;
    private Watcher watcher;
    private WatchEvent.Kind<?>[] events;
    private boolean isClosed;
    private Map<WatchKey, Path> watchKeyPathMap = new HashMap<WatchKey, Path>();

    public WatchMonitor(File file, WatchEvent.Kind<?> ... events) {
        this(file.toPath(), events);
    }

    public WatchMonitor(String path, WatchEvent.Kind<?> ... events) {
        this(Paths.get(path, new String[0]), events);
    }

    public WatchMonitor(Path path, WatchEvent.Kind<?> ... events) {
        this(path, 0, events);
    }

    public WatchMonitor(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        this.path = path;
        this.maxDepth = maxDepth;
        this.events = events;
        this.init();
    }

    public static WatchMonitor create(URL url, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(url, 0, events);
    }

    public static WatchMonitor create(URL url, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(URLUtils.toURI(url), maxDepth, events);
    }

    public static WatchMonitor create(URI uri, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(uri, 0, events);
    }

    public static WatchMonitor create(URI uri, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(Paths.get(uri), maxDepth, events);
    }

    public static WatchMonitor create(File file, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(file, 0, events);
    }

    public static WatchMonitor create(File file, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(file.toPath(), maxDepth, events);
    }

    public static WatchMonitor create(String path, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(path, 0, events);
    }

    public static WatchMonitor create(String path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(Paths.get(path, new String[0]), maxDepth, events);
    }

    public static WatchMonitor create(Path path, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.create(path, 0, events);
    }

    public static WatchMonitor create(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(path, maxDepth, events);
    }

    public static WatchMonitor createAll(URI uri, Watcher watcher) {
        return WatchMonitor.createAll(Paths.get(uri), watcher);
    }

    public static WatchMonitor createAll(URL url, Watcher watcher) {
        try {
            return WatchMonitor.createAll(Paths.get(url.toURI()), watcher);
        }
        catch (URISyntaxException e) {
            throw new InstrumentException(e);
        }
    }

    public static WatchMonitor createAll(File file, Watcher watcher) {
        return WatchMonitor.createAll(file.toPath(), watcher);
    }

    public static WatchMonitor createAll(String path, Watcher watcher) {
        return WatchMonitor.createAll(Paths.get(path, new String[0]), watcher);
    }

    public static WatchMonitor createAll(Path path, Watcher watcher) {
        WatchMonitor watchMonitor = WatchMonitor.create(path, EVENTS_ALL);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public void init() throws InstrumentException {
        if (!Files.exists(this.path, LinkOption.NOFOLLOW_LINKS)) {
            String lastPathEleStr;
            Path lastPathEle = FileUtils.getLastPathEle(this.path);
            if (null != lastPathEle && StringUtils.contains(lastPathEleStr = lastPathEle.toString(), '.') && !StringUtils.endWithIgnoreCase(lastPathEleStr, ".d")) {
                this.filePath = this.path;
                this.path = this.filePath.getParent();
            }
            try {
                Files.createDirectories(this.path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new CommonException(e);
            }
        } else if (Files.isRegularFile(this.path, LinkOption.NOFOLLOW_LINKS)) {
            this.filePath = this.path;
            this.path = this.filePath.getParent();
        }
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        this.isClosed = false;
    }

    public WatchMonitor setWatcher(Watcher watcher) {
        this.watcher = watcher;
        return this;
    }

    @Override
    public void run() {
        this.watch();
    }

    public void watch() {
        this.watch(this.watcher);
    }

    public void watch(Watcher watcher) throws InstrumentException {
        if (this.isClosed) {
            throw new InstrumentException("Watch Monitor is closed !");
        }
        this.registerPath();
        while (!this.isClosed) {
            WatchKey wk;
            try {
                wk = this.watchService.take();
            }
            catch (InterruptedException e) {
                return;
            }
            Path currentPath = this.watchKeyPathMap.get(wk);
            for (WatchEvent<?> event : wk.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (null != this.filePath && !this.filePath.endsWith(event.context().toString())) continue;
                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    watcher.onCreate(event, currentPath);
                    continue;
                }
                if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                    watcher.onModify(event, currentPath);
                    continue;
                }
                if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                    watcher.onDelete(event, currentPath);
                    continue;
                }
                if (kind != StandardWatchEventKinds.OVERFLOW) continue;
                watcher.onOverflow(event, currentPath);
            }
            wk.reset();
        }
    }

    public WatchMonitor setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    @Override
    public void close() {
        this.isClosed = true;
        IoUtils.close(this.watchService);
    }

    private void registerPath() {
        this.registerPath(this.path, null != this.filePath ? 0 : this.maxDepth);
    }

    private void registerPath(Path path, int maxDepth) {
        try {
            WatchKey key = path.register(this.watchService, ArrayUtils.isEmpty(this.events) ? EVENTS_ALL : this.events);
            this.watchKeyPathMap.put(key, path);
            if (maxDepth > 1) {
                Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        WatchMonitor.this.registerPath(dir, 0);
                        return super.postVisitDirectory(dir, exc);
                    }
                });
            }
        }
        catch (IOException e) {
            if (e instanceof AccessDeniedException) {
                return;
            }
            throw new InstrumentException(e);
        }
    }
}

