/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.aoju.bus.core.consts.Fields;
import org.aoju.bus.core.date.Between;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.date.TimeInterval;
import org.aoju.bus.core.date.format.BetweenFormat;
import org.aoju.bus.core.date.format.DateParser;
import org.aoju.bus.core.date.format.DatePrinter;
import org.aoju.bus.core.date.format.FastDateFormat;
import org.aoju.bus.core.lang.Validator;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.StringUtils;

public class DateUtils
extends Fields {
    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime date(Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return new DateTime(date);
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static DateTime date(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static Calendar calendar(Date date) {
        return DateUtils.calendar(date.getTime());
    }

    public static Calendar calendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static String now() {
        return DateUtils.formatDateTime(new DateTime());
    }

    public static long current(boolean isNano) {
        return isNano ? System.nanoTime() : System.currentTimeMillis();
    }

    public static long currentSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String today() {
        return DateUtils.formatDate(new DateTime());
    }

    public static int year(Date date) {
        return DateTime.of(date).year();
    }

    public static int quarter(Date date) {
        return DateTime.of(date).quarter();
    }

    public static Fields.Quarter quarterEnum(Date date) {
        return DateTime.of(date).quarterEnum();
    }

    public static int month(Date date) {
        return DateTime.of(date).month();
    }

    public static Fields.Month monthEnum(Date date) {
        return DateTime.of(date).monthEnum();
    }

    public static int weekOfYear(Date date) {
        return DateTime.of(date).weekOfYear();
    }

    public static int weekOfMonth(Date date) {
        return DateTime.of(date).weekOfMonth();
    }

    public static int dayOfMonth(Date date) {
        return DateTime.of(date).dayOfMonth();
    }

    public static int dayOfWeek(Date date) {
        return DateTime.of(date).dayOfWeek();
    }

    public static Fields.Week dayOfWeekEnum(Date date) {
        return DateTime.of(date).dayOfWeekEnum();
    }

    public static int hour(Date date, boolean is24HourClock) {
        return DateTime.of(date).hour(is24HourClock);
    }

    public static int minute(Date date) {
        return DateTime.of(date).minute();
    }

    public static int second(Date date) {
        return DateTime.of(date).second();
    }

    public static int millsecond(Date date) {
        return DateTime.of(date).millsecond();
    }

    public static boolean isAM(Date date) {
        return DateTime.of(date).isAM();
    }

    public static boolean isPM(Date date) {
        return DateTime.of(date).isPM();
    }

    public static int thisYear() {
        return DateUtils.year(DateUtils.date());
    }

    public static int thisMonth() {
        return DateUtils.month(DateUtils.date());
    }

    public static Fields.Month thisMonthEnum() {
        return DateUtils.monthEnum(DateUtils.date());
    }

    public static int thisWeekOfYear() {
        return DateUtils.weekOfYear(DateUtils.date());
    }

    public static int thisWeekOfMonth() {
        return DateUtils.weekOfMonth(DateUtils.date());
    }

    public static int thisDayOfMonth() {
        return DateUtils.dayOfMonth(DateUtils.date());
    }

    public static int thisDayOfWeek() {
        return DateUtils.dayOfWeek(DateUtils.date());
    }

    public static Fields.Week thisDayOfWeekEnum() {
        return DateUtils.dayOfWeekEnum(DateUtils.date());
    }

    public static int thisHour(boolean is24HourClock) {
        return DateUtils.hour(DateUtils.date(), is24HourClock);
    }

    public static int thisMinute() {
        return DateUtils.minute(DateUtils.date());
    }

    public static int thisSecond() {
        return DateUtils.second(DateUtils.date());
    }

    public static int thisMillsecond() {
        return DateUtils.millsecond(DateUtils.date());
    }

    public static String yearAndQuarter(Date date) {
        return DateUtils.yearAndQuarter(DateUtils.calendar(date));
    }

    public static String format(Date date, String format) {
        if (null == date || StringUtils.isBlank(format)) {
            return null;
        }
        return DateUtils.format(date, FastDateFormat.getInstance(format));
    }

    public static String format(Date date, DatePrinter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return Fields.NORM_DATETIME_FORMAT.format(date);
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return Fields.NORM_DATE_FORMAT.format(date);
    }

    public static String formatTime(Date date) {
        if (null == date) {
            return null;
        }
        return Fields.NORM_TIME_FORMAT.format(date);
    }

    public static String formatHttpDate(Date date) {
        if (null == date) {
            return null;
        }
        return Fields.HTTP_DATETIME_FORMAT.format(date);
    }

    public static DateTime parse(String dateStr, DateFormat dateFormat) {
        return new DateTime(dateStr, dateFormat);
    }

    public static DateTime parse(String dateStr, DateParser parser) {
        return new DateTime(dateStr, parser);
    }

    public static DateTime parse(String dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime parseDateTime(String dateString) {
        dateString = FileUtils.normalize(dateString);
        return DateUtils.parse(dateString, Fields.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseDate(String dateString) {
        dateString = FileUtils.normalize(dateString);
        return DateUtils.parse(dateString, Fields.NORM_DATE_FORMAT);
    }

    public static DateTime parseTime(String timeString) {
        timeString = FileUtils.normalize(timeString);
        return DateUtils.parse(timeString, Fields.NORM_TIME_FORMAT);
    }

    public static DateTime parseTimeToday(String timeString) {
        timeString = StringUtils.format("{} {}", DateUtils.today(), timeString);
        return DateUtils.parse(timeString, Fields.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseUTC(String utcString) {
        return DateUtils.parse(utcString, Fields.UTC_FORMAT);
    }

    public static DateTime parse(String dateStr) {
        if (null == dateStr) {
            return null;
        }
        dateStr = dateStr.trim().replace("\u65e5", "");
        int length = dateStr.length();
        if (Validator.isNumber(dateStr)) {
            if (length == "yyyyMMddHHmmss".length()) {
                return DateUtils.parse(dateStr, Fields.PURE_DATETIME_FORMAT);
            }
            if (length == "yyyyMMddHHmmssSSS".length()) {
                return DateUtils.parse(dateStr, Fields.PURE_DATETIME_MS_FORMAT);
            }
            if (length == "yyyyMMdd".length()) {
                return DateUtils.parse(dateStr, Fields.PURE_DATE_FORMAT);
            }
            if (length == "HHmmss".length()) {
                return DateUtils.parse(dateStr, Fields.PURE_TIME_FORMAT);
            }
        }
        if (length == "yyyy-MM-dd HH:mm:ss".length() || length == "yyyy-MM-dd HH:mm:ss".length() + 1) {
            if (dateStr.contains("T")) {
                return DateUtils.parseUTC(dateStr);
            }
            return DateUtils.parseDateTime(dateStr);
        }
        if (length == "yyyy-MM-dd".length()) {
            return DateUtils.parseDate(dateStr);
        }
        if (length == "HH:mm:ss".length() || length == "HH:mm:ss".length() + 1) {
            return DateUtils.parseTimeToday(dateStr);
        }
        if (length == "yyyy-MM-dd HH:mm".length() || length == "yyyy-MM-dd HH:mm".length() + 1) {
            return DateUtils.parse(FileUtils.normalize(dateStr), Fields.NORM_DATETIME_MINUTE_FORMAT);
        }
        if (length >= "yyyy-MM-dd HH:mm:ss.SSS".length() - 2) {
            return DateUtils.parse(FileUtils.normalize(dateStr), Fields.NORM_DATETIME_MS_FORMAT);
        }
        throw new CommonException("No format fit for date String [{}] !", dateStr);
    }

    public static DateTime beginOfDay(Date date) {
        return new DateTime(DateUtils.beginOfDay(DateUtils.calendar(date)));
    }

    public static DateTime endOfDay(Date date) {
        return new DateTime(DateUtils.endOfDay(DateUtils.calendar(date)));
    }

    public static Calendar beginOfDay(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar endOfDay(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar;
    }

    public static DateTime beginOfWeek(Date date) {
        return new DateTime(DateUtils.beginOfWeek(DateUtils.calendar(date)));
    }

    public static DateTime endOfWeek(Date date) {
        return new DateTime(DateUtils.endOfWeek(DateUtils.calendar(date)));
    }

    public static Calendar beginOfWeek(Calendar calendar) {
        return DateUtils.beginOfWeek(calendar, true);
    }

    public static Calendar beginOfWeek(Calendar calendar, boolean isMondayAsFirstDay) {
        if (isMondayAsFirstDay) {
            calendar.setFirstDayOfWeek(Fields.Week.MONDAY.getValue());
            calendar.set(7, 2);
        } else {
            calendar.set(7, 1);
        }
        return DateUtils.beginOfDay(calendar);
    }

    public static Calendar endOfWeek(Calendar calendar) {
        return DateUtils.endOfWeek(calendar, true);
    }

    public static Calendar endOfWeek(Calendar calendar, boolean isSundayAsLastDay) {
        if (isSundayAsLastDay) {
            calendar.setFirstDayOfWeek(Fields.Week.MONDAY.getValue());
            calendar.set(7, 1);
        } else {
            calendar.set(7, 7);
        }
        return DateUtils.endOfDay(calendar);
    }

    public static DateTime beginOfMonth(Date date) {
        return new DateTime(DateUtils.beginOfMonth(DateUtils.calendar(date)));
    }

    public static DateTime endOfMonth(Date date) {
        return new DateTime(DateUtils.endOfMonth(DateUtils.calendar(date)));
    }

    public static Calendar beginOfMonth(Calendar calendar) {
        calendar.set(5, 1);
        return DateUtils.beginOfDay(calendar);
    }

    public static Calendar endOfMonth(Calendar calendar) {
        calendar.set(5, calendar.getActualMaximum(5));
        return DateUtils.endOfDay(calendar);
    }

    public static DateTime beginOfQuarter(Date date) {
        return new DateTime(DateUtils.beginOfQuarter(DateUtils.calendar(date)));
    }

    public static DateTime endOfQuarter(Date date) {
        return new DateTime(DateUtils.endOfQuarter(DateUtils.calendar(date)));
    }

    public static Calendar beginOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(Fields.DateField.MONTH.getValue()) / 3 * 3);
        calendar.set(5, 1);
        return DateUtils.beginOfDay(calendar);
    }

    public static Calendar endOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(Fields.DateField.MONTH.getValue()) / 3 * 3 + 2);
        calendar.set(5, calendar.getActualMaximum(5));
        return DateUtils.endOfDay(calendar);
    }

    public static DateTime beginOfYear(Date date) {
        return new DateTime(DateUtils.beginOfYear(DateUtils.calendar(date)));
    }

    public static DateTime endOfYear(Date date) {
        return new DateTime(DateUtils.endOfYear(DateUtils.calendar(date)));
    }

    public static Calendar beginOfYear(Calendar calendar) {
        calendar.set(2, 0);
        return DateUtils.beginOfMonth(calendar);
    }

    public static Calendar endOfYear(Calendar calendar) {
        calendar.set(2, 11);
        return DateUtils.endOfMonth(calendar);
    }

    public static DateTime yesterday() {
        return DateUtils.offsetDay(new DateTime(), -1);
    }

    public static DateTime tomorrow() {
        return DateUtils.offsetDay(new DateTime(), 1);
    }

    public static DateTime lastWeek() {
        return DateUtils.offsetWeek(new DateTime(), -1);
    }

    public static DateTime nextWeek() {
        return DateUtils.offsetWeek(new DateTime(), 1);
    }

    public static DateTime lastMonth() {
        return DateUtils.offsetMonth(new DateTime(), -1);
    }

    public static DateTime nextMonth() {
        return DateUtils.offsetMonth(new DateTime(), 1);
    }

    public static DateTime offsetMillisecond(Date date, int offset) {
        return DateUtils.offset(date, Fields.DateField.MILLISECOND, offset);
    }

    public static DateTime offsetSecond(Date date, int offset) {
        return DateUtils.offset(date, Fields.DateField.SECOND, offset);
    }

    public static DateTime offsetMinute(Date date, int offset) {
        return DateUtils.offset(date, Fields.DateField.MINUTE, offset);
    }

    public static DateTime offsetHour(Date date, int offset) {
        return DateUtils.offset(date, Fields.DateField.HOUR_OF_DAY, offset);
    }

    public static DateTime offsetDay(Date date, int offset) {
        return DateUtils.offset(date, Fields.DateField.DAY_OF_YEAR, offset);
    }

    public static DateTime offsetWeek(Date date, int offset) {
        return DateUtils.offset(date, Fields.DateField.WEEK_OF_YEAR, offset);
    }

    public static DateTime offsetMonth(Date date, int offset) {
        return DateUtils.offset(date, Fields.DateField.MONTH, offset);
    }

    public static DateTime offset(Date date, Fields.DateField dateField, int offset) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(dateField.getValue(), offset);
        return new DateTime(cal.getTime());
    }

    public static long between(Date beginDate, Date endDate, Fields.Unit unit) {
        return DateUtils.between(beginDate, endDate, unit, true);
    }

    public static long between(Date beginDate, Date endDate, Fields.Unit unit, boolean isAbs) {
        return new Between(beginDate, endDate, isAbs).between(unit);
    }

    public static long betweenMs(Date beginDate, Date endDate) {
        return new Between(beginDate, endDate).between(Fields.Unit.MS);
    }

    public static long betweenDay(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = DateUtils.beginOfDay(beginDate);
            endDate = DateUtils.beginOfDay(endDate);
        }
        return DateUtils.between(beginDate, endDate, Fields.Unit.DAY);
    }

    public static long betweenMonth(Date beginDate, Date endDate, boolean isReset) {
        return new Between(beginDate, endDate).betweenMonth(isReset);
    }

    public static long betweenYear(Date beginDate, Date endDate, boolean isReset) {
        return new Between(beginDate, endDate).betweenYear(isReset);
    }

    public static String formatBetween(Date beginDate, Date endDate, BetweenFormat.Level level) {
        return DateUtils.formatBetween(DateUtils.between(beginDate, endDate, Fields.Unit.MS), level);
    }

    public static String formatBetween(Date beginDate, Date endDate) {
        return DateUtils.formatBetween(DateUtils.between(beginDate, endDate, Fields.Unit.MS));
    }

    public static String formatBetween(long betweenMs, BetweenFormat.Level level) {
        return new BetweenFormat(betweenMs, level).format();
    }

    public static String formatBetween(long betweenMs) {
        return new BetweenFormat(betweenMs, BetweenFormat.Level.MILLSECOND).format();
    }

    public static boolean isIn(Date date, Date beginDate, Date endDate) {
        if (date instanceof DateTime) {
            return ((DateTime)date).isIn(beginDate, endDate);
        }
        return new DateTime(date).isIn(beginDate, endDate);
    }

    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static int toIntSecond(Date date) {
        return Integer.parseInt(DateUtils.format(date, "yyMMddHHmm"));
    }

    public static int weekCount(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int startWeekofYear = startCalendar.get(3);
        int endWeekofYear = endCalendar.get(3);
        int count = endWeekofYear - startWeekofYear + 1;
        if (1 != startCalendar.get(7)) {
            --count;
        }
        return count;
    }

    public static TimeInterval timer() {
        return new TimeInterval();
    }

    public static int ageOfNow(Date birthDay) {
        return DateUtils.age(birthDay, DateUtils.date());
    }

    public static int age(Date birthDay, Date dateToCompare) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateToCompare);
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException("Birthday is after date {}!");
        }
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        cal.setTime(birthDay);
        int age = year - cal.get(1);
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            int dayOfMonthBirth = cal.get(5);
            if (dayOfMonth < dayOfMonthBirth) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }

    public static boolean isLeapYear(int year) {
        return new GregorianCalendar().isLeapYear(year);
    }

    public static boolean isExpired(Date startDate, Fields.DateField dateField, int timeLength, Date checkedDate) {
        DateTime endDate = DateUtils.offset(startDate, dateField, timeLength);
        return endDate.after(checkedDate);
    }

    public static String secondToTime(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Seconds must be a positive number!");
        }
        int hour = seconds / 3600;
        int other = seconds % 3600;
        int minute = other / 60;
        int second = other % 60;
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(":");
        if (second < 10) {
            sb.append("0");
        }
        sb.append(second);
        return sb.toString();
    }

    private static String yearAndQuarter(Calendar cal) {
        return "" + cal.get(1) + (cal.get(2) / 3 + 1);
    }

    public static String getTime24() {
        return NORM_DATETIME_FORMAT.format(new Date());
    }

    public static String getTime12() {
        return NORM_DATETIME_FORMAT.format(new Date());
    }

    public static String getTimestamp() {
        return Long.toString(System.currentTimeMillis());
    }

    public static Date toDate(String object) {
        try {
            return NORM_DATETIME_FORMAT.parse(object);
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
    }

    public static Date objectToDate(String object) {
        try {
            return PURE_DATETIME_FORMAT.parse(object);
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
    }

    public static String toString(Date date) {
        return NORM_DATETIME_FORMAT.format(date);
    }

    public static String getMillis() {
        Calendar calendar = Calendar.getInstance();
        return PURE_TIME_MS_FORMAT.format(calendar.getTime());
    }

    public static String addMoth(Date date, String pattern, int num) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        Calendar calender = Calendar.getInstance();
        calender.setTime(date);
        calender.add(2, num);
        return simpleDateFormat.format(calender.getTime());
    }

    public static String addDay(Date date, String pattern, int num) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        Calendar calender = Calendar.getInstance();
        calender.setTime(date);
        calender.add(5, num);
        return simpleDateFormat.format(calender.getTime());
    }

    public static int compareDateWithNow(Date date) {
        Date now = new Date();
        int rnum = date.compareTo(now);
        return rnum;
    }

    public static int compareDateWithNow(long date) {
        long now = DateUtils.dateToUnixTimestamp();
        if (date > now) {
            return 1;
        }
        if (date < now) {
            return -1;
        }
        return 0;
    }

    public static boolean compareWithNow(String object) {
        long expired = DateUtils.dateToUnixTimestamp() - Long.parseLong(object) * 1000L;
        return expired <= 900000L && expired >= -900000L;
    }

    public static long dateToUnixTimestamp(String date) {
        long timestamp = 0L;
        try {
            timestamp = NORM_DATETIME_FORMAT.parse(date).getTime();
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return timestamp;
    }

    public static long dateToUnixTimestamp(String date, String format) {
        long timestamp = 0L;
        try {
            timestamp = new SimpleDateFormat(format).parse(date).getTime();
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return timestamp;
    }

    public static long dateToUnixTimestamp() {
        long timestamp = System.currentTimeMillis();
        return timestamp;
    }

    public static String dateFromUnixTimestamp(String date, String format) {
        return DateUtils.format(new Date(Long.parseLong(date)), format);
    }

    public static String getTodayYMD() {
        return PURE_DATE_FORMAT.format(new Date());
    }

    public static String unixTimestampToDate(long timestamp) {
        return NORM_DATETIME_FORMAT.format(new Date(timestamp));
    }

    public static String TimeStamp2Date(long timestamp, String format) {
        String date = new SimpleDateFormat(format).format(new Date(timestamp));
        return date;
    }

    public static String TimeStamp2Date(long timestamp) {
        return NORM_DATETIME_FORMAT.format(new Date(timestamp));
    }

    public static Map<String, String> getDayDate(int type, String beginkey, String endkey, String begin, String end) {
        HashMap<String, String> map = new HashMap<String, String>();
        Date dBegin = null;
        Date dEnd = null;
        try {
            dBegin = PURE_DATETIME_FORMAT.parse(begin);
            dEnd = PURE_DATETIME_FORMAT.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(dBegin);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            if (type == 1) {
                long beginTime = dBegin.getTime();
                long endTime = dEnd.getTime();
                long inter = endTime - beginTime;
                if (inter < 0L) {
                    inter *= -1L;
                }
                long dateMillSec = 86400000L;
                long dateCnt = inter / dateMillSec;
                long remainder = inter % dateMillSec;
                if (remainder != 0L) {
                    ++dateCnt;
                }
                int day = Integer.parseInt(String.valueOf(dateCnt)) + 1;
                calBegin.add(5, -day);
                calEnd.add(5, -day);
            } else if (type == 2) {
                calBegin.add(1, -1);
                calEnd.add(1, -1);
            }
            map.put(beginkey, PURE_DATETIME_FORMAT.format(calBegin.getTime()));
            map.put(endkey, PURE_DATETIME_FORMAT.format(calEnd.getTime()));
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return map;
    }

    public static List<String> getDaysList(String begin, String end) {
        ArrayList<String> lDate = new ArrayList<String>();
        try {
            Date date1 = PURE_DATETIME_FORMAT.parse(begin);
            Date dEnd = PURE_DATETIME_FORMAT.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            lDate.add(PURE_DATETIME_FORMAT.format(calBegin.getTime()));
            while (calBegin.compareTo(calEnd) < 0) {
                calBegin.add(5, 1);
                Date ss = calBegin.getTime();
                String str = PURE_DATETIME_FORMAT.format(ss);
                lDate.add(str);
            }
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return lDate;
    }

    public static Map<String, String> getWeekDate(int type, String beginkey, String endkey, String beginWkey, String endWkey, String begin, String end, String beginW, String endW) {
        HashMap<String, String> map = new HashMap<String, String>();
        Date date1 = null;
        Date dEnd = null;
        try {
            date1 = PURE_DATETIME_FORMAT.parse(begin);
            dEnd = PURE_DATETIME_FORMAT.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            calBegin.setFirstDayOfWeek(2);
            calEnd.setFirstDayOfWeek(2);
            if (type == 1) {
                int week = DateUtils.getWeekCount(date1, dEnd);
                calBegin.add(3, -week);
                calEnd.add(3, -week);
                map.put(beginWkey, String.valueOf(calBegin.get(3)));
                map.put(endWkey, String.valueOf(calEnd.get(3)));
                int day_of_week = calBegin.get(7) - 1;
                if (day_of_week == 0) {
                    day_of_week = 7;
                }
                calBegin.add(5, -day_of_week + 1);
                int day_of_week_end = calEnd.get(7) - 1;
                if (day_of_week_end == 0) {
                    day_of_week_end = 7;
                }
                calEnd.add(5, -day_of_week_end + 7);
            } else if (type == 2) {
                calBegin.add(1, -1);
                calEnd.add(1, -1);
                calBegin.set(3, Integer.parseInt(beginW));
                calEnd.set(3, Integer.parseInt(endW));
                map.put(beginWkey, beginW);
                map.put(endWkey, endW);
                int day_of_week = calBegin.get(7) - 1;
                if (day_of_week == 0) {
                    day_of_week = 7;
                }
                calBegin.add(5, -day_of_week + 1);
                int day_of_week_end = calEnd.get(7) - 1;
                if (day_of_week_end == 0) {
                    day_of_week_end = 7;
                }
                calEnd.add(5, -day_of_week_end + 7);
            }
            map.put(beginkey, PURE_DATETIME_FORMAT.format(calBegin.getTime()));
            map.put(endkey, PURE_DATETIME_FORMAT.format(calEnd.getTime()));
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getWeeksList(String begin, String end, String startw, String endW) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        ArrayList<String> lDate = new ArrayList<String>();
        Date date1 = null;
        Date dEnd = null;
        try {
            date1 = sdf.parse(begin);
            dEnd = sdf.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            calBegin.setFirstDayOfWeek(2);
            int beginww = Integer.parseInt(startw);
            int endww = Integer.parseInt(endW);
            int beginY = calBegin.get(1);
            int endY = calEnd.get(1);
            int weekall = DateUtils.getAllWeeks(beginY + "");
            do {
                lDate.add(beginY + "\u5e74\u7b2c" + beginww + "\u5468");
                if (beginww == weekall) {
                    beginww = 0;
                    weekall = DateUtils.getAllWeeks(++beginY + "");
                }
                if (beginY == endY && beginww == endww) return lDate;
                ++beginww;
            } while (beginY <= endY);
            return lDate;
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
    }

    public static List<String> getYearMouthBy(String StartDate, String endDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        Date date1 = null;
        Date date2 = null;
        try {
            date1 = df.parse(StartDate);
            date2 = df.parse(endDate);
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        ArrayList<String> list = new ArrayList<String>();
        list.add(df.format(date1));
        c1.setTime(date1);
        c2.setTime(date2);
        while (c1.compareTo(c2) < 0) {
            c1.add(2, 1);
            Date ss = c1.getTime();
            String str = df.format(ss);
            list.add(str);
        }
        return list;
    }

    public static Map<String, String> getMonthDate(int type, String beginkey, String endkey, String begin, String end) {
        HashMap<String, String> map = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date date1 = null;
        Date dEnd = null;
        try {
            date1 = sdf.parse(begin);
            dEnd = sdf.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            if (type == 1) {
                int year = calBegin.get(1);
                int month = calBegin.get(2);
                int year1 = calEnd.get(1);
                int month1 = calEnd.get(2);
                int result = year == year1 ? month1 - month : 12 * (year1 - year) + month1 - month;
                calBegin.add(2, -(++result));
                calEnd.add(2, -result);
            } else if (type == 2) {
                calBegin.add(1, -1);
                calEnd.add(1, -1);
            }
            map.put(beginkey, sdf.format(calBegin.getTime()));
            map.put(endkey, sdf.format(calEnd.getTime()));
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return map;
    }

    public static Map<String, String> getYearDate(String beginkey, String endkey, String begin, String end) {
        HashMap<String, String> map = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date date1 = null;
        Date dEnd = null;
        try {
            date1 = sdf.parse(begin);
            dEnd = sdf.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            int year = calBegin.get(1);
            int year1 = calEnd.get(1);
            int result = year1 - year + 1;
            calBegin.add(1, -result);
            calEnd.add(1, -result);
            map.put(beginkey, sdf.format(calBegin.getTime()));
            map.put(endkey, sdf.format(calEnd.getTime()));
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return map;
    }

    public static List<String> getYearBy(String StartDate, String endDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        Date date1 = null;
        Date date2 = null;
        try {
            date1 = df.parse(StartDate);
            date2 = df.parse(endDate);
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        ArrayList<String> list = new ArrayList<String>();
        list.add(df.format(date1));
        c1.setTime(date1);
        c2.setTime(date2);
        while (c1.compareTo(c2) < 0) {
            c1.add(1, 1);
            Date ss = c1.getTime();
            String str = df.format(ss);
            list.add(str);
        }
        return list;
    }

    public static int getWeekCount(Date start, Date end) {
        Calendar c_begin = Calendar.getInstance();
        c_begin.setTime(start);
        Calendar c_end = Calendar.getInstance();
        c_end.setTime(end);
        int count = 0;
        c_begin.setFirstDayOfWeek(2);
        c_end.setFirstDayOfWeek(2);
        while (c_begin.before(c_end)) {
            if (c_begin.get(7) == 1) {
                ++count;
            }
            c_begin.add(6, 1);
        }
        return count;
    }

    public static int getAllWeeks(String year) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(PURE_DATETIME_FORMAT.parse(year + "-12-31"));
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        calendar.setFirstDayOfWeek(2);
        int week = calendar.get(3);
        if (week != 53) {
            week = 52;
        }
        return week;
    }

    public static Map<String, String> getQuarterDate(int type, String beginkey, String endkey, String beginWkey, String endWkey, String begin, String end, String beginW, String endW) {
        HashMap<String, String> map = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date date1 = null;
        Date dEnd = null;
        try {
            date1 = sdf.parse(begin);
            dEnd = sdf.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            calBegin.set(2, DateUtils.setMonthByQuarter(Integer.parseInt(beginW)));
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            calEnd.set(2, DateUtils.setMonthByQuarter(Integer.parseInt(endW)));
            if (type == 1) {
                int quarter = ((Integer.parseInt(end) - Integer.parseInt(begin)) * 4 + (Integer.parseInt(endW) - Integer.parseInt(beginW)) + 1) * 3;
                calBegin.add(2, -quarter);
                calEnd.add(2, -quarter);
                map.put(beginWkey, String.valueOf(DateUtils.getQuarterByMonth(calBegin.get(2))));
                map.put(endWkey, String.valueOf(DateUtils.getQuarterByMonth(calEnd.get(2))));
            } else if (type == 2) {
                calBegin.add(1, -1);
                calEnd.add(1, -1);
                map.put(beginWkey, beginW);
                map.put(endWkey, endW);
            }
            map.put(beginkey, calBegin.get(1) + "-" + DateUtils.setMonthByQuarterToString(0, Integer.parseInt((String)map.get(beginWkey))));
            map.put(endkey, calEnd.get(1) + "-" + DateUtils.setMonthByQuarterToString(1, Integer.parseInt((String)map.get(endWkey))));
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return map;
    }

    public static List<String> getQuarterBy(String StartDate, String beginQ, String endDate, String endQ) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date date1 = null;
        Date dEnd = null;
        try {
            date1 = sdf.parse(StartDate);
            dEnd = sdf.parse(endDate);
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(date1);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        ArrayList<String> list = new ArrayList<String>();
        int beginY = calBegin.get(1);
        int beginYQ = Integer.parseInt(beginQ);
        int endY = calEnd.get(1);
        int endYQ = Integer.parseInt(endQ);
        while (true) {
            list.add(beginY + "\u5e74\u7b2c" + beginYQ + "\u5b63\u5ea6");
            if (beginY == endY && beginYQ == endYQ) {
                return list;
            }
            if (++beginYQ <= 4) continue;
            beginYQ = 1;
            ++beginY;
        }
    }

    public static int setMonthByQuarter(int quarter) {
        if (quarter == 1) {
            return 1;
        }
        if (quarter == 2) {
            return 4;
        }
        if (quarter == 3) {
            return 7;
        }
        if (quarter == 4) {
            return 10;
        }
        return 1;
    }

    public static String setMonthByQuarterToString(int type, int quarter) {
        if (quarter == 1) {
            if (type == 1) {
                return "03";
            }
            return "01";
        }
        if (quarter == 2) {
            if (type == 1) {
                return "06";
            }
            return "04";
        }
        if (quarter == 3) {
            if (type == 1) {
                return "09";
            }
            return "07";
        }
        if (quarter == 4) {
            if (type == 1) {
                return "12";
            }
            return "10";
        }
        return "01";
    }

    public static int getQuarterByMonth(int month) {
        int quarter = 1;
        if (month >= 1 && month <= 3) {
            return 1;
        }
        if (month >= 4 && month <= 6) {
            return 2;
        }
        if (month >= 7 && month <= 9) {
            return 3;
        }
        if (month >= 10 && month <= 12) {
            return 4;
        }
        return quarter;
    }

    public static String getTimeFormatText(Date date) {
        if (date == null) {
            return null;
        }
        long diff = System.currentTimeMillis() - date.getTime();
        long r = 0L;
        if (diff > Fields.Unit.DAY.getMillis()) {
            r = diff / Fields.Unit.DAY.getMillis();
            return r + "\u5929\u524d";
        }
        if (diff > Fields.Unit.HOUR.getMillis()) {
            r = diff / Fields.Unit.HOUR.getMillis();
            return r + "\u4e2a\u5c0f\u65f6\u524d";
        }
        if (diff > Fields.Unit.MINUTE.getMillis()) {
            r = diff / Fields.Unit.MINUTE.getMillis();
            return r + "\u5206\u949f\u524d";
        }
        return "\u521a\u521a";
    }

    public static String getTimeCN(String date) {
        return NORM_DATE_CN_FORMAT.format(DateUtils.toDate(date));
    }

    public static String getDayCN(String date) {
        return NORM_MONTH_CN_FORMAT.format(DateUtils.toDate(date));
    }

    public static String getWeekCN(String date) {
        int w = 0;
        try {
            Calendar cal = Calendar.getInstance();
            Date d = PURE_DATETIME_FORMAT.parse(date);
            cal.setTime(d);
            w = cal.get(7) - 1;
            if (w < 0) {
                w = 0;
            }
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return Fields.Week.of(w).toChinese("\u661f\u671f");
    }

    public static int compareDate(String date1, String date2) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date dt1 = f.parse(date1);
            Date dt2 = f.parse(date2);
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
    }

    public static Date addYears(Date date, int amount) {
        return DateUtils.add(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return DateUtils.add(date, 2, amount);
    }

    public static Date addWeeks(Date date, int amount) {
        return DateUtils.add(date, 3, amount);
    }

    public static Date addDays(Date date, int amount) {
        return DateUtils.add(date, 5, amount);
    }

    public static Date addHours(Date date, int amount) {
        return DateUtils.add(date, 11, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtils.add(date, 12, amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return DateUtils.add(date, 13, amount);
    }

    public static Date addMilliseconds(Date date, int amount) {
        return DateUtils.add(date, 14, amount);
    }

    private static Date add(Date date, int calendarField, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static Date setYears(Date date, int amount) {
        return DateUtils.set(date, 1, amount);
    }

    public static Date setMonths(Date date, int amount) {
        return DateUtils.set(date, 2, amount);
    }

    public static Date setDays(Date date, int amount) {
        return DateUtils.set(date, 5, amount);
    }

    public static Date setHours(Date date, int amount) {
        return DateUtils.set(date, 11, amount);
    }

    public static Date setMinutes(Date date, int amount) {
        return DateUtils.set(date, 12, amount);
    }

    public static Date setSeconds(Date date, int amount) {
        return DateUtils.set(date, 13, amount);
    }

    public static Date setMilliseconds(Date date, int amount) {
        return DateUtils.set(date, 14, amount);
    }

    private static Date set(Date date, int calendarField, int amount) {
        Calendar c = Calendar.getInstance();
        c.setLenient(false);
        c.setTime(date);
        c.set(calendarField, amount);
        return c.getTime();
    }

    public static Calendar toCalendar(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static Calendar toCalendar(Date date, TimeZone tz) {
        Calendar c = Calendar.getInstance(tz);
        c.setTime(date);
        return c;
    }

    public static Integer getAge(String birthday) {
        Integer age = 0;
        try {
            Date birthDay = new Date(Long.parseLong(birthday));
            Calendar cal = Calendar.getInstance();
            if (cal.before(birthDay)) {
                throw new IllegalArgumentException("The birthDay is before Now.It's unbelievable!");
            }
            int yearNow = cal.get(1);
            int monthNow = cal.get(2);
            int dayOfMonthNow = cal.get(5);
            cal.setTime(birthDay);
            int yearBirth = cal.get(1);
            int monthBirth = cal.get(2);
            int dayOfMonthBirth = cal.get(5);
            age = yearNow - yearBirth;
            if (monthNow <= monthBirth) {
                if (monthNow == monthBirth) {
                    if (dayOfMonthNow < dayOfMonthBirth) {
                        Integer n = age;
                        Integer n2 = age = Integer.valueOf(age - 1);
                    }
                } else {
                    Integer n = age;
                    Integer n3 = age = Integer.valueOf(age - 1);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return age;
    }

    public int getDaysBetween(Calendar d1, Calendar d2) {
        if (d1.after(d2)) {
            Calendar swap = d1;
            d1 = d2;
            d2 = swap;
        }
        int days = d2.get(6) - d1.get(6);
        int y2 = d2.get(1);
        if (d1.get(1) != y2) {
            d1 = (Calendar)d1.clone();
            do {
                days += d1.getActualMaximum(6);
                d1.add(1, 1);
            } while (d1.get(1) != y2);
        }
        return days;
    }

    public int getWorkingDay(Calendar d1, Calendar d2) {
        int result = -1;
        if (d1.after(d2)) {
            Calendar swap = d1;
            d1 = d2;
            d2 = swap;
        }
        int charge_start_date = 0;
        int charge_end_date = 0;
        int stmp = 7 - d1.get(7);
        int etmp = 7 - d2.get(7);
        if (stmp != 0 && stmp != 6) {
            charge_start_date = stmp - 1;
        }
        if (etmp != 0 && etmp != 6) {
            charge_end_date = etmp - 1;
        }
        result = this.getDaysBetween(this.getNextMonday(d1), this.getNextMonday(d2)) / 7 * 5 + charge_start_date - charge_end_date;
        return result;
    }

    public String getChineseWeek(Calendar date) {
        String[] dayNames = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        int dayOfWeek = date.get(7);
        return dayNames[dayOfWeek - 1];
    }

    public Calendar getNextMonday(Calendar date) {
        Calendar result = null;
        result = date;
        do {
            result = (Calendar)result.clone();
            result.add(5, 1);
        } while (result.get(7) != 2);
        return result;
    }

    public int getHolidays(Calendar d1, Calendar d2) {
        return this.getDaysBetween(d1, d2) - this.getWorkingDay(d1, d2);
    }
}

