/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import org.aoju.bus.core.lang.exception.CommonException;

public class Caller {
    private static final ICaller CALLER_INSTANCE = Caller.tryCreateCaller();

    public static Class<?> getCaller() {
        return CALLER_INSTANCE.getCaller();
    }

    public static Class<?> getCallerCaller() {
        return CALLER_INSTANCE.getCallerCaller();
    }

    public static Class<?> getCaller(int depth) {
        return CALLER_INSTANCE.getCaller(depth);
    }

    public static boolean isCalledBy(Class<?> clazz) {
        return CALLER_INSTANCE.isCalledBy(clazz);
    }

    private static ICaller tryCreateCaller() {
        ICaller caller;
        try {
            caller = new SecurityManagerCaller();
        }
        catch (Exception e) {
            caller = new StackTraceCaller();
        }
        return caller;
    }

    private static class StackTraceCaller
    implements ICaller {
        private static final int OFFSET = 2;

        private StackTraceCaller() {
        }

        @Override
        public Class<?> getCaller() {
            String className = Thread.currentThread().getStackTrace()[3].getClassName();
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new CommonException("[" + className + "] not found!");
            }
        }

        @Override
        public Class<?> getCallerCaller() {
            String className = Thread.currentThread().getStackTrace()[4].getClassName();
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new CommonException("[" + className + "] not found!");
            }
        }

        @Override
        public Class<?> getCaller(int depth) {
            String className = Thread.currentThread().getStackTrace()[2 + depth].getClassName();
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new CommonException("[" + className + "] not found!");
            }
        }

        @Override
        public boolean isCalledBy(Class<?> clazz) {
            for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                if (!element.getClassName().equals(clazz.getName())) continue;
                return true;
            }
            return false;
        }
    }

    private static class SecurityManagerCaller
    extends SecurityManager
    implements ICaller {
        private static final int OFFSET = 1;

        private SecurityManagerCaller() {
        }

        @Override
        public Class<?> getCaller() {
            return this.getClassContext()[2];
        }

        @Override
        public Class<?> getCallerCaller() {
            return this.getClassContext()[3];
        }

        @Override
        public Class<?> getCaller(int depth) {
            Class<?>[] context = this.getClassContext();
            if (1 + depth < context.length) {
                return context[1 + depth];
            }
            return null;
        }

        @Override
        public boolean isCalledBy(Class<?> clazz) {
            Class<?>[] classes;
            for (Class<?> contextClass : classes = this.getClassContext()) {
                if (!contextClass.equals(clazz)) continue;
                return true;
            }
            return false;
        }
    }

    private static interface ICaller {
        public Class<?> getCaller();

        public Class<?> getCallerCaller();

        public Class<?> getCaller(int var1);

        public boolean isCalledBy(Class<?> var1);
    }
}

