/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import org.aoju.bus.core.key.ObjectID;
import org.aoju.bus.core.utils.DateUtils;
import org.aoju.bus.core.utils.ReflectUtils;

public class EntityUtils {
    public static <T> void setCreateInfo(T entity) {
        String id = ObjectID.id();
        String[] fields = new String[]{"id", "creator", "created"};
        Object[] value = new Object[]{id, EntityUtils.getValue(entity, "x_user_id"), DateUtils.getTimestamp()};
        EntityUtils.setValue(entity, fields, value);
    }

    public static <T> void setUpdatedInfo(T entity) {
        String[] fields = new String[]{"modifier", "modified"};
        Object[] value = new Object[]{EntityUtils.getValue(entity, "x_user_id"), DateUtils.getTimestamp()};
        EntityUtils.setValue(entity, fields, value);
    }

    public static <T> void setCreatAndUpdatInfo(T entity) {
        EntityUtils.setCreateInfo(entity);
        EntityUtils.setUpdatedInfo(entity);
    }

    private static <T> void setValue(T entity, String[] fields, Object[] value) {
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (!ReflectUtils.hasField(entity, field)) continue;
            ReflectUtils.invokeSetter(entity, field, value[i]);
        }
    }

    private static <T> Object getValue(T entity, String field) {
        if (ReflectUtils.hasField(entity, field)) {
            Object object = ReflectUtils.invokeGetter(entity, field);
            return object != null ? object.toString() : null;
        }
        return null;
    }

    public static <T> boolean isPKNotNull(T entity, String field) {
        if (!ReflectUtils.hasField(entity, field)) {
            return false;
        }
        Object value = ReflectUtils.getFieldValue(entity, field);
        return value != null && !"".equals(value);
    }
}

