/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.bean.copier.provider;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.aoju.bus.core.bean.BeanDesc;
import org.aoju.bus.core.bean.copier.ValueProvider;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.StringUtils;

public class BeanValueProvider
implements ValueProvider<String> {
    final Map<String, BeanDesc.PropDesc> sourcePdMap;
    private Object source;
    private boolean ignoreError;

    public BeanValueProvider(Object bean, boolean ignoreCase, boolean ignoreError) {
        this.source = bean;
        this.ignoreError = ignoreError;
        this.sourcePdMap = BeanUtils.getBeanDesc(this.source.getClass()).getPropMap(ignoreCase);
    }

    @Override
    public Object value(String key, Type valueType) {
        block4: {
            Method getter;
            BeanDesc.PropDesc sourcePd = this.sourcePdMap.get(key);
            if (null == sourcePd && (Boolean.class == valueType || Boolean.TYPE == valueType)) {
                sourcePd = this.sourcePdMap.get(StringUtils.upperFirstAndAddPre(key, "is"));
            }
            if (null != sourcePd && null != (getter = sourcePd.getGetter())) {
                try {
                    return getter.invoke(this.source, new Object[0]);
                }
                catch (Exception e) {
                    if (this.ignoreError) break block4;
                    throw new CommonException("Inject [{}] error!", key);
                }
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(String key) {
        return this.sourcePdMap.containsKey(key) || this.sourcePdMap.containsKey(StringUtils.upperFirstAndAddPre(key, "is"));
    }
}

