/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert.impl;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.utils.DateUtils;
import org.aoju.bus.core.utils.StringUtils;

public class DateConverter
extends AbstractConverter<Date> {
    private Class<? extends Date> targetType;
    private String format;

    public DateConverter(Class<? extends Date> targetType) {
        this.targetType = targetType;
    }

    public DateConverter(Class<? extends Date> targetType, String format) {
        this.targetType = targetType;
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Date convertInternal(Object value) {
        long mills = -1L;
        if (value instanceof Calendar) {
            mills = ((Calendar)value).getTimeInMillis();
        } else if (value instanceof Long) {
            mills = (Long)value;
        } else {
            String valueStr = this.convertToStr(value);
            try {
                mills = StringUtils.isBlank(this.format) ? DateUtils.parse(valueStr).getTime() : DateUtils.parse(valueStr, this.format).getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mills < 0L) {
            return null;
        }
        if (Date.class == this.targetType) {
            return new Date(mills);
        }
        if (DateTime.class == this.targetType) {
            return new DateTime(mills);
        }
        if (java.sql.Date.class == this.targetType) {
            return new java.sql.Date(mills);
        }
        if (Time.class == this.targetType) {
            return new Time(mills);
        }
        if (Timestamp.class == this.targetType) {
            return new Timestamp(mills);
        }
        throw new UnsupportedOperationException(StringUtils.format("Unsupport Date type: {}", this.targetType.getName()));
    }
}

