/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.aoju.bus.core.utils.ArrayUtils;

public class ModifierUtils {
    public static boolean hasModifier(Class<?> clazz, ModifierType ... modifierTypes) {
        if (null == clazz || ArrayUtils.isEmpty((Object[])modifierTypes)) {
            return false;
        }
        return 0 != (clazz.getModifiers() & ModifierUtils.modifiersToInt(modifierTypes));
    }

    public static boolean hasModifier(Constructor<?> constructor, ModifierType ... modifierTypes) {
        if (null == constructor || ArrayUtils.isEmpty((Object[])modifierTypes)) {
            return false;
        }
        return 0 != (constructor.getModifiers() & ModifierUtils.modifiersToInt(modifierTypes));
    }

    public static boolean hasModifier(Method method, ModifierType ... modifierTypes) {
        if (null == method || ArrayUtils.isEmpty((Object[])modifierTypes)) {
            return false;
        }
        return 0 != (method.getModifiers() & ModifierUtils.modifiersToInt(modifierTypes));
    }

    public static boolean hasModifier(Field field, ModifierType ... modifierTypes) {
        if (null == field || ArrayUtils.isEmpty((Object[])modifierTypes)) {
            return false;
        }
        return 0 != (field.getModifiers() & ModifierUtils.modifiersToInt(modifierTypes));
    }

    public static boolean isPublic(Field field) {
        return ModifierUtils.hasModifier(field, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Method method) {
        return ModifierUtils.hasModifier(method, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Class<?> clazz) {
        return ModifierUtils.hasModifier(clazz, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Constructor<?> constructor) {
        return ModifierUtils.hasModifier(constructor, ModifierType.PUBLIC);
    }

    public static boolean isStatic(Field field) {
        return ModifierUtils.hasModifier(field, ModifierType.STATIC);
    }

    public static boolean isStatic(Method method) {
        return ModifierUtils.hasModifier(method, ModifierType.STATIC);
    }

    public static boolean isStatic(Class<?> clazz) {
        return ModifierUtils.hasModifier(clazz, ModifierType.STATIC);
    }

    private static int modifiersToInt(ModifierType ... modifierTypes) {
        int modifier = modifierTypes[0].getValue();
        for (int i = 1; i < modifierTypes.length; ++i) {
            modifier &= modifierTypes[i].getValue();
        }
        return modifier;
    }

    public static enum ModifierType {
        PUBLIC(1),
        PRIVATE(2),
        PROTECTED(4),
        STATIC(8),
        FINAL(16),
        SYNCHRONIZED(32),
        VOLATILE(64),
        TRANSIENT(128),
        NATIVE(256),
        ABSTRACT(1024),
        STRICT(2048);

        private int value;

        private ModifierType(int modifier) {
            this.value = modifier;
        }

        public int getValue() {
            return this.value;
        }
    }
}

