/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.util.Map;
import org.aoju.bus.core.convert.Converter;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.CharUtils;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.StringUtils;

public abstract class AbstractConverter<T>
implements Converter<T> {
    @Override
    public T convert(Object value, T defaultValue) {
        Class<Object> targetType = this.getTargetType();
        if (null == targetType && null == defaultValue) {
            throw new NullPointerException(StringUtils.format("[type] and [defaultValue] are both null for Converter [{}], we can not know what type to convert !", this.getClass().getName()));
        }
        if (null == targetType) {
            targetType = defaultValue.getClass();
        }
        if (null == value) {
            return defaultValue;
        }
        if (null == defaultValue || targetType.isInstance(defaultValue)) {
            T result;
            if (targetType.isInstance(value) && !Map.class.isAssignableFrom(targetType)) {
                return (T)targetType.cast(value);
            }
            try {
                result = this.convertInternal(value);
            }
            catch (RuntimeException e) {
                return defaultValue;
            }
            return null == result ? defaultValue : result;
        }
        throw new IllegalArgumentException(StringUtils.format("Default value [{}] is not the instance of [{}]", defaultValue, targetType));
    }

    public T convertQuietly(Object value, T defaultValue) {
        try {
            return this.convert(value, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected abstract T convertInternal(Object var1);

    protected String convertToStr(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (ArrayUtils.isArray(value)) {
            return ArrayUtils.toString(value);
        }
        if (CharUtils.isChar(value)) {
            return CharUtils.toString(((Character)value).charValue());
        }
        return value.toString();
    }

    public Class<T> getTargetType() {
        return ClassUtils.getTypeArgument(this.getClass());
    }
}

