/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;

public class BytesResource
implements Resource {
    private byte[] bytes;
    private String name;

    public BytesResource(byte[] bytes) {
        this(bytes, null);
    }

    public BytesResource(byte[] bytes, String name) {
        this.bytes = bytes;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public BufferedReader getReader(java.nio.charset.Charset charset) {
        return new BufferedReader(new StringReader(this.readStr(charset)));
    }

    @Override
    public String readStr(java.nio.charset.Charset charset) throws InstrumentException {
        return StringUtils.str(this.bytes, charset);
    }

    @Override
    public String readUtf8Str() throws InstrumentException {
        return this.readStr(Charset.UTF_8);
    }

    @Override
    public byte[] readBytes() throws InstrumentException {
        return this.bytes;
    }
}

