/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;
import org.aoju.bus.core.builder.Builder;
import org.aoju.bus.core.builder.ReflectionToStringBuilder;
import org.aoju.bus.core.utils.ArrayUtils;

public class CompareToBuilder
implements Builder<Integer> {
    private int comparison = 0;

    public static int reflectionCompare(Object left, Object right) {
        return CompareToBuilder.reflectionCompare(left, right, false, null, new String[0]);
    }

    public static int reflectionCompare(Object left, Object right, boolean compareTransients) {
        return CompareToBuilder.reflectionCompare(left, right, compareTransients, null, new String[0]);
    }

    public static int reflectionCompare(Object left, Object right, Collection<String> excludeFields) {
        return CompareToBuilder.reflectionCompare(left, right, ReflectionToStringBuilder.toNoNullStringArray(excludeFields));
    }

    public static int reflectionCompare(Object left, Object right, String ... excludeFields) {
        return CompareToBuilder.reflectionCompare(left, right, false, null, excludeFields);
    }

    public static int reflectionCompare(Object left, Object right, boolean compareTransients, Class<?> reflectUpToClass, String ... excludeFields) {
        if (left == right) {
            return 0;
        }
        if (left == null || right == null) {
            throw new NullPointerException();
        }
        Class<?> leftClazz = left.getClass();
        if (!leftClazz.isInstance(right)) {
            throw new ClassCastException();
        }
        CompareToBuilder compareToBuilder = new CompareToBuilder();
        CompareToBuilder.reflectionAppend(left, right, leftClazz, compareToBuilder, compareTransients, excludeFields);
        while (leftClazz.getSuperclass() != null && leftClazz != reflectUpToClass) {
            leftClazz = leftClazz.getSuperclass();
            CompareToBuilder.reflectionAppend(left, right, leftClazz, compareToBuilder, compareTransients, excludeFields);
        }
        return compareToBuilder.toComparison();
    }

    private static void reflectionAppend(Object left, Object right, Class<?> clazz, CompareToBuilder builder, boolean useTransients, String[] excludeFields) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (int i = 0; i < fields.length && builder.comparison == 0; ++i) {
            AccessibleObject f = fields[i];
            if (ArrayUtils.contains(excludeFields, ((Field)f).getName()) || ((Field)f).getName().contains("$") || !useTransients && Modifier.isTransient(((Field)f).getModifiers()) || Modifier.isStatic(((Field)f).getModifiers())) continue;
            try {
                builder.append(((Field)f).get(left), ((Field)f).get(right));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new InternalError("Unexpected IllegalAccessException");
            }
        }
    }

    public CompareToBuilder appendSuper(int superCompareTo) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = superCompareTo;
        return this;
    }

    public CompareToBuilder append(Object left, Object right) {
        return this.append(left, right, null);
    }

    public CompareToBuilder append(Object left, Object right, Comparator<?> comparator) {
        if (this.comparison != 0) {
            return this;
        }
        if (left == right) {
            return this;
        }
        if (left == null) {
            this.comparison = -1;
            return this;
        }
        if (right == null) {
            this.comparison = 1;
            return this;
        }
        if (left.getClass().isArray()) {
            this.appendArray(left, right, comparator);
        } else if (comparator == null) {
            Comparable comparable = (Comparable)left;
            this.comparison = comparable.compareTo(right);
        } else {
            Comparator<?> comparator2 = comparator;
            this.comparison = comparator2.compare(left, right);
        }
        return this;
    }

    private void appendArray(Object left, Object right, Comparator<?> comparator) {
        if (left instanceof long[]) {
            this.append((long[])left, (long[])right);
        } else if (left instanceof int[]) {
            this.append((int[])left, (int[])right);
        } else if (left instanceof short[]) {
            this.append((short[])left, (short[])right);
        } else if (left instanceof char[]) {
            this.append((char[])left, (char[])right);
        } else if (left instanceof byte[]) {
            this.append((byte[])left, (byte[])right);
        } else if (left instanceof double[]) {
            this.append((double[])left, (double[])right);
        } else if (left instanceof float[]) {
            this.append((float[])left, (float[])right);
        } else if (left instanceof boolean[]) {
            this.append((boolean[])left, (boolean[])right);
        } else {
            this.append((Object[])left, (Object[])right, comparator);
        }
    }

    public CompareToBuilder append(long left, long right) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Long.compare(left, right);
        return this;
    }

    public CompareToBuilder append(int left, int right) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Integer.compare(left, right);
        return this;
    }

    public CompareToBuilder append(short left, short right) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Short.compare(left, right);
        return this;
    }

    public CompareToBuilder append(char left, char right) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Character.compare(left, right);
        return this;
    }

    public CompareToBuilder append(byte left, byte right) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Byte.compare(left, right);
        return this;
    }

    public CompareToBuilder append(double left, double right) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Double.compare(left, right);
        return this;
    }

    public CompareToBuilder append(float left, float right) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Float.compare(left, right);
        return this;
    }

    public CompareToBuilder append(boolean left, boolean right) {
        if (this.comparison != 0) {
            return this;
        }
        if (left == right) {
            return this;
        }
        this.comparison = left ? 1 : -1;
        return this;
    }

    public CompareToBuilder append(Object[] left, Object[] right) {
        return this.append(left, right, (Comparator<?>)null);
    }

    public CompareToBuilder append(Object[] left, Object[] right, Comparator<?> comparator) {
        if (this.comparison != 0) {
            return this;
        }
        if (left == right) {
            return this;
        }
        if (left == null) {
            this.comparison = -1;
            return this;
        }
        if (right == null) {
            this.comparison = 1;
            return this;
        }
        if (left.length != right.length) {
            this.comparison = left.length < right.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < left.length && this.comparison == 0; ++i) {
            this.append(left[i], right[i], comparator);
        }
        return this;
    }

    public CompareToBuilder append(long[] left, long[] right) {
        if (this.comparison != 0) {
            return this;
        }
        if (left == right) {
            return this;
        }
        if (left == null) {
            this.comparison = -1;
            return this;
        }
        if (right == null) {
            this.comparison = 1;
            return this;
        }
        if (left.length != right.length) {
            this.comparison = left.length < right.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < left.length && this.comparison == 0; ++i) {
            this.append(left[i], right[i]);
        }
        return this;
    }

    public CompareToBuilder append(int[] left, int[] right) {
        if (this.comparison != 0) {
            return this;
        }
        if (left == right) {
            return this;
        }
        if (left == null) {
            this.comparison = -1;
            return this;
        }
        if (right == null) {
            this.comparison = 1;
            return this;
        }
        if (left.length != right.length) {
            this.comparison = left.length < right.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < left.length && this.comparison == 0; ++i) {
            this.append(left[i], right[i]);
        }
        return this;
    }

    public CompareToBuilder append(short[] left, short[] right) {
        if (this.comparison != 0) {
            return this;
        }
        if (left == right) {
            return this;
        }
        if (left == null) {
            this.comparison = -1;
            return this;
        }
        if (right == null) {
            this.comparison = 1;
            return this;
        }
        if (left.length != right.length) {
            this.comparison = left.length < right.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < left.length && this.comparison == 0; ++i) {
            this.append(left[i], right[i]);
        }
        return this;
    }

    public CompareToBuilder append(char[] left, char[] right) {
        if (this.comparison != 0) {
            return this;
        }
        if (left == right) {
            return this;
        }
        if (left == null) {
            this.comparison = -1;
            return this;
        }
        if (right == null) {
            this.comparison = 1;
            return this;
        }
        if (left.length != right.length) {
            this.comparison = left.length < right.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < left.length && this.comparison == 0; ++i) {
            this.append(left[i], right[i]);
        }
        return this;
    }

    public CompareToBuilder append(byte[] left, byte[] right) {
        if (this.comparison != 0) {
            return this;
        }
        if (left == right) {
            return this;
        }
        if (left == null) {
            this.comparison = -1;
            return this;
        }
        if (right == null) {
            this.comparison = 1;
            return this;
        }
        if (left.length != right.length) {
            this.comparison = left.length < right.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < left.length && this.comparison == 0; ++i) {
            this.append(left[i], right[i]);
        }
        return this;
    }

    public CompareToBuilder append(double[] left, double[] right) {
        if (this.comparison != 0) {
            return this;
        }
        if (left == right) {
            return this;
        }
        if (left == null) {
            this.comparison = -1;
            return this;
        }
        if (right == null) {
            this.comparison = 1;
            return this;
        }
        if (left.length != right.length) {
            this.comparison = left.length < right.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < left.length && this.comparison == 0; ++i) {
            this.append(left[i], right[i]);
        }
        return this;
    }

    public CompareToBuilder append(float[] left, float[] right) {
        if (this.comparison != 0) {
            return this;
        }
        if (left == right) {
            return this;
        }
        if (left == null) {
            this.comparison = -1;
            return this;
        }
        if (right == null) {
            this.comparison = 1;
            return this;
        }
        if (left.length != right.length) {
            this.comparison = left.length < right.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < left.length && this.comparison == 0; ++i) {
            this.append(left[i], right[i]);
        }
        return this;
    }

    public CompareToBuilder append(boolean[] left, boolean[] right) {
        if (this.comparison != 0) {
            return this;
        }
        if (left == right) {
            return this;
        }
        if (left == null) {
            this.comparison = -1;
            return this;
        }
        if (right == null) {
            this.comparison = 1;
            return this;
        }
        if (left.length != right.length) {
            this.comparison = left.length < right.length ? -1 : 1;
            return this;
        }
        for (int i = 0; i < left.length && this.comparison == 0; ++i) {
            this.append(left[i], right[i]);
        }
        return this;
    }

    public int toComparison() {
        return this.comparison;
    }

    @Override
    public Integer build() {
        return this.toComparison();
    }
}

