/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.aoju.bus.core.date.Between;
import org.aoju.bus.core.date.format.DateParser;
import org.aoju.bus.core.date.format.DatePrinter;
import org.aoju.bus.core.date.format.FastDateFormat;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.DateUtils;
import org.aoju.bus.core.utils.ObjectUtils;

public class DateTime
extends java.util.Date {
    private static final long serialVersionUID = -5395712593979185936L;
    private boolean mutable = true;
    private Fields.Week firstDayOfWeek = Fields.Week.MONDAY;
    private TimeZone timeZone;

    public DateTime() {
        this(TimeZone.getDefault());
    }

    public DateTime(TimeZone timeZone) {
        this(System.currentTimeMillis(), timeZone);
    }

    public DateTime(java.util.Date date) {
        this(date.getTime(), TimeZone.getDefault());
    }

    public DateTime(java.util.Date date, TimeZone timeZone) {
        this(date.getTime(), timeZone);
    }

    public DateTime(Calendar calendar) {
        this(calendar.getTime(), null);
    }

    public DateTime(long timeMillis) {
        this(timeMillis, null);
    }

    public DateTime(long timeMillis, TimeZone timeZone) {
        super(timeMillis);
        if (null != timeZone) {
            this.timeZone = timeZone;
        }
    }

    public DateTime(String dateStr, String format) {
        this(dateStr, new SimpleDateFormat(format));
    }

    public DateTime(String dateStr, DateFormat dateFormat) {
        this(DateTime.parse(dateStr, dateFormat), dateFormat.getTimeZone());
    }

    public DateTime(String dateStr, DateParser dateParser) {
        this(DateTime.parse(dateStr, dateParser), dateParser.getTimeZone());
    }

    public static DateTime of(java.util.Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return new DateTime(date);
    }

    public static DateTime of(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime of(String dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime now() {
        return new DateTime();
    }

    private static java.util.Date parse(String dateStr, DateFormat dateFormat) {
        try {
            return dateFormat.parse(dateStr);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    private static java.util.Date parse(String dateStr, DateParser parser) {
        try {
            return parser.parse(dateStr);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public int getField(Fields.DateField field) {
        return this.getField(field.getValue());
    }

    public int getField(int field) {
        return this.toCalendar().get(field);
    }

    @Override
    public void setTime(long time) {
        if (this.mutable) {
            super.setTime(time);
        }
    }

    public int year() {
        return this.getField(Fields.DateField.YEAR);
    }

    public int quarter() {
        return this.month() / 3 + 1;
    }

    public Fields.Quarter quarterEnum() {
        return Fields.Quarter.of(this.quarter());
    }

    public int month() {
        return this.getField(Fields.DateField.MONTH);
    }

    public int monthStartFromOne() {
        return this.month() + 1;
    }

    public Fields.Month monthEnum() {
        return Fields.Month.of(this.month());
    }

    public int weekOfYear() {
        return this.getField(Fields.DateField.WEEK_OF_YEAR);
    }

    public int weekOfMonth() {
        return this.getField(Fields.DateField.WEEK_OF_MONTH);
    }

    public int dayOfMonth() {
        return this.getField(Fields.DateField.DAY_OF_MONTH);
    }

    public int dayOfWeek() {
        return this.getField(Fields.DateField.DAY_OF_WEEK);
    }

    public int dayOfWeekInMonth() {
        return this.getField(Fields.DateField.DAY_OF_WEEK_IN_MONTH);
    }

    public Fields.Week dayOfWeekEnum() {
        return Fields.Week.of(this.dayOfWeek());
    }

    public int hour(boolean is24HourClock) {
        return this.getField(is24HourClock ? Fields.DateField.HOUR_OF_DAY : Fields.DateField.HOUR);
    }

    public int minute() {
        return this.getField(Fields.DateField.MINUTE);
    }

    public int second() {
        return this.getField(Fields.DateField.SECOND);
    }

    public int millsecond() {
        return this.getField(Fields.DateField.MILLISECOND);
    }

    public boolean isAM() {
        return 0 == this.getField(Fields.DateField.AM_PM);
    }

    public boolean isPM() {
        return 1 == this.getField(Fields.DateField.AM_PM);
    }

    public boolean isLeapYear() {
        return DateUtils.isLeapYear(this.year());
    }

    public Calendar toCalendar() {
        return this.toCalendar(Locale.getDefault(Locale.Category.FORMAT));
    }

    public Calendar toCalendar(Locale locale) {
        return this.toCalendar(this.timeZone, locale);
    }

    public Calendar toCalendar(TimeZone zone) {
        return this.toCalendar(zone, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Calendar toCalendar(TimeZone zone, Locale locale) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        Calendar cal = null != zone ? Calendar.getInstance(zone, locale) : Calendar.getInstance(locale);
        cal.setFirstDayOfWeek(this.firstDayOfWeek.getValue());
        cal.setTime(this);
        return cal;
    }

    public java.util.Date toJdkDate() {
        return new java.util.Date(this.getTime());
    }

    public Timestamp toTimestamp() {
        return new Timestamp(this.getTime());
    }

    public Date toSqlDate() {
        return new Date(this.getTime());
    }

    public Between between(java.util.Date date) {
        return new Between(this, date);
    }

    public long between(java.util.Date date, Fields.Unit unit) {
        return new Between(this, date).between(unit);
    }

    public String between(java.util.Date date, Fields.Unit unit, Fields.Level formatLevel) {
        return new Between(this, date).toString(formatLevel);
    }

    public boolean isIn(java.util.Date beginDate, java.util.Date endDate) {
        long beginMills = beginDate.getTime();
        long endMills = endDate.getTime();
        long thisMills = this.getTime();
        return thisMills >= Math.min(beginMills, endMills) && thisMills <= Math.max(beginMills, endMills);
    }

    public boolean isBefore(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) < 0;
    }

    public boolean isBeforeOrEquals(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) <= 0;
    }

    public boolean isAfter(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) > 0;
    }

    public boolean isAfterOrEquals(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) >= 0;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public DateTime setMutable(boolean mutable) {
        this.mutable = mutable;
        return this;
    }

    public Fields.Week getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public DateTime setFirstDayOfWeek(Fields.Week firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        return this;
    }

    public ZoneId getZoneId() {
        return this.timeZone.toZoneId();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public DateTime setTimeZone(TimeZone timeZone) {
        this.timeZone = ObjectUtils.defaultIfNull(timeZone, TimeZone.getDefault());
        return this;
    }

    @Override
    public String toString() {
        if (null != this.timeZone) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            simpleDateFormat.setTimeZone(this.timeZone);
            return this.toString(simpleDateFormat);
        }
        return this.toString(Fields.NORM_DATETIME_FORMAT);
    }

    public String toDateStr() {
        if (null != this.timeZone) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            simpleDateFormat.setTimeZone(this.timeZone);
            return this.toString(simpleDateFormat);
        }
        return this.toString(Fields.NORM_DATE_FORMAT);
    }

    public String toTimeStr() {
        if (null != this.timeZone) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            simpleDateFormat.setTimeZone(this.timeZone);
            return this.toString(simpleDateFormat);
        }
        return this.toString(Fields.NORM_TIME_FORMAT);
    }

    public String toString(String format) {
        if (null != this.timeZone) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
            simpleDateFormat.setTimeZone(this.timeZone);
            return this.toString(simpleDateFormat);
        }
        return this.toString(FastDateFormat.getInstance(format));
    }

    public String toString(DatePrinter format) {
        return format.format(this);
    }

    public String toString(DateFormat format) {
        return format.format(this);
    }

    public String toMsStr() {
        return this.toString(Fields.NORM_DATETIME_MS_FORMAT);
    }

    private DateTime setTimeInternal(long time) {
        super.setTime(time);
        return this;
    }
}

