/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;

public class PinyinUtils {
    public static final String WITH_OUT_TONE = "WITH_OUT_TONE";
    public static final String WITH_TONE_MARK = "WITH_TONE_MARK";
    public static final String WITH_TONE_NUMBER = "WITH_TONE_NUMBER";
    public static final String ALL_UNMARKED_VOWEL = "aeiouv";
    public static final String ALL_MARKED_VOWEL = "\u0101\u00e1\u01ce\u00e0\u0113\u00e9\u011b\u00e8\u012b\u00ed\u01d0\u00ec\u014d\u00f3\u01d2\u00f2\u016b\u00fa\u01d4\u00f9\u01d6\u01d8\u01da\u01dc";
    public static final Properties DICT_CHINESE = PinyinUtils.getDict("chinese");
    public static final Properties DICT_PINYIN = PinyinUtils.getDict("pinyin");
    public static final Properties DICT_POLYPHONE = PinyinUtils.getDict("polyphone");

    public static String[] convert(char c, String format) {
        String pinyin = DICT_PINYIN.getProperty(String.valueOf(c));
        if (pinyin != null && !pinyin.equals("null")) {
            return PinyinUtils.format(pinyin, format);
        }
        return null;
    }

    public static String[] convert(char c) {
        return PinyinUtils.convert(c, WITH_TONE_MARK);
    }

    public static String convert(String str, String separator, String format) {
        str = PinyinUtils.convertSimplified(str);
        StringBuilder sb = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (PinyinUtils.isChinese(c) || c == '\u3007') {
                int rightIndex;
                boolean isFoundFlag = false;
                int rightMove = 3;
                int n = rightIndex = i + rightMove < len ? i + rightMove : len - 1;
                while (rightIndex > i) {
                    String cizu = str.substring(i, rightIndex + 1);
                    if (DICT_POLYPHONE.containsKey(cizu)) {
                        String[] pinyinArray = PinyinUtils.format(DICT_POLYPHONE.getProperty(cizu), format);
                        int l = pinyinArray.length;
                        for (int j = 0; j < l; ++j) {
                            sb.append(pinyinArray[j]);
                            if (j >= l - 1) continue;
                            sb.append(separator);
                        }
                        i = rightIndex;
                        isFoundFlag = true;
                        break;
                    }
                    --rightIndex;
                }
                if (!isFoundFlag) {
                    String[] pinyinArray = PinyinUtils.convert(str.charAt(i), format);
                    if (pinyinArray != null) {
                        sb.append(pinyinArray[0]);
                    } else {
                        sb.append(str.charAt(i));
                    }
                }
                if (i >= len - 1) continue;
                sb.append(separator);
                continue;
            }
            sb.append(c);
            if (i + 1 >= len || !PinyinUtils.isChinese(str.charAt(i + 1))) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String convert(String str, String separator) {
        return PinyinUtils.convert(str, separator, WITH_TONE_MARK);
    }

    public static String convert(String str) {
        String separator = "#";
        StringBuilder sb = new StringBuilder();
        char[] charArray = new char[str.length()];
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            String[] pinyinArray;
            char c = str.charAt(i);
            if (!PinyinUtils.isChinese(c) && c != '\u3007') {
                charArray[i] = c;
                continue;
            }
            sb.append(c);
            for (int j = i + 1; j < len && (PinyinUtils.isChinese(str.charAt(j)) || str.charAt(j) == '\u3007'); ++j) {
                sb.append(str.charAt(j));
            }
            String hanziPinyin = PinyinUtils.convert(sb.toString(), separator, WITH_OUT_TONE);
            for (String string : pinyinArray = hanziPinyin.split(separator)) {
                charArray[i] = string.charAt(0);
                ++i;
            }
            --i;
            sb.delete(0, sb.toString().length());
            sb.trimToSize();
        }
        return String.valueOf(charArray);
    }

    public static String convertSimplified(String str) {
        StringBuilder sb = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            sb.append(PinyinUtils.convertSimplified(c));
        }
        return sb.toString();
    }

    public static char convertSimplified(char c) {
        if (PinyinUtils.isTraditional(c)) {
            return DICT_CHINESE.getProperty(String.valueOf(c)).charAt(0);
        }
        return c;
    }

    public static String convertTraditional(String str) {
        StringBuilder sb = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            sb.append(PinyinUtils.convertTraditional(c));
        }
        return sb.toString();
    }

    public static char convertTraditional(char c) {
        String hanzi = String.valueOf(c);
        if (DICT_CHINESE.containsValue(hanzi)) {
            for (Map.Entry<Object, Object> e : DICT_CHINESE.entrySet()) {
                if (!e.getValue().toString().equals(hanzi)) continue;
                return e.getKey().toString().charAt(0);
            }
        }
        return c;
    }

    private static String[] convertWithTone(String array) {
        String[] pinyinArray = array.split(",");
        for (int i = pinyinArray.length - 1; i >= 0; --i) {
            boolean hasMarkedChar = false;
            String originalPinyin = pinyinArray[i].replaceAll("\u00fc", "v");
            for (int j = originalPinyin.length() - 1; j >= 0; --j) {
                char originalChar = originalPinyin.charAt(j);
                if (originalChar >= 'a' && originalChar <= 'z') continue;
                int indexInAllMarked = ALL_MARKED_VOWEL.indexOf(originalChar);
                int toneNumber = indexInAllMarked % 4 + 1;
                char replaceChar = ALL_UNMARKED_VOWEL.charAt((indexInAllMarked - indexInAllMarked % 4) / 4);
                pinyinArray[i] = originalPinyin.replaceAll(String.valueOf(originalChar), String.valueOf(replaceChar)) + toneNumber;
                hasMarkedChar = true;
                break;
            }
            if (hasMarkedChar) continue;
            pinyinArray[i] = originalPinyin + "5";
        }
        return pinyinArray;
    }

    private static String[] convertWithoutTone(String array) {
        for (int i = ALL_MARKED_VOWEL.length() - 1; i >= 0; --i) {
            char originalChar = ALL_MARKED_VOWEL.charAt(i);
            char replaceChar = ALL_UNMARKED_VOWEL.charAt((i - i % 4) / 4);
            array = array.replaceAll(String.valueOf(originalChar), String.valueOf(replaceChar));
        }
        String[] pinyinArray = array.replaceAll("\u00fc", "v").split(",");
        LinkedHashSet<String> pinyinSet = new LinkedHashSet<String>();
        for (String pinyin : pinyinArray) {
            pinyinSet.add(pinyin);
        }
        return pinyinSet.toArray(new String[pinyinSet.size()]);
    }

    private static String[] format(String str, String format) {
        if (WITH_TONE_MARK.equals(format)) {
            return str.split(",");
        }
        if (WITH_TONE_NUMBER.equals(format)) {
            return PinyinUtils.convertWithTone(str);
        }
        if (WITH_OUT_TONE.equals(format)) {
            return PinyinUtils.convertWithoutTone(str);
        }
        return null;
    }

    public static boolean isTraditional(char c) {
        return DICT_CHINESE.containsKey(String.valueOf(c));
    }

    public static boolean isChinese(String c) {
        String regex = "[\\u4e00-\\u9fa5]";
        return String.valueOf(c).matches(regex);
    }

    public static boolean isChinese(char c) {
        String regex = "[\\u4e00-\\u9fa5]";
        return String.valueOf(c).matches(regex);
    }

    public static boolean isPolyphone(char c) {
        String[] pinyinArray = PinyinUtils.convert(c);
        return pinyinArray != null && pinyinArray.length > 1;
    }

    private static int getChsAscii(String chs) {
        int asc;
        byte[] bytes = chs.getBytes(Charset.CHARSET_GBK);
        switch (bytes.length) {
            case 1: {
                asc = bytes[0];
                break;
            }
            case 2: {
                int hightByte = 256 + bytes[0];
                int lowByte = 256 + bytes[1];
                asc = 256 * hightByte + lowByte - 65536;
                break;
            }
            default: {
                throw new InstrumentException("Illegal resource string");
            }
        }
        return asc;
    }

    private static Properties getDict(String type) {
        Properties p = new Properties();
        try {
            String line;
            String path = "/META-INF/template/" + type + ".dict";
            InputStream is = PinyinUtils.class.getResourceAsStream(path);
            InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(reader);
            while ((line = br.readLine()) != null) {
                String[] tokens = line.trim().split("=");
                p.setProperty(tokens[0], tokens[1]);
            }
            br.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return p;
    }
}

