/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.io.FastByteArray;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.CharsetUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.StringUtils;

public class RuntimeUtils {
    public static String execForStr(String ... cmds) throws InstrumentException {
        return RuntimeUtils.execForStr(CharsetUtils.systemCharset(), cmds);
    }

    public static String execForStr(Charset charset, String ... cmds) throws InstrumentException {
        return RuntimeUtils.getResult(RuntimeUtils.exec(cmds), charset);
    }

    public static List<String> execForLines(String ... cmds) throws InstrumentException {
        return RuntimeUtils.execForLines(CharsetUtils.systemCharset(), cmds);
    }

    public static List<String> execForLines(Charset charset, String ... cmds) throws InstrumentException {
        return RuntimeUtils.getResultLines(RuntimeUtils.exec(cmds), charset);
    }

    public static Process exec(String ... cmds) {
        Process process;
        if (ArrayUtils.isEmpty(cmds)) {
            throw new NullPointerException("Command is empty !");
        }
        if (1 == cmds.length) {
            String cmd = cmds[0];
            if (StringUtils.isBlank(cmd)) {
                throw new NullPointerException("Command is empty !");
            }
            cmds = StringUtils.splitToArray(cmd, 32);
        }
        try {
            process = new ProcessBuilder(cmds).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return process;
    }

    public static Process exec(String[] envp, String ... cmds) {
        return RuntimeUtils.exec(envp, null, cmds);
    }

    public static Process exec(String[] envp, File dir, String ... cmds) {
        if (ArrayUtils.isEmpty(cmds)) {
            throw new NullPointerException("Command is empty !");
        }
        if (1 == cmds.length) {
            String cmd = cmds[0];
            if (StringUtils.isBlank(cmd)) {
                throw new NullPointerException("Command is empty !");
            }
            cmds = StringUtils.splitToArray(cmd, 32);
        }
        try {
            return Runtime.getRuntime().exec(cmds, envp, dir);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static List<String> getResultLines(Process process) {
        return RuntimeUtils.getResultLines(process, CharsetUtils.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getResultLines(Process process, Charset charset) {
        InputStream in = null;
        try {
            in = process.getInputStream();
            List list = IoUtils.readLines(in, charset, new ArrayList());
            return list;
        }
        finally {
            IoUtils.close(in);
            RuntimeUtils.destroy(process);
        }
    }

    public static String getResult(Process process) {
        return RuntimeUtils.getResult(process, CharsetUtils.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResult(Process process, Charset charset) {
        InputStream in = null;
        try {
            in = process.getInputStream();
            String string = IoUtils.read(in, charset);
            return string;
        }
        finally {
            IoUtils.close(in);
            RuntimeUtils.destroy(process);
        }
    }

    public static String getErrorResult(Process process) {
        return RuntimeUtils.getErrorResult(process, CharsetUtils.systemCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorResult(Process process, Charset charset) {
        InputStream in = null;
        try {
            in = process.getErrorStream();
            String string = IoUtils.read(in, charset);
            return string;
        }
        finally {
            IoUtils.close(in);
            RuntimeUtils.destroy(process);
        }
    }

    public static void destroy(Process process) {
        if (null != process) {
            process.destroy();
        }
    }

    public static void addShutdownHook(Runnable hook) {
        Runtime.getRuntime().addShutdownHook(hook instanceof Thread ? (Thread)hook : new Thread(hook));
    }

    public static String getMessage(Throwable e) {
        if (null == e) {
            return "null";
        }
        return StringUtils.format("{}: {}", e.getClass().getSimpleName(), e.getMessage());
    }

    public static String getSimpleMessage(Throwable e) {
        return null == e ? "null" : e.getMessage();
    }

    public static RuntimeException wrapRuntime(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    public static <T extends Throwable> T wrap(Throwable throwable, Class<T> wrapThrowable) {
        if (wrapThrowable.isInstance(throwable)) {
            return (T)throwable;
        }
        return (T)((Throwable)ReflectUtils.newInstance(wrapThrowable, throwable));
    }

    public static void wrapAndThrow(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable);
    }

    public static Throwable unwrap(Throwable wrapped) {
        Throwable unwrapped = wrapped;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        return unwrapped;
    }

    public static StackTraceElement[] getStackElements() {
        return Thread.currentThread().getStackTrace();
    }

    public static StackTraceElement getStackElement(int layers) {
        return RuntimeUtils.getStackElements()[layers];
    }

    public static StackTraceElement getRootStackElement() {
        StackTraceElement[] stackElements = RuntimeUtils.getStackElements();
        return stackElements[stackElements.length - 1];
    }

    public static String getStackTraceOneLine(Throwable throwable) {
        return RuntimeUtils.getStackTraceOneLine(throwable, 3000);
    }

    public static String getStackTraceOneLine(Throwable throwable, int limit) {
        HashMap<Character, String> replaceCharToStrMap = new HashMap<Character, String>();
        replaceCharToStrMap.put(Character.valueOf('\r'), " ");
        replaceCharToStrMap.put(Character.valueOf('\n'), " ");
        replaceCharToStrMap.put(Character.valueOf('\t'), " ");
        return RuntimeUtils.getStackTrace(throwable, limit, replaceCharToStrMap);
    }

    public static String getStackTrace(Throwable throwable) {
        return RuntimeUtils.getStackTrace(throwable, 3000);
    }

    public static String getStackTrace(Throwable throwable, int limit) {
        return RuntimeUtils.getStackTrace(throwable, limit, null);
    }

    public static String getStackTrace(Throwable throwable, int limit, Map<Character, String> replaceCharToStrMap) {
        FastByteArray baos = new FastByteArray();
        throwable.printStackTrace(new PrintStream(baos));
        String exceptionStr = baos.toString();
        int length = exceptionStr.length();
        if (limit > 0 && limit < length) {
            length = limit;
        }
        if (CollUtils.isNotEmpty(replaceCharToStrMap)) {
            StringBuilder sb = StringUtils.builder();
            for (int i = 0; i < length; ++i) {
                char c = exceptionStr.charAt(i);
                String value = replaceCharToStrMap.get(Character.valueOf(c));
                if (null != value) {
                    sb.append(value);
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return StringUtils.subPre(exceptionStr, limit);
    }

    public static boolean isCausedBy(Throwable throwable, Class<? extends Exception> ... causeClasses) {
        return null != RuntimeUtils.getCausedBy(throwable, causeClasses);
    }

    public static Throwable getCausedBy(Throwable throwable, Class<? extends Exception> ... causeClasses) {
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            for (Class<? extends Exception> causeClass : causeClasses) {
                if (!causeClass.isInstance(cause)) continue;
                return cause;
            }
        }
        return null;
    }

    public static boolean isFromOrSuppressedThrowable(Throwable throwable, Class<? extends Throwable> exceptionClass) {
        return RuntimeUtils.convertFromOrSuppressedThrowable(throwable, exceptionClass, true) != null;
    }

    public static boolean isFromOrSuppressedThrowable(Throwable throwable, Class<? extends Throwable> exceptionClass, boolean checkCause) {
        return RuntimeUtils.convertFromOrSuppressedThrowable(throwable, exceptionClass, checkCause) != null;
    }

    public static <T extends Throwable> T convertFromOrSuppressedThrowable(Throwable throwable, Class<T> exceptionClass) {
        return RuntimeUtils.convertFromOrSuppressedThrowable(throwable, exceptionClass, true);
    }

    public static <T extends Throwable> T convertFromOrSuppressedThrowable(Throwable throwable, Class<T> exceptionClass, boolean checkCause) {
        Throwable cause;
        if (throwable == null || exceptionClass == null) {
            return null;
        }
        if (exceptionClass.isAssignableFrom(throwable.getClass())) {
            return (T)throwable;
        }
        if (checkCause && (cause = throwable.getCause()) != null && exceptionClass.isAssignableFrom(cause.getClass())) {
            return (T)cause;
        }
        Throwable[] throwables = throwable.getSuppressed();
        if (ArrayUtils.isNotEmpty(throwables)) {
            for (Throwable throwable1 : throwables) {
                if (!exceptionClass.isAssignableFrom(throwable1.getClass())) continue;
                return (T)throwable1;
            }
        }
        return null;
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return list;
    }

    public static Throwable getRootCause(Throwable throwable) {
        List<Throwable> list = RuntimeUtils.getThrowableList(throwable);
        return list.size() < 1 ? null : list.get(list.size() - 1);
    }

    public static String getRootCauseMessage(Throwable th) {
        return RuntimeUtils.getMessage(RuntimeUtils.getRootCause(th));
    }
}

