/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.aoju.bus.core.io.FastByteArray;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.CharsetUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;

public class ZipUtils {
    private static final int DEFAULT_BYTE_ARRAY_LENGTH = 32;
    private static final java.nio.charset.Charset DEFAULT_CHARSET = CharsetUtils.defaultCharset();

    public static File zip(String srcPath) throws InstrumentException {
        return ZipUtils.zip(srcPath, DEFAULT_CHARSET);
    }

    public static File zip(String srcPath, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipUtils.zip(FileUtils.file(srcPath), charset);
    }

    public static File zip(File srcFile) throws InstrumentException {
        return ZipUtils.zip(srcFile, DEFAULT_CHARSET);
    }

    public static File zip(File srcFile, java.nio.charset.Charset charset) throws InstrumentException {
        File zipFile = FileUtils.file(srcFile.getParentFile(), FileUtils.mainName(srcFile) + ".zip");
        ZipUtils.zip(zipFile, charset, false, srcFile);
        return zipFile;
    }

    public static File zip(String srcPath, String zipPath) throws InstrumentException {
        return ZipUtils.zip(srcPath, zipPath, false);
    }

    public static File zip(String srcPath, String zipPath, boolean withSrcDir) throws InstrumentException {
        return ZipUtils.zip(srcPath, zipPath, DEFAULT_CHARSET, withSrcDir);
    }

    public static File zip(String srcPath, String zipPath, java.nio.charset.Charset charset, boolean withSrcDir) throws InstrumentException {
        File srcFile = FileUtils.file(srcPath);
        File zipFile = FileUtils.file(zipPath);
        ZipUtils.zip(zipFile, charset, withSrcDir, srcFile);
        return zipFile;
    }

    public static File zip(File zipFile, boolean withSrcDir, File ... srcFiles) throws InstrumentException {
        return ZipUtils.zip(zipFile, DEFAULT_CHARSET, withSrcDir, srcFiles);
    }

    public static File zip(File zipFile, java.nio.charset.Charset charset, boolean withSrcDir, File ... srcFiles) throws InstrumentException {
        ZipUtils.validateFiles(zipFile, srcFiles);
        try (ZipOutputStream out = ZipUtils.getZipOutputStream(zipFile, charset);){
            for (File srcFile : srcFiles) {
                if (null == srcFile) continue;
                String srcRootDir = srcFile.getCanonicalPath();
                if (srcFile.isFile() || withSrcDir) {
                    srcRootDir = srcFile.getCanonicalFile().getParentFile().getCanonicalPath();
                }
                ZipUtils.zip(srcFile, srcRootDir, out);
                out.flush();
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return zipFile;
    }

    public static File zip(File zipFile, String path, String data) throws InstrumentException {
        return ZipUtils.zip(zipFile, path, data, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, String data, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipUtils.zip(zipFile, path, IoUtils.toStream(data, charset), charset);
    }

    public static File zip(File zipFile, String path, InputStream in) throws InstrumentException {
        return ZipUtils.zip(zipFile, path, in, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, InputStream in, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipUtils.zip(zipFile, new String[]{path}, new InputStream[]{in}, charset);
    }

    public static File zip(File zipFile, String[] paths, InputStream[] ins) throws InstrumentException {
        return ZipUtils.zip(zipFile, paths, ins, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip(File zipFile, String[] paths, InputStream[] ins, java.nio.charset.Charset charset) throws InstrumentException {
        if (ArrayUtils.isEmpty(paths) || ArrayUtils.isEmpty(ins)) {
            throw new IllegalArgumentException("Paths or ins is empty !");
        }
        if (paths.length != ins.length) {
            throw new IllegalArgumentException("Paths length is not equals to ins length !");
        }
        ZipOutputStream out = null;
        try {
            out = ZipUtils.getZipOutputStream(zipFile, charset);
            for (int i = 0; i < paths.length; ++i) {
                ZipUtils.addFile(ins[i], paths[i], out);
            }
        }
        finally {
            IoUtils.close(out);
        }
        return zipFile;
    }

    public static File unzip(String zipFilePath) throws InstrumentException {
        return ZipUtils.unzip(zipFilePath, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipUtils.unzip(FileUtils.file(zipFilePath), charset);
    }

    public static File unzip(File zipFile) throws InstrumentException {
        return ZipUtils.unzip(zipFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipUtils.unzip(zipFile, FileUtils.file(zipFile.getParentFile(), FileUtils.mainName(zipFile)), charset);
    }

    public static File unzip(String zipFilePath, String outFileDir) throws InstrumentException {
        return ZipUtils.unzip(zipFilePath, outFileDir, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, String outFileDir, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipUtils.unzip(FileUtils.file(zipFilePath), FileUtils.mkdir(outFileDir), charset);
    }

    public static File unzip(File zipFile, File outFile) throws InstrumentException {
        return ZipUtils.unzip(zipFile, outFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, File outFile, java.nio.charset.Charset charset) throws InstrumentException {
        charset = null == charset ? DEFAULT_CHARSET : charset;
        ZipFile zipFileObj = null;
        try {
            zipFileObj = new ZipFile(zipFile, charset);
            Enumeration<? extends ZipEntry> em = zipFileObj.entries();
            while (em.hasMoreElements()) {
                ZipEntry zipEntry = em.nextElement();
                File outItemFile = FileUtils.file(outFile, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    outItemFile.mkdirs();
                    continue;
                }
                FileUtils.touch(outItemFile);
                ZipUtils.copy(zipFileObj, zipEntry, outItemFile);
            }
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoUtils.close(zipFileObj);
                throw throwable;
            }
        }
        IoUtils.close(zipFileObj);
        return outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(ZipFile zipFile, File outFile) {
        try {
            Enumeration<? extends ZipEntry> em = zipFile.entries();
            while (em.hasMoreElements()) {
                ZipEntry zipEntry = em.nextElement();
                File outItemFile = ZipUtils.buildFile(outFile, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    outItemFile.mkdirs();
                    continue;
                }
                ZipUtils.write(zipFile, zipEntry, outItemFile);
            }
        }
        finally {
            IoUtils.close(zipFile);
        }
        return outFile;
    }

    public static File unzip(InputStream in, File outFile, java.nio.charset.Charset charset) {
        if (null == charset) {
            charset = DEFAULT_CHARSET;
        }
        return ZipUtils.unzip(new ZipInputStream(in, charset), outFile);
    }

    public static File unzip(ZipInputStream zipStream, File outFile) {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = zipStream.getNextEntry())) {
                File outItemFile = FileUtils.file(outFile, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    outItemFile.mkdirs();
                    continue;
                }
                FileUtils.writeFromStream((InputStream)zipStream, outItemFile);
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            IoUtils.close(zipStream);
        }
        return outFile;
    }

    public static byte[] unzipFileBytes(String zipFilePath, String name) {
        return ZipUtils.unzipFileBytes(zipFilePath, DEFAULT_CHARSET, name);
    }

    public static byte[] unzipFileBytes(String zipFilePath, java.nio.charset.Charset charset, String name) {
        return ZipUtils.unzipFileBytes(FileUtils.file(zipFilePath), charset, name);
    }

    public static byte[] unzipFileBytes(File zipFile, String name) {
        return ZipUtils.unzipFileBytes(zipFile, DEFAULT_CHARSET, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzipFileBytes(File zipFile, java.nio.charset.Charset charset, String name) {
        ZipFile zipFileObj;
        block6: {
            byte[] byArray;
            block5: {
                zipFileObj = null;
                try {
                    zipFileObj = new ZipFile(zipFile, charset);
                    Enumeration<? extends ZipEntry> em = zipFileObj.entries();
                    while (em.hasMoreElements()) {
                        ZipEntry zipEntry = em.nextElement();
                        if (zipEntry.isDirectory() || !name.equals(zipEntry.getName())) continue;
                        byArray = IoUtils.readBytes(zipFileObj.getInputStream(zipEntry));
                        break block5;
                    }
                    break block6;
                }
                catch (IOException e) {
                    try {
                        throw new InstrumentException(e);
                    }
                    catch (Throwable throwable) {
                        IoUtils.close(zipFileObj);
                        throw throwable;
                    }
                }
            }
            IoUtils.close(zipFileObj);
            return byArray;
        }
        IoUtils.close(zipFileObj);
        return null;
    }

    public static byte[] gzip(String content, String charset) throws InstrumentException {
        return ZipUtils.gzip(StringUtils.bytes((CharSequence)content, charset));
    }

    public static byte[] gzip(byte[] buf) throws InstrumentException {
        return ZipUtils.gzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] gzip(File file) throws InstrumentException {
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream(file);
            byte[] byArray = ZipUtils.gzip(in, (int)file.length());
            return byArray;
        }
        finally {
            IoUtils.close(in);
        }
    }

    public static byte[] gzip(InputStream in) throws InstrumentException {
        return ZipUtils.gzip(in, 32);
    }

    public static byte[] gzip(InputStream in, int length) throws InstrumentException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(bos);
            IoUtils.copy(in, gos);
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoUtils.close(gos);
                throw throwable;
            }
        }
        IoUtils.close(gos);
        return bos.toByteArray();
    }

    public static String unGzip(byte[] buf, String charset) throws InstrumentException {
        return StringUtils.str(ZipUtils.unGzip(buf), charset);
    }

    public static byte[] unGzip(byte[] buf) throws InstrumentException {
        return ZipUtils.unGzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unGzip(InputStream in) throws InstrumentException {
        return ZipUtils.unGzip(in, 32);
    }

    public static byte[] unGzip(InputStream in, int length) throws InstrumentException {
        FastByteArray bos;
        GZIPInputStream gzi = null;
        try {
            gzi = in instanceof GZIPInputStream ? (GZIPInputStream)in : new GZIPInputStream(in);
            bos = new FastByteArray(length);
            IoUtils.copy((InputStream)gzi, bos);
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoUtils.close(gzi);
                throw throwable;
            }
        }
        IoUtils.close(gzi);
        return bos.toByteArray();
    }

    public static byte[] zlib(String content, String charset, int level) {
        return ZipUtils.zlib(StringUtils.bytes((CharSequence)content, charset), level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zlib(File file, int level) {
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream(file);
            byte[] byArray = ZipUtils.zlib(in, level, (int)file.length());
            return byArray;
        }
        finally {
            IoUtils.close(in);
        }
    }

    public static byte[] zlib(byte[] buf, int level) {
        return ZipUtils.zlib(new ByteArrayInputStream(buf), level, buf.length);
    }

    public static byte[] zlib(InputStream in, int level) {
        return ZipUtils.zlib(in, level, 32);
    }

    public static byte[] zlib(InputStream in, int level, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        ZipUtils.deflater(in, out, level);
        return out.toByteArray();
    }

    public static String unZlib(byte[] buf, String charset) {
        return StringUtils.str(ZipUtils.unZlib(buf), charset);
    }

    public static byte[] unZlib(byte[] buf) {
        return ZipUtils.unZlib(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unZlib(InputStream in) {
        return ZipUtils.unZlib(in, 32);
    }

    public static byte[] unZlib(InputStream in, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        ZipUtils.inflater(in, out);
        return out.toByteArray();
    }

    private static ZipOutputStream getZipOutputStream(File zipFile, java.nio.charset.Charset charset) {
        return ZipUtils.getZipOutputStream(FileUtils.getOutputStream(zipFile), charset);
    }

    private static ZipOutputStream getZipOutputStream(OutputStream out, java.nio.charset.Charset charset) {
        charset = null == charset ? Charset.DEFAULT : charset;
        return new ZipOutputStream(out, charset);
    }

    private static void zip(File file, String srcRootDir, ZipOutputStream out) throws InstrumentException {
        if (file == null) {
            return;
        }
        String subPath = FileUtils.subPath(srcRootDir, file);
        if (file.isDirectory()) {
            Object[] files = file.listFiles();
            if (ArrayUtils.isEmpty(files) && StringUtils.isNotEmpty(subPath)) {
                ZipUtils.addDir(subPath, out);
            }
            for (Object childFile : files) {
                ZipUtils.zip((File)childFile, srcRootDir, out);
            }
        } else {
            ZipUtils.addFile(file, subPath, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFile(File file, String path, ZipOutputStream out) throws InstrumentException {
        BufferedInputStream in = null;
        try {
            in = FileUtils.getInputStream(file);
            ZipUtils.addFile(in, path, out);
        }
        finally {
            IoUtils.close(in);
        }
    }

    private static void addFile(InputStream in, String path, ZipOutputStream out) throws InstrumentException {
        if (null == in) {
            return;
        }
        try {
            out.putNextEntry(new ZipEntry(path));
            IoUtils.copy(in, out);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            ZipUtils.closeEntry(out);
        }
    }

    private static void addDir(String path, ZipOutputStream out) throws InstrumentException {
        path = StringUtils.addSuffixIfNot(path, "/");
        try {
            out.putNextEntry(new ZipEntry(path));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            ZipUtils.closeEntry(out);
        }
    }

    private static void validateFiles(File zipFile, File ... srcFiles) throws InstrumentException {
        if (zipFile.isDirectory()) {
            throw new InstrumentException("Zip file [{}] must not be a directory !", zipFile.getAbsoluteFile());
        }
        for (File srcFile : srcFiles) {
            if (null == srcFile) continue;
            if (!srcFile.exists()) {
                throw new InstrumentException(StringUtils.format("File [{}] not exist!", srcFile.getAbsolutePath()));
            }
            try {
                File parentFile = zipFile.getCanonicalFile().getParentFile();
                if (!srcFile.isDirectory() || !parentFile.getCanonicalPath().contains(srcFile.getCanonicalPath())) continue;
                throw new InstrumentException("Zip file path [{}] must not be the child directory of [{}] !", zipFile.getCanonicalPath(), srcFile.getCanonicalPath());
            }
            catch (IOException e) {
                throw new InstrumentException(e);
            }
        }
    }

    private static void closeEntry(ZipOutputStream out) {
        try {
            out.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(ZipFile zipFile, ZipEntry zipEntry, File outItemFile) throws IOException {
        InputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = zipFile.getInputStream(zipEntry);
            out = FileUtils.getOutputStream(outItemFile);
            IoUtils.copy(in, out);
        }
        catch (Throwable throwable) {
            IoUtils.close(out);
            IoUtils.close(in);
            throw throwable;
        }
        IoUtils.close(out);
        IoUtils.close(in);
    }

    private static void inflater(InputStream in, OutputStream out) {
        InflaterOutputStream ios = out instanceof InflaterOutputStream ? (InflaterOutputStream)out : new InflaterOutputStream(out, new Inflater(true));
        IoUtils.copy(in, ios);
        try {
            ios.finish();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    private static void deflater(InputStream in, OutputStream out, int level) {
        DeflaterOutputStream ios = out instanceof DeflaterOutputStream ? (DeflaterOutputStream)out : new DeflaterOutputStream(out, new Deflater(level, true));
        IoUtils.copy(in, ios);
        try {
            ios.finish();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    private static File buildFile(File outFile, String fileName) {
        if (!FileUtils.isWindows() && StringUtils.contains(fileName, '/')) {
            String[] pathParts = StringUtils.splitToArray(fileName, 47);
            for (int i = 0; i < pathParts.length - 1; ++i) {
                outFile = new File(outFile, pathParts[i]);
            }
            outFile.mkdirs();
            fileName = pathParts[pathParts.length - 1];
        }
        return FileUtils.file(outFile, fileName);
    }

    private static void write(ZipFile zipFile, ZipEntry zipEntry, File outItemFile) {
        InputStream in = null;
        try {
            in = zipFile.getInputStream(zipEntry);
            FileUtils.writeFromStream(in, outItemFile);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            IoUtils.close(in);
        }
    }
}

