/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.map.CaseInsensitiveMap;
import org.aoju.bus.core.utils.BooleanUtils;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.ModifierUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.TypeUtils;

public class BeanDesc
implements Serializable {
    private Class<?> beanClass;
    private Map<String, PropDesc> propMap = new LinkedHashMap<String, PropDesc>();

    public BeanDesc(Class<?> beanClass) {
        Assert.notNull(beanClass);
        this.beanClass = beanClass;
        this.init();
    }

    public String getName() {
        return this.beanClass.getName();
    }

    public String getSimpleName() {
        return this.beanClass.getSimpleName();
    }

    public Map<String, PropDesc> getPropMap(boolean ignoreCase) {
        return ignoreCase ? new CaseInsensitiveMap<String, PropDesc>(1.0f, this.propMap) : this.propMap;
    }

    public Collection<PropDesc> getProps() {
        return this.propMap.values();
    }

    public PropDesc getProp(String fieldName) {
        return this.propMap.get(fieldName);
    }

    public Field getField(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getField();
    }

    public Method getGetter(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getGetter();
    }

    public Method getSetter(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getSetter();
    }

    private BeanDesc init() {
        for (Field field : ReflectUtils.getFields(this.beanClass)) {
            if (ModifierUtils.isStatic(field)) continue;
            this.propMap.put(field.getName(), this.createProp(field));
        }
        return this;
    }

    private PropDesc createProp(Field field) {
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        boolean isBooeanField = BooleanUtils.isBoolean(fieldType);
        Method getter = null;
        Method setter = null;
        for (Method method : ReflectUtils.getMethods(this.beanClass)) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length > 1) continue;
            String methodName = method.getName();
            if (parameterTypes.length == 0) {
                if (this.isMatchGetter(methodName, fieldName, isBooeanField)) {
                    getter = method;
                }
            } else if (this.isMatchSetter(methodName, fieldName, isBooeanField)) {
                setter = method;
            }
            if (null != getter && null != setter) break;
        }
        return new PropDesc(field, getter, setter);
    }

    private boolean isMatchGetter(String methodName, String fieldName, boolean isBooeanField) {
        methodName = methodName.toLowerCase();
        fieldName = fieldName.toLowerCase();
        if (!methodName.startsWith("get") && !methodName.startsWith("is")) {
            return false;
        }
        if ("getclass".equals(methodName)) {
            return false;
        }
        if (isBooeanField && (fieldName.startsWith("is") ? methodName.equals(fieldName) || methodName.equals("get" + fieldName) || methodName.equals("is" + fieldName) : methodName.equals("is" + fieldName))) {
            return true;
        }
        return methodName.equals("get" + fieldName);
    }

    private boolean isMatchSetter(String methodName, String fieldName, boolean isBooeanField) {
        methodName = methodName.toLowerCase();
        fieldName = fieldName.toLowerCase();
        if (!methodName.startsWith("set")) {
            return false;
        }
        if (isBooeanField && fieldName.startsWith("is") && (methodName.equals("set" + StringUtils.removePrefix(fieldName, "is")) || methodName.equals("set" + fieldName))) {
            return true;
        }
        return methodName.equals("set" + fieldName);
    }

    public static class PropDesc {
        private Field field;
        private Method getter;
        private Method setter;

        public PropDesc(Field field, Method getter, Method setter) {
            this.field = field;
            this.getter = ClassUtils.setAccessible(getter);
            this.setter = ClassUtils.setAccessible(setter);
        }

        public String getFieldName() {
            return null == this.field ? null : this.field.getName();
        }

        public Field getField() {
            return this.field;
        }

        public Type getFieldType() {
            if (null != this.field) {
                return TypeUtils.getType(this.field);
            }
            return this.findPropType(this.getter, this.setter);
        }

        public Class<?> getFieldClass() {
            if (null != this.field) {
                return TypeUtils.getClass(this.field);
            }
            return this.findPropClass(this.getter, this.setter);
        }

        public Method getGetter() {
            return this.getter;
        }

        public Method getSetter() {
            return this.setter;
        }

        public Object getValue(Object bean) {
            if (null != this.getter) {
                return ReflectUtils.invoke(bean, this.getter, new Object[0]);
            }
            if (ModifierUtils.isPublic(this.field)) {
                return ReflectUtils.getFieldValue(bean, this.field);
            }
            return null;
        }

        public PropDesc setValue(Object bean, Object value) {
            if (null != this.setter) {
                ReflectUtils.invoke(bean, this.setter, value);
            } else if (ModifierUtils.isPublic(this.field)) {
                ReflectUtils.setFieldValue(bean, this.field, value);
            }
            return this;
        }

        private Type findPropType(Method getter, Method setter) {
            Type type = null;
            if (null != getter) {
                type = TypeUtils.getReturnType(getter);
            }
            if (null == type && null != setter) {
                type = TypeUtils.getParamType(setter, 0);
            }
            return type;
        }

        private Class<?> findPropClass(Method getter, Method setter) {
            Class<?> type = null;
            if (null != getter) {
                type = TypeUtils.getReturnClass(getter);
            }
            if (null == type && null != setter) {
                type = TypeUtils.getFirstParamClass(setter);
            }
            return type;
        }
    }
}

