/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.aoju.bus.core.io.FastByteBuffer;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.CharsetUtils;

public class FastByteArray
extends OutputStream {
    private final FastByteBuffer buffer;

    public FastByteArray() {
        this(1024);
    }

    public FastByteArray(int size) {
        this.buffer = new FastByteBuffer(size);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.append(b, off, len);
    }

    @Override
    public void write(int b) {
        this.buffer.append((byte)b);
    }

    public int size() {
        return this.buffer.size();
    }

    @Override
    public void close() throws IOException {
    }

    public void reset() {
        this.buffer.reset();
    }

    public void writeTo(OutputStream out) throws InstrumentException {
        int index = this.buffer.index();
        try {
            for (int i = 0; i < index; ++i) {
                byte[] buf = this.buffer.array(i);
                out.write(buf);
            }
            out.write(this.buffer.array(index), 0, this.buffer.offset());
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public byte[] toByteArray() {
        return this.buffer.toArray();
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public String toString(String charsetName) {
        return this.toString(CharsetUtils.charset(charsetName));
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), charset);
    }
}

