/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.thread.ExecutorBuilder;

public class GlobalThread {
    private static ExecutorService executor;

    private GlobalThread() {
    }

    public static synchronized void init() {
        if (null != executor) {
            executor.shutdownNow();
        }
        executor = ExecutorBuilder.create().useSynchronousQueue().build();
    }

    public static synchronized void shutdown(boolean isNow) {
        if (null != executor) {
            if (isNow) {
                executor.shutdownNow();
            } else {
                executor.shutdown();
            }
        }
    }

    public static ExecutorService getExecutor() {
        return executor;
    }

    public static void execute(Runnable runnable) {
        try {
            executor.execute(runnable);
        }
        catch (Exception e) {
            throw new InstrumentException("Exception when running task!");
        }
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return executor.submit(task);
    }

    public static Future<?> submit(Runnable runnable) {
        return executor.submit(runnable);
    }

    static {
        GlobalThread.init();
    }
}

