/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.codec;

import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.utils.StringUtils;

public final class Base32 {
    private static final char[] base32Lookup = new char[]{'\u00ff', '\u00ff', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff'};

    private Base32() {
    }

    public static String encode(byte[] bytes) {
        int i = 0;
        int index = 0;
        StringBuilder base32 = new StringBuilder((bytes.length + 7) * 8 / 5);
        while (i < bytes.length) {
            int digit;
            int currByte;
            int n = currByte = bytes[i] >= 0 ? bytes[i] : bytes[i] + 256;
            if (index > 3) {
                int nextByte = i + 1 < bytes.length ? (bytes[i + 1] >= 0 ? bytes[i + 1] : bytes[i + 1] + 256) : 0;
                digit = currByte & 255 >> index;
                index = (index + 5) % 8;
                digit <<= index;
                digit |= nextByte >> 8 - index;
                ++i;
            } else {
                digit = currByte >> 8 - (index + 5) & 0x1F;
                if ((index = (index + 5) % 8) == 0) {
                    ++i;
                }
            }
            base32.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt(digit));
        }
        return base32.toString();
    }

    public static String encode(String source) {
        return Base32.encode(source, Charset.UTF_8);
    }

    public static String encode(String source, String charset) {
        return Base32.encode(StringUtils.bytes((CharSequence)source, charset));
    }

    public static String encode(String source, java.nio.charset.Charset charset) {
        return Base32.encode(StringUtils.bytes((CharSequence)source, charset));
    }

    public static byte[] decode(String base32) {
        byte[] bytes = new byte[base32.length() * 5 / 8];
        int index = 0;
        int offset = 0;
        for (int i = 0; i < base32.length(); ++i) {
            char digit;
            int lookup = base32.charAt(i) - 48;
            if (lookup < 0 || lookup >= base32Lookup.length || (digit = base32Lookup[lookup]) == '\u00ff') continue;
            if (index <= 3) {
                if ((index = (index + 5) % 8) == 0) {
                    int n = offset++;
                    bytes[n] = (byte)(bytes[n] | digit);
                    if (offset < bytes.length) continue;
                    break;
                }
                int n = offset;
                bytes[n] = (byte)(bytes[n] | digit << 8 - index);
                continue;
            }
            index = (index + 5) % 8;
            int n = offset++;
            bytes[n] = (byte)(bytes[n] | digit >>> index);
            if (offset >= bytes.length) break;
            int n2 = offset;
            bytes[n2] = (byte)(bytes[n2] | digit << 8 - index);
        }
        return bytes;
    }

    public static String decodeStr(String source) {
        return Base32.decodeStr(source, Charset.UTF_8);
    }

    public static String decodeStr(String source, String charset) {
        return StringUtils.str(Base32.decode(source), charset);
    }

    public static String decodeStr(String source, java.nio.charset.Charset charset) {
        return StringUtils.str(Base32.decode(source), charset);
    }
}

