/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert.impl;

import java.lang.reflect.Method;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.ReflectUtils;

public class Jdk8DateConverter
extends AbstractConverter<Object> {
    public static String[] supportClassNames = new String[]{"java.time.LocalDateTime", "java.time.LocalDate", "java.time.LocalTime", "java.time.ZonedDateTime", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.Period", "java.time.Instant"};
    private Class<?> targetType;
    private String format;

    public Jdk8DateConverter(Class<?> targetType) {
        this.targetType = targetType;
    }

    public Jdk8DateConverter(Class<?> targetType, String format) {
        this.targetType = targetType;
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Object convertInternal(Object value) {
        if (value instanceof Long) {
            return this.parseFromLong((Long)value);
        }
        return this.parseFromCharSequence(this.convertToStr(value));
    }

    private Object parseFromCharSequence(CharSequence value) {
        if (null != this.format) {
            Object dateTimeFormatter = this.getDateTimeFormatter();
            Method method = ReflectUtils.getMethod(this.targetType, "parse", CharSequence.class, dateTimeFormatter.getClass());
            return ReflectUtils.invokeStatic(method, value, dateTimeFormatter);
        }
        Method method = ReflectUtils.getMethod(this.targetType, "parse", CharSequence.class);
        return ReflectUtils.invokeStatic(method, value);
    }

    private Object parseFromLong(Long time) {
        String targetName = this.targetType.getName();
        if ("java.time.Instant".equals(targetName)) {
            return this.toInstant(time);
        }
        return null;
    }

    private Object getDateTimeFormatter() {
        if (null != this.format) {
            return ClassUtils.invoke("java.time.format.DateTimeFormatter.ofPattern", false, this.format);
        }
        return null;
    }

    private Object toInstant(Long time) {
        return ClassUtils.invoke("java.time.Instant.ofEpochMilli", false, time);
    }

    @Override
    public Class<Object> getTargetType() {
        return this.targetType;
    }
}

