/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aoju.bus.core.lang.Murmur;
import org.aoju.bus.core.utils.NumberUtils;
import org.aoju.bus.core.utils.StringUtils;

public class Similarity {
    private final int bitNum = 64;
    private final int fracCount;
    private final int fracBitNum;
    private final int hammingThresh;
    private List<Map<String, List<Long>>> storage;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public Similarity() {
        this(4, 3);
    }

    public Similarity(int fracCount, int hammingThresh) {
        this.fracCount = fracCount;
        this.fracBitNum = 64 / fracCount;
        this.hammingThresh = hammingThresh;
        this.storage = new ArrayList<Map<String, List<Long>>>(fracCount);
        for (int i = 0; i < fracCount; ++i) {
            this.storage.add(new HashMap());
        }
    }

    public static double similar(String strA, String strB) {
        String newStrB;
        String newStrA;
        if (strA.length() < strB.length()) {
            newStrA = Similarity.removeSign(strB);
            newStrB = Similarity.removeSign(strA);
        } else {
            newStrA = Similarity.removeSign(strA);
            newStrB = Similarity.removeSign(strB);
        }
        int temp = Math.max(newStrA.length(), newStrB.length());
        if (0 == temp) {
            return 1.0;
        }
        int temp2 = Similarity.longestCommonSubstring(newStrA, newStrB).length();
        return NumberUtils.div((float)temp2, (float)temp);
    }

    public static String similar(String strA, String strB, int scale) {
        return NumberUtils.formatPercent(Similarity.similar(strA, strB), scale);
    }

    private static String removeSign(String str) {
        int length = str.length();
        StringBuilder sb = StringUtils.builder(length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (!Similarity.isValidChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isValidChar(char charValue) {
        return charValue >= '\u4e00' && charValue <= '\u9fff' || charValue >= 'a' && charValue <= 'z' || charValue >= 'A' && charValue <= 'Z' || charValue >= '0' && charValue <= '9';
    }

    private static String longestCommonSubstring(String strA, String strB) {
        char[] chars_strA = strA.toCharArray();
        char[] chars_strB = strB.toCharArray();
        int m = chars_strA.length;
        int n = chars_strB.length;
        int[][] matrix = new int[m + 1][n + 1];
        for (int i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                matrix[i][j] = chars_strA[i - 1] == chars_strB[j - 1] ? matrix[i - 1][j - 1] + 1 : Math.max(matrix[i][j - 1], matrix[i - 1][j]);
            }
        }
        char[] result = new char[matrix[m][n]];
        int currentIndex = result.length - 1;
        while (matrix[m][n] != 0) {
            if (matrix[m][n] == matrix[m][n - 1]) {
                --n;
                continue;
            }
            if (matrix[m][n] == matrix[m - 1][n]) {
                --m;
                continue;
            }
            result[currentIndex] = chars_strA[m - 1];
            --currentIndex;
            --n;
            --m;
        }
        return new String(result);
    }

    /*
     * WARNING - void declaration
     */
    public long hash(Collection<? extends CharSequence> segList) {
        void var7_8;
        int bitNum = this.bitNum;
        int[] weight = new int[bitNum];
        for (CharSequence charSequence : segList) {
            long wordHash = Murmur.hash64(charSequence);
            for (int i = 0; i < bitNum; ++i) {
                if ((wordHash >> i & 1L) == 1L) {
                    int n = i;
                    weight[n] = weight[n] + 1;
                    continue;
                }
                int n = i;
                weight[n] = weight[n] - 1;
            }
        }
        StringBuilder sb = new StringBuilder();
        boolean bl = false;
        while (var7_8 < bitNum) {
            sb.append(weight[var7_8] > 0 ? 1 : 0);
            ++var7_8;
        }
        return new BigInteger(sb.toString(), 2).longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Collection<? extends CharSequence> segList) {
        long simhash = this.hash(segList);
        List<String> fracList = this.splitSimhash(simhash);
        int hammingThresh = this.hammingThresh;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            for (int i = 0; i < this.fracCount; ++i) {
                String frac = fracList.get(i);
                Map<String, List<Long>> fracMap = this.storage.get(i);
                if (!fracMap.containsKey(frac)) continue;
                for (Long simhash2 : fracMap.get(frac)) {
                    if (this.hamming(simhash, simhash2) >= hammingThresh) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            readLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Long simhash) {
        int fracCount = this.fracCount;
        List<Map<String, List<Long>>> storage = this.storage;
        List<String> lFrac = this.splitSimhash(simhash);
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            for (int i = 0; i < fracCount; ++i) {
                String frac = lFrac.get(i);
                Map<String, List<Long>> fracMap = storage.get(i);
                if (fracMap.containsKey(frac)) {
                    fracMap.get(frac).add(simhash);
                    continue;
                }
                ArrayList<Long> ls = new ArrayList<Long>();
                ls.add(simhash);
                fracMap.put(frac, ls);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private int hamming(Long s1, Long s2) {
        int bitNum = this.bitNum;
        int dis = 0;
        for (int i = 0; i < bitNum; ++i) {
            if ((s1 >> i & 1L) == (s2 >> i & 1L)) continue;
            ++dis;
        }
        return dis;
    }

    private List<String> splitSimhash(Long simhash) {
        int bitNum = this.bitNum;
        int fracBitNum = this.fracBitNum;
        ArrayList<String> ls = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bitNum; ++i) {
            sb.append(simhash >> i & 1L);
            if ((i + 1) % fracBitNum != 0) continue;
            ls.add(sb.toString());
            sb.setLength(0);
        }
        return ls;
    }
}

