/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.aoju.bus.core.builder.HashCodeBuilder;
import org.aoju.bus.core.builder.ToStringBuilder;
import org.aoju.bus.core.builder.ToStringStyle;
import org.aoju.bus.core.lang.Editor;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.lang.mutable.MutableInt;
import org.aoju.bus.core.utils.BooleanUtils;
import org.aoju.bus.core.utils.CharUtils;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.IterUtils;
import org.aoju.bus.core.utils.NumberUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;

public class ArrayUtils {
    public static final int INDEX_NOT_FOUND = -1;

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (ArrayUtils.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static String toString(Object array, String stringIfNull) {
        if (array == null) {
            return stringIfNull;
        }
        return new ToStringBuilder(array, ToStringStyle.SIMPLE_STYLE).append(array).toString();
    }

    public static int hashCode(Object array) {
        return new HashCodeBuilder().append(array).toHashCode();
    }

    public static Map<Object, Object> toMap(Object[] array) {
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i = 0; i < array.length; ++i) {
            Object[] entry;
            Object object = array[i];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                entry = (Object[])object;
                if (entry.length < 2) {
                    throw new IllegalArgumentException("Array element " + i + ", '" + object + "', has a length less than 2");
                }
                map.put(entry[0], entry[1]);
                continue;
            }
            throw new IllegalArgumentException("Array element " + i + ", '" + object + "', is neither of type Map.Entry nor an Array");
        }
        return map;
    }

    public static <T> T[] toArray(T ... items) {
        return items;
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static <T> T clone(T obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtils.isArray(obj)) {
            Object result;
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                result = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(result, length, Array.get(obj, length));
                }
            } else {
                result = ((Object[])obj).clone();
            }
            return (T)result;
        }
        return null;
    }

    public static long[] clone(long[] array) {
        if (array == null) {
            return null;
        }
        return (long[])array.clone();
    }

    public static int[] clone(int[] array) {
        if (array == null) {
            return null;
        }
        return (int[])array.clone();
    }

    public static short[] clone(short[] array) {
        if (array == null) {
            return null;
        }
        return (short[])array.clone();
    }

    public static char[] clone(char[] array) {
        if (array == null) {
            return null;
        }
        return (char[])array.clone();
    }

    public static byte[] clone(byte[] array) {
        if (array == null) {
            return null;
        }
        return (byte[])array.clone();
    }

    public static double[] clone(double[] array) {
        if (array == null) {
            return null;
        }
        return (double[])array.clone();
    }

    public static float[] clone(float[] array) {
        if (array == null) {
            return null;
        }
        return (float[])array.clone();
    }

    public static boolean[] clone(boolean[] array) {
        if (array == null) {
            return null;
        }
        return (boolean[])array.clone();
    }

    public static <T> T[] nullToEmpty(T[] array, Class<T[]> type) {
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        if (array == null) {
            return type.cast(Array.newInstance(type.getComponentType(), 0));
        }
        return array;
    }

    public static Object[] nullToEmpty(Object[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return Normal.EMPTY_OBJECT_ARRAY;
        }
        return array;
    }

    public static Class<?>[] nullToEmpty(Class<?>[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return Normal.EMPTY_CLASS_ARRAY;
        }
        return array;
    }

    public static String[] nullToEmpty(String[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return Normal.EMPTY_STRING_ARRAY;
        }
        return array;
    }

    public static long[] nullToEmpty(long[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return Normal.EMPTY_LONG_ARRAY;
        }
        return array;
    }

    public static int[] nullToEmpty(int[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return Normal.EMPTY_INT_ARRAY;
        }
        return array;
    }

    public static short[] nullToEmpty(short[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return Normal.EMPTY_SHORT_ARRAY;
        }
        return array;
    }

    public static char[] nullToEmpty(char[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return Normal.EMPTY_CHAR_ARRAY;
        }
        return array;
    }

    public static byte[] nullToEmpty(byte[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        return array;
    }

    public static double[] nullToEmpty(double[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return Normal.EMPTY_DOUBLE_ARRAY;
        }
        return array;
    }

    public static float[] nullToEmpty(float[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return Normal.EMPTY_FLOAT_ARRAY;
        }
        return array;
    }

    public static boolean[] nullToEmpty(boolean[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return Normal.EMPTY_BOOLEAN_ARRAY;
        }
        return array;
    }

    public static Long[] nullToEmpty(Long[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return Normal.EMPTY_LONG_OBJECT_ARRAY;
        }
        return array;
    }

    public static Integer[] nullToEmpty(Integer[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return Normal.EMPTY_INTEGER_OBJECT_ARRAY;
        }
        return array;
    }

    public static Short[] nullToEmpty(Short[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return Normal.EMPTY_SHORT_OBJECT_ARRAY;
        }
        return array;
    }

    public static Character[] nullToEmpty(Character[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return Normal.EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        return array;
    }

    public static Byte[] nullToEmpty(Byte[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return Normal.EMPTY_BYTE_OBJECT_ARRAY;
        }
        return array;
    }

    public static Double[] nullToEmpty(Double[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return Normal.EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        return array;
    }

    public static Float[] nullToEmpty(Float[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return Normal.EMPTY_FLOAT_OBJECT_ARRAY;
        }
        return array;
    }

    public static Boolean[] nullToEmpty(Boolean[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return Normal.EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        return array;
    }

    public static <T> T[] subarray(T[] array, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        int newSize = endIndex - startIndex;
        Class<?> type = array.getClass().getComponentType();
        if (newSize <= 0) {
            Object[] emptyArray = (Object[])Array.newInstance(type, 0);
            return emptyArray;
        }
        Object[] subarray = (Object[])Array.newInstance(type, newSize);
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static long[] subarray(long[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_LONG_ARRAY;
        }
        long[] subarray = new long[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static int[] subarray(int[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_INT_ARRAY;
        }
        int[] subarray = new int[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static short[] subarray(short[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_SHORT_ARRAY;
        }
        short[] subarray = new short[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static char[] subarray(char[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_CHAR_ARRAY;
        }
        char[] subarray = new char[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static byte[] subarray(byte[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        byte[] subarray = new byte[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static double[] subarray(double[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_DOUBLE_ARRAY;
        }
        double[] subarray = new double[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static float[] subarray(float[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_FLOAT_ARRAY;
        }
        float[] subarray = new float[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static boolean[] subarray(boolean[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] subarray = new boolean[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static boolean isSameLength(Object[] array1, Object[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(long[] array1, long[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(int[] array1, int[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(short[] array1, short[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(char[] array1, char[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(byte[] array1, byte[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(double[] array1, double[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(float[] array1, float[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(boolean[] array1, boolean[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static int getLength(Object array) {
        if (array == null) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static boolean isSameType(Object array1, Object array2) {
        if (array1 == null || array2 == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        return array1.getClass().getName().equals(array2.getClass().getName());
    }

    public static void reverse(Object[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(long[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(int[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(short[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(char[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(byte[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(double[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(float[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(boolean[] array) {
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, array.length);
    }

    public static void reverse(boolean[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            boolean tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(byte[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(char[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            char tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(double[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            double tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(float[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            float tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(int[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            int tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(long[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            long tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(Object[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(short[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            short tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void swap(Object[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(long[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(int[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(short[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(char[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(byte[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(double[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(float[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(boolean[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayUtils.swap(array, offset1, offset2, 1);
    }

    public static void swap(boolean[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            boolean aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(byte[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            byte aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(char[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            char aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(double[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            double aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(float[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            float aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(int[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            int aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(long[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            long aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(Object[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            Object aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(short[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        if (offset1 == offset2) {
            return;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            short aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void shift(Object[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(long[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(int[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(short[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(char[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(byte[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(double[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(float[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(boolean[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, array.length, offset);
    }

    public static void shift(boolean[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(byte[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(char[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(double[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(float[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(int[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(long[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(Object[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(short[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static int indexOf(Object[] array, Object value) {
        return ArrayUtils.indexOf(array, value, 0);
    }

    public static int indexOf(Object[] array, Object value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        if (value == null) {
            for (int i = index; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i < array.length; ++i) {
                if (!value.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Object[] array, Object value) {
        return ArrayUtils.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(Object[] array, Object value, int index) {
        block6: {
            block5: {
                if (array == null) {
                    return -1;
                }
                if (index < 0) {
                    return -1;
                }
                if (index >= array.length) {
                    index = array.length - 1;
                }
                if (value != null) break block5;
                for (int i = index; i >= 0; --i) {
                    if (array[i] != null) continue;
                    return i;
                }
                break block6;
            }
            if (!array.getClass().getComponentType().isInstance(value)) break block6;
            for (int i = index; i >= 0; --i) {
                if (!value.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(Object[] array, Object value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static int indexOf(long[] array, long value) {
        return ArrayUtils.indexOf(array, value, 0);
    }

    public static int indexOf(long[] array, long value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long value) {
        return ArrayUtils.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(long[] array, long value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(long[] array, long value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static int indexOf(int[] array, int value) {
        return ArrayUtils.indexOf(array, value, 0);
    }

    public static int indexOf(int[] array, int value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int value) {
        return ArrayUtils.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(int[] array, int value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(int[] array, int value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static int indexOf(short[] array, short value) {
        return ArrayUtils.indexOf(array, value, 0);
    }

    public static int indexOf(short[] array, short value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short value) {
        return ArrayUtils.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(short[] array, short value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(short[] array, short value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static int indexOf(char[] array, char value) {
        return ArrayUtils.indexOf(array, value, 0);
    }

    public static int indexOf(char[] array, char value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char value) {
        return ArrayUtils.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(char[] array, char value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(char[] array, char value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static int indexOf(byte[] array, byte value) {
        return ArrayUtils.indexOf(array, value, 0);
    }

    public static int indexOf(byte[] array, byte value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array, byte value) {
        return ArrayUtils.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(byte[] array, byte value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(byte[] array, byte value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static int indexOf(double[] array, double value) {
        return ArrayUtils.indexOf(array, value, 0);
    }

    public static int indexOf(double[] array, double value, double tolerance) {
        return ArrayUtils.indexOf(array, value, 0, tolerance);
    }

    public static int indexOf(double[] array, double value, int index) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double value, int index, double tolerance) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        double min = value - tolerance;
        double max = value + tolerance;
        for (int i = index; i < array.length; ++i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double value) {
        return ArrayUtils.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(double[] array, double value, double tolerance) {
        return ArrayUtils.lastIndexOf(array, value, Integer.MAX_VALUE, tolerance);
    }

    public static int lastIndexOf(double[] array, double value, int index) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double value, int index, double tolerance) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        double min = value - tolerance;
        double max = value + tolerance;
        for (int i = index; i >= 0; --i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(double[] array, double value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static boolean contains(double[] array, double value, double tolerance) {
        return ArrayUtils.indexOf(array, value, 0, tolerance) != -1;
    }

    public static int indexOf(float[] array, float value) {
        return ArrayUtils.indexOf(array, value, 0);
    }

    public static int indexOf(float[] array, float value, int index) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float value) {
        return ArrayUtils.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(float[] array, float value, int index) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(float[] array, float value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static int indexOf(boolean[] array, boolean value) {
        return ArrayUtils.indexOf(array, value, 0);
    }

    public static int indexOf(boolean[] array, boolean value, int index) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array, boolean value) {
        return ArrayUtils.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(boolean[] array, boolean value, int index) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(boolean[] array, boolean value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static char[] toPrimitive(Character[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].charValue();
        }
        return result;
    }

    public static char[] toPrimitive(Character[] array, char valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            Character b = array[i];
            result[i] = b == null ? valueForNull : b.charValue();
        }
        return result;
    }

    public static Character[] toObject(char[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Character.valueOf(array[i]);
        }
        return result;
    }

    public static long[] toPrimitive(Long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static long[] toPrimitive(Long[] array, long valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            Long b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Long[] toObject(long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static int[] toPrimitive(Integer[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static int[] toPrimitive(Integer[] array, int valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            Integer b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Integer[] toObject(int[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static short[] toPrimitive(Short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static short[] toPrimitive(Short[] array, short valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            Short b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Short[] toObject(short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] toPrimitive(Byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] toPrimitive(Byte[] array, byte valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            Byte b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Byte[] toObject(byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] toPrimitive(Double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] toPrimitive(Double[] array, double valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            Double b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Double[] toObject(double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static float[] toPrimitive(Float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    public static float[] toPrimitive(Float[] array, float valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            Float b = array[i];
            result[i] = b == null ? valueForNull : b.floatValue();
        }
        return result;
    }

    public static Float[] toObject(float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    public static Object toPrimitive(Object array) {
        if (array == null) {
            return null;
        }
        Class<?> ct = array.getClass().getComponentType();
        Class<?> pt = ClassUtils.wrapperToPrimitive(ct);
        if (Integer.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Integer[])array);
        }
        if (Long.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Long[])array);
        }
        if (Short.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Short[])array);
        }
        if (Double.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Double[])array);
        }
        if (Float.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Float[])array);
        }
        return array;
    }

    public static boolean[] toPrimitive(Boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static boolean[] toPrimitive(Boolean[] array, boolean valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            Boolean b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Boolean[] toObject(boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] ? Boolean.TRUE : Boolean.FALSE;
        }
        return result;
    }

    public static boolean isEmpty(Object array) {
        if (null == array) {
            return true;
        }
        if (ArrayUtils.isArray(array)) {
            return 0 == Array.getLength(array);
        }
        throw new InstrumentException("Object to provide is not a Array !");
    }

    public static boolean isEmpty(Object[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(long[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(int[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(short[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(char[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(double[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(float[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(long[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(int[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(short[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(char[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(byte[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(double[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(float[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(boolean[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static <T> T[] addAll(T[] array1, T ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        Class<?> type1 = array1.getClass().getComponentType();
        Object[] joinedArray = (Object[])Array.newInstance(type1, array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName(), ase);
            }
            throw ase;
        }
        return joinedArray;
    }

    public static boolean[] addAll(boolean[] array1, boolean ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        boolean[] joinedArray = new boolean[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static char[] addAll(char[] array1, char ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        char[] joinedArray = new char[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static byte[] addAll(byte[] array1, byte ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        byte[] joinedArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static short[] addAll(short[] array1, short ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        short[] joinedArray = new short[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static int[] addAll(int[] array1, int ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        int[] joinedArray = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static long[] addAll(long[] array1, long ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        long[] joinedArray = new long[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static float[] addAll(float[] array1, float ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        float[] joinedArray = new float[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static double[] addAll(double[] array1, double ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        double[] joinedArray = new double[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static <T> T[] add(T[] array, T element) {
        Class<?> type;
        if (array != null) {
            type = array.getClass().getComponentType();
        } else if (element != null) {
            type = element.getClass();
        } else {
            throw new IllegalArgumentException("Arguments cannot both be null");
        }
        Object[] newArray = (Object[])ArrayUtils.copyArrayGrow1(array, type);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static boolean[] add(boolean[] array, boolean element) {
        boolean[] newArray = (boolean[])ArrayUtils.copyArrayGrow1(array, Boolean.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static byte[] add(byte[] array, byte element) {
        byte[] newArray = (byte[])ArrayUtils.copyArrayGrow1(array, Byte.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static char[] add(char[] array, char element) {
        char[] newArray = (char[])ArrayUtils.copyArrayGrow1(array, Character.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static double[] add(double[] array, double element) {
        double[] newArray = (double[])ArrayUtils.copyArrayGrow1(array, Double.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static float[] add(float[] array, float element) {
        float[] newArray = (float[])ArrayUtils.copyArrayGrow1(array, Float.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static int[] add(int[] array, int element) {
        int[] newArray = (int[])ArrayUtils.copyArrayGrow1(array, Integer.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static long[] add(long[] array, long element) {
        long[] newArray = (long[])ArrayUtils.copyArrayGrow1(array, Long.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static short[] add(short[] array, short element) {
        short[] newArray = (short[])ArrayUtils.copyArrayGrow1(array, Short.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    private static Object copyArrayGrow1(Object array, Class<?> newArrayComponentType) {
        if (array != null) {
            int arrayLength = Array.getLength(array);
            Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + 1);
            System.arraycopy(array, 0, newArray, 0, arrayLength);
            return newArray;
        }
        return Array.newInstance(newArrayComponentType, 1);
    }

    public static <T> T[] add(T[] array, int index, T element) {
        Class<?> clss;
        if (array != null) {
            clss = array.getClass().getComponentType();
        } else if (element != null) {
            clss = element.getClass();
        } else {
            throw new IllegalArgumentException("Array and element cannot both be null");
        }
        return (Object[])ArrayUtils.add(array, index, element, clss);
    }

    public static boolean[] add(boolean[] array, int index, boolean element) {
        return (boolean[])ArrayUtils.add(array, index, element, Boolean.TYPE);
    }

    public static char[] add(char[] array, int index, char element) {
        return (char[])ArrayUtils.add(array, index, Character.valueOf(element), Character.TYPE);
    }

    public static byte[] add(byte[] array, int index, byte element) {
        return (byte[])ArrayUtils.add(array, index, element, Byte.TYPE);
    }

    public static short[] add(short[] array, int index, short element) {
        return (short[])ArrayUtils.add(array, index, element, Short.TYPE);
    }

    public static int[] add(int[] array, int index, int element) {
        return (int[])ArrayUtils.add(array, index, element, Integer.TYPE);
    }

    public static long[] add(long[] array, int index, long element) {
        return (long[])ArrayUtils.add(array, index, element, Long.TYPE);
    }

    public static float[] add(float[] array, int index, float element) {
        return (float[])ArrayUtils.add(array, index, Float.valueOf(element), Float.TYPE);
    }

    public static double[] add(double[] array, int index, double element) {
        return (double[])ArrayUtils.add(array, index, element, Double.TYPE);
    }

    private static Object add(Object array, int index, Object element, Class<?> clss) {
        if (array == null) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Length: 0");
            }
            Object joinedArray = Array.newInstance(clss, 1);
            Array.set(joinedArray, 0, element);
            return joinedArray;
        }
        int length = Array.getLength(array);
        if (index > length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = Array.newInstance(clss, length + 1);
        System.arraycopy(array, 0, result, 0, index);
        Array.set(result, index, element);
        if (index < length) {
            System.arraycopy(array, index, result, index + 1, length - index);
        }
        return result;
    }

    public static <T> T[] remove(T[] array, int index) {
        return (Object[])ArrayUtils.remove(array, index);
    }

    public static <T> T[] removeElement(T[] array, Object element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static boolean[] remove(boolean[] array, int index) {
        return (boolean[])ArrayUtils.remove((Object)array, index);
    }

    public static boolean[] removeElement(boolean[] array, boolean element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static byte[] remove(byte[] array, int index) {
        return (byte[])ArrayUtils.remove((Object)array, index);
    }

    public static byte[] removeElement(byte[] array, byte element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static char[] remove(char[] array, int index) {
        return (char[])ArrayUtils.remove((Object)array, index);
    }

    public static char[] removeElement(char[] array, char element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static double[] remove(double[] array, int index) {
        return (double[])ArrayUtils.remove((Object)array, index);
    }

    public static double[] removeElement(double[] array, double element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static float[] remove(float[] array, int index) {
        return (float[])ArrayUtils.remove((Object)array, index);
    }

    public static float[] removeElement(float[] array, float element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static int[] remove(int[] array, int index) {
        return (int[])ArrayUtils.remove((Object)array, index);
    }

    public static int[] removeElement(int[] array, int element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static long[] remove(long[] array, int index) {
        return (long[])ArrayUtils.remove((Object)array, index);
    }

    public static long[] removeElement(long[] array, long element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static short[] remove(short[] array, int index) {
        return (short[])ArrayUtils.remove((Object)array, index);
    }

    public static short[] removeElement(short[] array, short element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(array, index);
    }

    private static Object remove(Object array, int index) {
        int length = ArrayUtils.getLength(array);
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - 1);
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    public static <T> T[] removeAll(T[] array, int ... indices) {
        return (Object[])ArrayUtils.removeAll(array, indices);
    }

    public static <T> T[] removeElements(T[] array, T ... values) {
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<T, MutableInt> occurrences = new HashMap<T, MutableInt>(values.length);
        for (T v : values) {
            MutableInt count = (MutableInt)occurrences.get(v);
            if (count == null) {
                occurrences.put(v, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            T key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (Object[])ArrayUtils.removeAll(array, toRemove);
    }

    public static byte[] removeAll(byte[] array, int ... indices) {
        return (byte[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static byte[] removeElements(byte[] array, byte ... values) {
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Byte, MutableInt> occurrences = new HashMap<Byte, MutableInt>(values.length);
        for (byte v : values) {
            Byte boxed = v;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            byte key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (byte[])ArrayUtils.removeAll((Object)array, toRemove);
    }

    public static short[] removeAll(short[] array, int ... indices) {
        return (short[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static short[] removeElements(short[] array, short ... values) {
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Short, MutableInt> occurrences = new HashMap<Short, MutableInt>(values.length);
        for (short v : values) {
            Short boxed = v;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            short key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (short[])ArrayUtils.removeAll((Object)array, toRemove);
    }

    public static int[] removeAll(int[] array, int ... indices) {
        return (int[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static int[] removeElements(int[] array, int ... values) {
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Integer, MutableInt> occurrences = new HashMap<Integer, MutableInt>(values.length);
        for (int v : values) {
            Integer boxed = v;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            int key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (int[])ArrayUtils.removeAll((Object)array, toRemove);
    }

    public static char[] removeAll(char[] array, int ... indices) {
        return (char[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static char[] removeElements(char[] array, char ... values) {
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Character, MutableInt> occurrences = new HashMap<Character, MutableInt>(values.length);
        for (char v : values) {
            Character boxed = Character.valueOf(v);
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            char key = array[i];
            MutableInt count = (MutableInt)occurrences.get(Character.valueOf(key));
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(Character.valueOf(key));
            }
            toRemove.set(i);
        }
        return (char[])ArrayUtils.removeAll((Object)array, toRemove);
    }

    public static long[] removeAll(long[] array, int ... indices) {
        return (long[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static long[] removeElements(long[] array, long ... values) {
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Long, MutableInt> occurrences = new HashMap<Long, MutableInt>(values.length);
        for (long v : values) {
            Long boxed = v;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            long key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (long[])ArrayUtils.removeAll((Object)array, toRemove);
    }

    public static float[] removeAll(float[] array, int ... indices) {
        return (float[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static float[] removeElements(float[] array, float ... values) {
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Float, MutableInt> occurrences = new HashMap<Float, MutableInt>(values.length);
        for (float v : values) {
            Float boxed = Float.valueOf(v);
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            float key = array[i];
            MutableInt count = (MutableInt)occurrences.get(Float.valueOf(key));
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(Float.valueOf(key));
            }
            toRemove.set(i);
        }
        return (float[])ArrayUtils.removeAll((Object)array, toRemove);
    }

    public static double[] removeAll(double[] array, int ... indices) {
        return (double[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static double[] removeElements(double[] array, double ... values) {
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Double, MutableInt> occurrences = new HashMap<Double, MutableInt>(values.length);
        for (double v : values) {
            Double boxed = v;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            double key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (double[])ArrayUtils.removeAll((Object)array, toRemove);
    }

    public static boolean[] removeAll(boolean[] array, int ... indices) {
        return (boolean[])ArrayUtils.removeAll((Object)array, indices);
    }

    public static boolean[] removeElements(boolean[] array, boolean ... values) {
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Boolean, MutableInt> occurrences = new HashMap<Boolean, MutableInt>(2);
        for (boolean v : values) {
            Boolean boxed = v;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            boolean key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (boolean[])ArrayUtils.removeAll((Object)array, toRemove);
    }

    static Object removeAll(Object array, int ... indices) {
        int length = ArrayUtils.getLength(array);
        int diff = 0;
        int[] clonedIndices = ArrayUtils.clone(indices);
        Arrays.sort(clonedIndices);
        if (ArrayUtils.isNotEmpty(clonedIndices)) {
            int i = clonedIndices.length;
            int prevIndex = length;
            while (--i >= 0) {
                int index = clonedIndices[i];
                if (index < 0 || index >= length) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
                }
                if (index >= prevIndex) continue;
                ++diff;
                prevIndex = index;
            }
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - diff);
        if (diff < length) {
            int end = length;
            int dest = length - diff;
            for (int i = clonedIndices.length - 1; i >= 0; --i) {
                int index = clonedIndices[i];
                if (end - index > 1) {
                    int cp = end - index - 1;
                    System.arraycopy(array, index + 1, result, dest -= cp, cp);
                }
                end = index;
            }
            if (end > 0) {
                System.arraycopy(array, 0, result, 0, end);
            }
        }
        return result;
    }

    static Object removeAll(Object array, BitSet indices) {
        int count;
        int set;
        int srcLength = ArrayUtils.getLength(array);
        int removals = indices.cardinality();
        Object result = Array.newInstance(array.getClass().getComponentType(), srcLength - removals);
        int srcIndex = 0;
        int destIndex = 0;
        while ((set = indices.nextSetBit(srcIndex)) != -1) {
            count = set - srcIndex;
            if (count > 0) {
                System.arraycopy(array, srcIndex, result, destIndex, count);
                destIndex += count;
            }
            srcIndex = indices.nextClearBit(set);
        }
        count = srcLength - srcIndex;
        if (count > 0) {
            System.arraycopy(array, srcIndex, result, destIndex, count);
        }
        return result;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(T[] array) {
        return ArrayUtils.isSorted(array, (o1, o2) -> o1.compareTo(o2));
    }

    public static <T> boolean isSorted(T[] array, Comparator<T> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator should not be null.");
        }
        if (array == null || array.length < 2) {
            return true;
        }
        T previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            T current = array[i];
            if (comparator.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(int[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        int previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            int current = array[i];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(long[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        long previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            long current = array[i];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(short[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        short previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            short current = array[i];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(double[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        double previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            double current = array[i];
            if (Double.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(float[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        float previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            float current = array[i];
            if (Float.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(byte[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        byte previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            byte current = array[i];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(char[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        char previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            char current = array[i];
            if (CharUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(boolean[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        boolean previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            boolean current = array[i];
            if (BooleanUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean[] removeAllOccurences(boolean[] array, boolean element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayUtils.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static char[] removeAllOccurences(char[] array, char element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayUtils.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static byte[] removeAllOccurences(byte[] array, byte element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayUtils.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static short[] removeAllOccurences(short[] array, short element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayUtils.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static int[] removeAllOccurences(int[] array, int element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayUtils.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static long[] removeAllOccurences(long[] array, long element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayUtils.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static float[] removeAllOccurences(float[] array, float element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayUtils.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static double[] removeAllOccurences(double[] array, double element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayUtils.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static <T> T[] removeAllOccurences(T[] array, T element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayUtils.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayUtils.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static String[] toStringArray(Object[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].toString();
        }
        return result;
    }

    public static String[] toStringArray(Object[] array, String valueForNullElements) {
        if (null == array) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            Object object = array[i];
            result[i] = object == null ? valueForNullElements : object.toString();
        }
        return result;
    }

    public static <T> Object insert(Object array, int index, T ... newElements) {
        if (ArrayUtils.isEmpty(newElements)) {
            return array;
        }
        if (ArrayUtils.isEmpty(array)) {
            return newElements;
        }
        int len = ArrayUtils.length(array);
        if (index < 0) {
            index = index % len + len;
        }
        T[] result = ArrayUtils.newArray(array.getClass().getComponentType(), Math.max(len, index) + newElements.length);
        System.arraycopy(array, 0, result, 0, Math.min(len, index));
        System.arraycopy(newElements, 0, result, index, newElements.length);
        if (index < len) {
            System.arraycopy(array, index, result, index + newElements.length, len - index);
        }
        return result;
    }

    public static boolean[] insert(int index, boolean[] array, boolean ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        boolean[] result = new boolean[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static byte[] insert(int index, byte[] array, byte ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        byte[] result = new byte[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static char[] insert(int index, char[] array, char ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        char[] result = new char[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static double[] insert(int index, double[] array, double ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        double[] result = new double[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static float[] insert(int index, float[] array, float ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        float[] result = new float[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static int[] insert(int index, int[] array, int ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        int[] result = new int[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static long[] insert(int index, long[] array, long ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        long[] result = new long[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static short[] insert(int index, short[] array, short ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        short[] result = new short[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static <T> T[] insert(int index, T[] array, T ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        Class<?> type = array.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(type, array.length + values.length);
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static void shuffle(Object[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(Object[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(boolean[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(boolean[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(byte[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(byte[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(char[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(char[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(short[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(short[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(int[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(int[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(long[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(long[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(float[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(float[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(double[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(double[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static <T> boolean isArrayIndexValid(T[] array, int index) {
        if (ArrayUtils.getLength(array) == 0 || array.length <= index) {
            return false;
        }
        return index >= 0;
    }

    public static <T> boolean hasNull(T ... array) {
        if (ArrayUtils.isNotEmpty(array)) {
            for (T element : array) {
                if (null != element) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> T firstNonNull(T ... array) {
        if (ArrayUtils.isNotEmpty(array)) {
            for (T val : array) {
                if (null == val) continue;
                return val;
            }
        }
        return null;
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static <T> T[] newArray(int newSize) {
        return new Object[newSize];
    }

    public static Class<?> getComponentType(Object array) {
        return null == array ? null : array.getClass().getComponentType();
    }

    public static Class<?> getComponentType(Class<?> arrayClass) {
        return null == arrayClass ? null : arrayClass.getComponentType();
    }

    public static Class<?> getArrayType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public static Object[] cast(Class<?> type, Object arrayObj) throws NullPointerException, IllegalArgumentException {
        if (null == arrayObj) {
            throw new NullPointerException("Argument [arrayObj] is null !");
        }
        if (!arrayObj.getClass().isArray()) {
            throw new IllegalArgumentException("Argument [arrayObj] is not array !");
        }
        if (null == type) {
            return (Object[])arrayObj;
        }
        Class<?> componentType = type.isArray() ? type.getComponentType() : type;
        Object[] array = (Object[])arrayObj;
        Object[] result = ArrayUtils.newArray(componentType, array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (ArrayUtils.isEmpty(buffer)) {
            return newElements;
        }
        return ArrayUtils.insert(buffer, buffer.length, newElements);
    }

    public static <T> Object append(Object array, T ... newElements) {
        if (ArrayUtils.isEmpty(array)) {
            return newElements;
        }
        return ArrayUtils.insert(array, ArrayUtils.length(array), newElements);
    }

    public static <T> T[] setOrAppend(T[] buffer, int index, T value) {
        if (index < buffer.length) {
            Array.set(buffer, index, value);
            return buffer;
        }
        return ArrayUtils.append(buffer, value);
    }

    public static Object setOrAppend(Object array, int index, Object value) {
        if (index < ArrayUtils.length(array)) {
            Array.set(array, index, value);
            return array;
        }
        return ArrayUtils.append(array, value);
    }

    public static <T> T[] insert(T[] array, int index, T ... newElements) {
        if (ArrayUtils.isEmpty(newElements)) {
            return array;
        }
        if (ArrayUtils.isEmpty(array)) {
            return newElements;
        }
        int len = ArrayUtils.length(array);
        if (index < 0) {
            index = index % len + len;
        }
        T[] result = ArrayUtils.newArray(array.getClass().getComponentType(), Math.max(len, index) + newElements.length);
        System.arraycopy(array, 0, result, 0, Math.min(len, index));
        System.arraycopy(newElements, 0, result, index, newElements.length);
        if (index < len) {
            System.arraycopy(array, index, result, index + newElements.length, len - index);
        }
        return result;
    }

    public static <T> T[] resize(T[] buffer, int newSize, Class<?> componentType) {
        T[] newArray = ArrayUtils.newArray(componentType, newSize);
        if (ArrayUtils.isNotEmpty(buffer)) {
            System.arraycopy(buffer, 0, newArray, 0, Math.min(buffer.length, newSize));
        }
        return newArray;
    }

    public static <T> T[] resize(T[] buffer, int newSize) {
        return ArrayUtils.resize(buffer, newSize, buffer.getClass().getComponentType());
    }

    public static byte[] resize(byte[] bytes, int newSize) {
        if (newSize < 0) {
            return bytes;
        }
        byte[] newArray = new byte[newSize];
        if (newSize > 0 && ArrayUtils.isNotEmpty(bytes)) {
            System.arraycopy(bytes, 0, newArray, 0, Math.min(bytes.length, newSize));
        }
        return newArray;
    }

    public static <T> T[] addAll(T[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            length += array.length;
        }
        T[] result = ArrayUtils.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        length = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static Object copy(Object src, int srcPos, Object dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static Object copy(Object src, Object dest, int length) {
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    public static int[] range(int excludedEnd) {
        return ArrayUtils.range(0, excludedEnd, 1);
    }

    public static int[] range(int includedStart, int excludedEnd) {
        return ArrayUtils.range(includedStart, excludedEnd, 1);
    }

    public static int[] range(int includedStart, int excludedEnd, int step) {
        if (includedStart > excludedEnd) {
            int tmp = includedStart;
            includedStart = excludedEnd;
            excludedEnd = tmp;
        }
        if (step <= 0) {
            step = 1;
        }
        int deviation = excludedEnd - includedStart;
        int length = deviation / step;
        if (deviation % step != 0) {
            ++length;
        }
        int[] range = new int[length];
        for (int i = 0; i < length; ++i) {
            range[i] = includedStart;
            includedStart += step;
        }
        return range;
    }

    public static byte[][] split(byte[] array, int len) {
        int x = array.length / len;
        int y = array.length % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        byte[][] arrays = new byte[x + z][];
        for (int i = 0; i < x + z; ++i) {
            byte[] arr = new byte[len];
            if (i == x + z - 1 && y != 0) {
                System.arraycopy(array, i * len, arr, 0, y);
            } else {
                System.arraycopy(array, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }

    public static int indexOfIgnoreCase(CharSequence[] array, CharSequence value) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (!StringUtils.equalsIgnoreCase(array[i], value)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int[] unWrap(Integer ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_INT_ARRAY;
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Long[] wrap(long ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] array = new Long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static long[] unWrap(Long ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_LONG_ARRAY;
        }
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Character[] wrap(char ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] array = new Character[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Character.valueOf(values[i]);
        }
        return array;
    }

    public static char[] unWrap(Character ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_CHAR_ARRAY;
        }
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i].charValue();
        }
        return array;
    }

    public static Byte[] wrap(byte ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] array = new Byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static byte[] unWrap(Byte ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Short[] wrap(short ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] array = new Short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static short[] unWrap(Short ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_SHORT_ARRAY;
        }
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Float[] wrap(float ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] array = new Float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Float.valueOf(values[i]);
        }
        return array;
    }

    public static float[] unWrap(Float ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_FLOAT_ARRAY;
        }
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i].floatValue();
        }
        return array;
    }

    public static Double[] wrap(double ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] array = new Double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static double[] unWrap(Double ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_DOUBLE_ARRAY;
        }
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Boolean[] wrap(boolean ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] array = new Boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static boolean[] unWrap(Boolean ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Object[] wrap(Object obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtils.isArray(obj)) {
            try {
                return (Object[])obj;
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return ArrayUtils.wrap((long[])obj);
                    }
                    case "int": {
                        return ArrayUtils.wrap(obj);
                    }
                    case "short": {
                        return ArrayUtils.wrap((short[])obj);
                    }
                    case "char": {
                        return ArrayUtils.wrap((char[])obj);
                    }
                    case "byte": {
                        return ArrayUtils.wrap((byte[])obj);
                    }
                    case "boolean": {
                        return ArrayUtils.wrap((boolean[])obj);
                    }
                    case "float": {
                        return ArrayUtils.wrap((float[])obj);
                    }
                    case "double": {
                        return ArrayUtils.wrap((double[])obj);
                    }
                }
                throw new InstrumentException(e);
            }
        }
        throw new InstrumentException("is not Array!");
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static <T> T get(Object array, int index) {
        if (index < 0) {
            index += Array.getLength(array);
        }
        return (T)Array.get(array, index);
    }

    public static <T> T[] getAny(Object array, int ... indexes) {
        T[] result = ArrayUtils.newArray(indexes.length);
        for (int i : indexes) {
            result[i] = ArrayUtils.get(array, i);
        }
        return result;
    }

    public static Object[] sub(Object array, int start, int end) {
        return ArrayUtils.sub(array, start, end, 1);
    }

    public static Object[] sub(Object array, int start, int end, int step) {
        int length = ArrayUtils.length(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return Normal.EMPTY_OBJECT_ARRAY;
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return Normal.EMPTY_OBJECT_ARRAY;
            }
            end = length;
        }
        if (step <= 1) {
            step = 1;
        }
        ArrayList list = new ArrayList();
        for (int i = start; i < end; i += step) {
            list.add(ArrayUtils.get(array, i));
        }
        return list.toArray();
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static String join(long[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (long item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static <T> String join(T[] array, CharSequence conjunction) {
        return ArrayUtils.join(array, conjunction, null, null);
    }

    public static <T> String join(T[] array, CharSequence conjunction, String prefix, String suffix) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (T item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            if (ArrayUtils.isArray(item)) {
                sb.append(ArrayUtils.join(ArrayUtils.wrap(item), conjunction, prefix, suffix));
                continue;
            }
            if (item instanceof Iterable) {
                sb.append(IterUtils.join((Iterable)item, conjunction, prefix, suffix));
                continue;
            }
            if (item instanceof Iterator) {
                sb.append(IterUtils.join((Iterator)item, conjunction, prefix, suffix));
                continue;
            }
            sb.append(StringUtils.wrap(StringUtils.toString(item), prefix, suffix));
        }
        return sb.toString();
    }

    public static String join(int[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (int item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(short[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (short item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(char[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (char item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(byte[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (byte item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(boolean[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (boolean item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(float[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (float item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(double[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (double item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(Object array, CharSequence conjunction) {
        if (ArrayUtils.isArray(array)) {
            Class<?> componentType = array.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                String componentTypeName;
                switch (componentTypeName = componentType.getName()) {
                    case "long": {
                        return ArrayUtils.join((long[])array, conjunction);
                    }
                    case "int": {
                        return ArrayUtils.join((int[])array, conjunction);
                    }
                    case "short": {
                        return ArrayUtils.join((short[])array, conjunction);
                    }
                    case "char": {
                        return ArrayUtils.join((char[])array, conjunction);
                    }
                    case "byte": {
                        return ArrayUtils.join((byte[])array, conjunction);
                    }
                    case "boolean": {
                        return ArrayUtils.join((boolean[])array, conjunction);
                    }
                    case "float": {
                        return ArrayUtils.join((float[])array, conjunction);
                    }
                    case "double": {
                        return ArrayUtils.join((double[])array, conjunction);
                    }
                }
                throw new InstrumentException("Unknown primitive type:" + componentTypeName);
            }
            return ArrayUtils.join(array, conjunction);
        }
        throw new InstrumentException("is not a Array!");
    }

    public static byte[] toArray(ByteBuffer bytebuffer) {
        if (!bytebuffer.hasArray()) {
            int oldPosition = bytebuffer.position();
            bytebuffer.position(0);
            int size = bytebuffer.limit();
            byte[] buffers = new byte[size];
            bytebuffer.get(buffers);
            bytebuffer.position(oldPosition);
            return buffers;
        }
        return Arrays.copyOfRange(bytebuffer.array(), bytebuffer.position(), bytebuffer.limit());
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> componentType) {
        T[] array = ArrayUtils.newArray(componentType, collection.size());
        return collection.toArray(array);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (ObjectUtils.compare(min, numberArray[i]) <= 0) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static long min(long ... numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static int min(int ... numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static short min(short ... numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static char min(char ... numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static byte min(byte ... numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static double min(double ... numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(min > numberArray[i])) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static float min(float ... numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(min > numberArray[i])) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (ObjectUtils.compare(max, numberArray[i]) >= 0) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static long max(long ... numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static int max(int ... numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static short max(short ... numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static char max(char ... numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static byte max(byte ... numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static double max(double ... numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(max < numberArray[i])) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static float max(float ... numberArray) {
        if (ArrayUtils.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(max < numberArray[i])) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values, boolean isOrder) {
        if (ArrayUtils.isEmpty(keys) || ArrayUtils.isEmpty(values)) {
            return null;
        }
        int size = Math.min(keys.length, values.length);
        HashMap<K, V> map = CollUtils.newHashMap(size, isOrder);
        for (int i = 0; i < size; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <T> T[] filter(T[] array, Editor<T> editor) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T t : array) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            list.add(modified);
        }
        return list.toArray(Arrays.copyOf(array, list.size()));
    }

    public static <T> T[] filter(T[] array, Filter<T> filter) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T t : array) {
            boolean isAccept = filter.accept(t);
            if (!isAccept) continue;
            list.add(t);
        }
        return list.toArray(Arrays.copyOf(array, list.size()));
    }

    public static boolean containsIgnoreCase(CharSequence[] array, CharSequence value) {
        return ArrayUtils.indexOfIgnoreCase(array, value) > -1;
    }

    public static Optional<Object> firstNotNullElem(Object[] objects) {
        if (ArrayUtils.isEmpty(objects)) {
            return Optional.empty();
        }
        for (Object elem : objects) {
            if (!ObjectUtils.isNotNull(elem)) continue;
            return Optional.of(elem);
        }
        return Optional.empty();
    }

    public static <T> T[] distinct(T[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return array;
        }
        LinkedHashSet set = new LinkedHashSet(array.length, 1.0f);
        Collections.addAll(set, array);
        return ArrayUtils.toArray(set, ArrayUtils.getComponentType(array));
    }
}

