/*********************************************************************************
 *                                                                               *
 * The MIT License                                                               *
 *                                                                               *
 * Copyright (c) 2015-2020 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 ********************************************************************************/
package org.aoju.bus.core.lang;

import org.aoju.bus.core.date.format.FormatBuilder;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

/**
 * 日期场景属性
 *
 * @author Kimi Liu
 * @version 5.8.2
 * @since JDK 1.8+
 */
public class Fields {

    /**
     * 格式化通配符: yyyy
     */
    public static final String NORM_YEAR_PATTERN = "yyyy";
    /**
     * 格式化通配符: {@link FormatBuilder} yyyy
     */
    public static final FormatBuilder NORM_YEAR_FORMAT = FormatBuilder.getInstance(NORM_YEAR_PATTERN);

    /**
     * 格式化通配符: yyyy-MM
     */
    public static final String NORM_YEAR_MTOTH_PATTERN = "yyyy-MM";
    /**
     * 格式化通配符: {@link FormatBuilder}yyyy-MM
     */
    public static final FormatBuilder NORM_YEAR_MTOTH_FORMAT = FormatBuilder.getInstance(NORM_YEAR_MTOTH_PATTERN);

    /**
     * 格式化通配符: yyyy-MM-dd
     */
    public static final String NORM_DATE_PATTERN = "yyyy-MM-dd";
    /**
     * 格式化通配符: {@link FormatBuilder} yyyy-MM-dd
     */
    public static final FormatBuilder NORM_DATE_FORMAT = FormatBuilder.getInstance(NORM_DATE_PATTERN);

    /**
     * 格式化通配符: yyyyMMdd
     */
    public static final String PURE_DATE_PATTERN = "yyyyMMdd";
    /**
     * 格式化通配符: {@link FormatBuilder} yyyyMMdd
     */
    public static final FormatBuilder PURE_DATE_FORMAT = FormatBuilder.getInstance(PURE_DATE_PATTERN);

    /**
     * 格式化通配符: yyyy-MM-dd HH:mm
     */
    public static final String NORM_DATETIME_MINUTE_PATTERN = "yyyy-MM-dd HH:mm";
    /**
     * 格式化通配符: {@link FormatBuilder} yyyy-MM-dd HH:mm
     */
    public static final FormatBuilder NORM_DATETIME_MINUTE_FORMAT = FormatBuilder.getInstance(NORM_DATETIME_MINUTE_PATTERN);

    /**
     * 格式化通配符: yyyy-MM-dd HH:mm:ss
     */
    public static final String NORM_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    /**
     * 格式化通配符: {@link FormatBuilder} yyyy-MM-dd HH:mm:ss
     */
    public static final FormatBuilder NORM_DATETIME_FORMAT = FormatBuilder.getInstance(NORM_DATETIME_PATTERN);

    /**
     * 格式化通配符: yyyy-MM-dd hh:mm:ss
     */
    public static final String NORM_PART_DATETIME_PATTERN = "yyyy-MM-dd hh:mm:ss";
    /**
     * 格式化通配符: {@link FormatBuilder} yyyy-MM-dd hh:mm:ss
     */
    public static final FormatBuilder NORM_PART_DATETIME_FORMAT = FormatBuilder.getInstance(NORM_PART_DATETIME_PATTERN);

    /**
     * 格式化通配符: :yyyy-MM-dd HH:mm:ss.SSS
     */
    public static final String NORM_DATETIME_MS_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    /**
     * 格式化通配符: {@link FormatBuilder} yyyy-MM-dd HH:mm:ss.SSS
     */
    public static final FormatBuilder NORM_DATETIME_MS_FORMAT = FormatBuilder.getInstance(NORM_DATETIME_MS_PATTERN);

    /**
     * 格式化通配符: yyyyMMddHHmmss
     */
    public static final String PURE_DATETIME_PATTERN = "yyyyMMddHHmmss";
    /**
     * 格式化通配符: {@link FormatBuilder} yyyyMMddHHmmss
     */
    public static final FormatBuilder PURE_DATETIME_FORMAT = FormatBuilder.getInstance(PURE_DATETIME_PATTERN);

    /**
     * 格式化通配符: yyyyMMddHHmmssSSS
     */
    public static final String PURE_DATETIME_MS_PATTERN = "yyyyMMddHHmmssSSS";
    /**
     * 格式化通配符: {@link FormatBuilder} yyyyMMddHHmmssSSS
     */
    public static final FormatBuilder PURE_DATETIME_MS_FORMAT = FormatBuilder.getInstance(PURE_DATETIME_MS_PATTERN);

    /**
     * 标准时间格式: HH:mm:ss
     */
    public static final String NORM_TIME_PATTERN = "HH:mm:ss";
    /**
     * 标准时间格式:{@link FormatBuilder}HH:mm:ss
     */
    public static final FormatBuilder NORM_TIME_FORMAT = FormatBuilder.getInstance(NORM_TIME_PATTERN);

    /**
     * 格式化通配符: HHmmss
     */
    public static final String PURE_TIME_PATTERN = "HHmmss";
    /**
     * 格式化通配符: {@link FormatBuilder} HHmmss
     */
    public static final FormatBuilder PURE_TIME_FORMAT = FormatBuilder.getInstance(PURE_TIME_PATTERN);

    /**
     * 格式化通配符: HHmmssSSS
     */
    public static final String PURE_TIME_MS_PATTERN = "HHmmssSSS";
    /**
     * 格式化通配符: {@link FormatBuilder} HHmmssSSS
     */
    public static final FormatBuilder PURE_TIME_MS_FORMAT = FormatBuilder.getInstance(PURE_TIME_MS_PATTERN);

    /**
     * 格式化通配符: HH:mm
     */
    public static final String HOUR_MINUTE_PATTERN = "HH:mm";
    /**
     * 格式化通配符: {@link FormatBuilder}  HH:mm
     */
    public static final FormatBuilder HOUR_MINUTE_FORMAT = FormatBuilder.getInstance(HOUR_MINUTE_PATTERN);

    /**
     * 格式化通配符: HHmm
     */
    public static final String SHORT_HOUR_MINUTE_PATTERN = "HHmm";
    /**
     * 格式化通配符: {@link FormatBuilder} HHmm
     */
    public static final FormatBuilder SHORT_HOUR_MINUTE_FORMAT = FormatBuilder.getInstance(SHORT_HOUR_MINUTE_PATTERN);

    /**
     * 格式化通配符: mm:ss
     */
    public static final String MINUTE_SECOND_PATTERN = "mm:ss";
    /**
     * 格式化通配符: {@link FormatBuilder} mm:ss
     */
    public static final FormatBuilder MINUTE_SECOND_FORMAT = FormatBuilder.getInstance(MINUTE_SECOND_PATTERN);

    /**
     * 格式化通配符: mmss
     */
    public static final String SHORT_MINUTE_SECOND_PATTERN = "mmss";
    /**
     * 格式化通配符: {@link FormatBuilder} mmss
     */
    public static final FormatBuilder SHORT_MINUTE_SECOND_FORMAT = FormatBuilder.getInstance(SHORT_MINUTE_SECOND_PATTERN);

    /**
     * HTTP头日期时间格式: EEE, dd MMM yyyy HH:mm:ss z
     */
    public static final String HTTP_DATETIME_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    /**
     * HTTP头日期时间格式: {@link FormatBuilder} EEE, dd MMM yyyy HH:mm:ss z
     */
    public static final FormatBuilder HTTP_DATETIME_FORMAT = FormatBuilder.getInstance(HTTP_DATETIME_PATTERN, TimeZone.getTimeZone("GMT"), Locale.US);

    /**
     * JDK日期时间格式: EEE MMM dd HH:mm:ss zzz yyyy
     */
    public static final String JDK_DATETIME_PATTERN = "EEE MMM dd HH:mm:ss zzz yyyy";
    /**
     * JDK日期时间格式: {@link FormatBuilder} EEE MMM dd HH:mm:ss zzz yyyy
     */
    public static final FormatBuilder JDK_DATETIME_FORMAT = FormatBuilder.getInstance(JDK_DATETIME_PATTERN, Locale.US);

    /**
     * 中文日期格式: yyyy年M月d日
     */
    public static final String NORM_DATE_CN_PATTERN = "yyyy年M月d日";
    /**
     * 中文日期格式: {@link FormatBuilder} yyyy年M月d日
     */
    public static final FormatBuilder NORM_DATE_CN_FORMAT = FormatBuilder.getInstance(NORM_DATE_CN_PATTERN);

    /**
     * 中文日期格式: M月d日
     */
    public static final String ORM_MONTH_CN_PATTERN = "M月d日";
    /**
     * 中文日期格式: {@link FormatBuilder} M月d日
     */
    public static final FormatBuilder NORM_MONTH_CN_FORMAT = FormatBuilder.getInstance(ORM_MONTH_CN_PATTERN);

    /**
     * UTC时间: yyyy-MM-dd'T'HH:mm:ss'Z'
     */
    public static final String UTC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    /**
     * UTC时间: {@link FormatBuilder} yyyy-MM-dd'T'HH:mm:ss'Z'
     */
    public static final FormatBuilder UTC_FORMAT = FormatBuilder.getInstance(UTC_PATTERN, TimeZone.getTimeZone("UTC"));

    /**
     * UTC时间: yyyy-MM-dd'T'HH:mm:ss.SSSZ
     */
    public static final String MSEC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    /**
     * UTC时间: {@link FormatBuilder} yyyy-MM-dd'T'HH:mm:ss.SSSZ
     */
    public static final FormatBuilder MSEC_FORMAT = FormatBuilder.getInstance(MSEC_PATTERN, TimeZone.getTimeZone("UTC"));

    /**
     * UTC时间: yyyy-MM-dd HH:mm:ss Z
     */
    public static final String SPACEY_PATTERN = "yyyy-MM-dd HH:mm:ss Z";
    /**
     * UTC时间: {@link FormatBuilder} yyyy-MM-dd HH:mm:ss Z
     */
    public static final FormatBuilder SPACEY_FORMAT = FormatBuilder.getInstance(SPACEY_PATTERN, TimeZone.getTimeZone("UTC"));

    /**
     * UTC时间: yyyy-MM-dd HH:mm:ss.SSS Z
     */
    public static final String SPACEY_MSEC_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS Z";
    /**
     * UTC时间: {@link FormatBuilder} yyyy-MM-dd HH:mm:ss.SSS Z
     */
    public static final FormatBuilder SPACEY_MSEC_FORMAT = FormatBuilder.getInstance(SPACEY_MSEC_PATTERN, TimeZone.getTimeZone("UTC"));

    /**
     * UTC时间: yyyy-MM-dd'T'HH:mm:ss.SSS'Z'
     */
    public static final String OUTPUT_MSEC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    /**
     * UTC时间: {@link FormatBuilder} yyyy-MM-dd'T'HH:mm:ss.SSS'Z'
     */
    public static final FormatBuilder OUTPUT_MSEC_FORMAT = FormatBuilder.getInstance(OUTPUT_MSEC_PATTERN, TimeZone.getTimeZone("UTC"));

    /**
     * UTC时间：yyyy-MM-dd'T'HH:mm:ssZ
     */
    public final static String WITH_ZONE_OFFSET_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";
    /**
     * UTC时间{@link FormatBuilder}：yyyy-MM-dd'T'HH:mm:ssZ
     */
    public final static FormatBuilder WITH_ZONE_OFFSET_FORMAT = FormatBuilder.getInstance(WITH_ZONE_OFFSET_PATTERN, TimeZone.getTimeZone("UTC"));

    public final static String[] WTB = {
            "sun", "mon", "tue", "wed", "thu", "fri", "sat",
            "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec",
            "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"
    };

    /**
     * 星座
     */
    public static final String[] ZODIAC = {
            "摩羯座", "水瓶座", "双鱼座", "白羊座", "金牛座", "双子座", "巨蟹座", "狮子座", "处女座", "天秤座",
            "天蝎座", "射手座", "摩羯座"
    };
    /**
     * 星座分隔时间日
     */
    public static final int[] ZODIAC_SLICED = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};

    /**
     * 12生肖,属相
     */
    public static final String[] CN_ANIMAIL = {
            "鼠", "牛", "虎", "兔", "龙", "蛇", "马", "羊", "猴", "鸡", "狗", "猪"
    };

    /**
     * 十天干信息
     */
    public static final String[] CN_GAN = {
            "甲", "乙", "丙", "丁", "戊", "己", "庚", "辛", "壬", "癸"
    };

    /**
     * 十二地支信息
     */
    public static final String[] CN_ZHI = {
            "子", "丑", "寅", "卯", "辰", "巳", "午", "未", "申", "酉", "戌", "亥"
    };

    /**
     * 农历年份名
     */
    public static final String[] CN_YEAR = {
            "〇", "一", "二", "三", "四", "五", "六", "七", "八", "九"
    };
    /**
     * 农历月份名
     */
    public static final String[] CN_MONTH = {
            "正", "二", "三", "四", "五", "六", "七", "八", "九", "十", "冬", "腊"
    };
    /**
     * 农历日期名
     */
    public static final String[] CN_DAY = {
            "初一", "初二", "初三", "初四", "初五", "初六", "初七", "初八", "初九", "初十", "十一", "十二",
            "十三", "十四", "十五", "十六", "十七", "十八", "十九", "廿十", "廿一", "廿二", "廿三", "廿四",
            "廿五", "廿六", "廿七", "廿八", "廿九", "卅十"
    };

    /**
     * 24节气信息
     **/
    public static final String[] CN_SOLARTERM = {
            "小寒", "大寒", "立春", "雨水", "惊蛰", "春分", "清明", "谷雨", "立夏", "小满", "芒种", "夏至",
            "小暑", "大暑", "立秋", "处暑", "白露", "秋分", "寒露", "霜降", "立冬", "小雪", "大雪", "冬至"
    };

    /**
     * 农历信息.
     * 每个数组的第一个数表示该年闰月月份，为0表示不闰月
     * 数组中其他数表示该月初一对应的公历日期
     */
    public final static short[][] CN_LUNAR = {
            {0, 212, 314, 412, 512, 610, 709, 808, 906, 1005, 1104, 1204, 1302}, // 1850
            {8, 201, 303, 403, 501, 531, 629, 728, 827, 925, 1024, 1123, 1222, 1321}, // 1851
            {0, 220, 321, 331, 419, 519, 618, 717, 815, 914, 1013, 1112, 1211, 1309}, // 1852
            {0, 208, 310, 408, 508, 607, 706, 805, 903, 1003, 1101, 1201, 1230}, // 1853
            {7, 129, 227, 329, 427, 527, 625, 725, 824, 922, 1022, 1120, 1220, 1318}, // 1854
            {0, 217, 318, 416, 516, 614, 714, 813, 911, 1011, 1110, 1209, 1308}, // 1855
            {0, 206, 307, 405, 504, 603, 702, 801, 830, 929, 1029, 1128, 1227}, // 1856
            {5, 126, 224, 326, 424, 523, 622, 721, 820, 918, 1018, 1116, 1216, 1315}, // 1857
            {0, 214, 315, 414, 513, 611, 711, 809, 907, 1007, 1106, 1205, 1304}, // 1858
            {0, 203, 305, 403, 503, 601, 630, 730, 828, 926, 1026, 1124, 1224}, // 1859
            {3, 123, 222, 322, 421, 521, 619, 718, 817, 915, 1014, 1113, 1212, 1311}, // 1860
            {0, 210, 311, 410, 510, 608, 708, 806, 905, 1004, 1103, 1202, 1231}, // 1861
            {8, 130, 301, 330, 429, 528, 627, 727, 825, 924, 1023, 1122, 1221, 1319}, // 1862
            {0, 218, 319, 418, 518, 616, 716, 814, 913, 1013, 1111, 1211, 1309}, // 1863
            {0, 208, 308, 406, 506, 604, 704, 802, 901, 1001, 1030, 1129, 1229, 1327}, // 1864
            {6, 127, 226, 327, 425, 525, 623, 723, 821, 920, 1020, 1118, 1218, 1317}, // 1865
            {0, 215, 317, 415, 514, 613, 712, 810, 909, 1009, 1107, 1207, 1306}, // 1866
            {0, 205, 306, 405, 504, 602, 702, 731, 829, 928, 1027, 1126, 1226}, // 1867
            {4, 125, 223, 324, 423, 522, 620, 720, 818, 916, 1016, 1114, 1214, 1313}, // 1868
            {0, 211, 313, 412, 512, 610, 709, 808, 906, 1005, 1104, 1203, 1302}, // 1869
            {10, 131, 302, 401, 501, 530, 629, 728, 827, 925, 1024, 1123, 1222, 1321}, // 1870
            {0, 219, 321, 420, 519, 618, 718, 816, 915, 1014, 1113, 1212, 1310}, // 1871
            {0, 209, 309, 408, 507, 606, 706, 804, 903, 1002, 1101, 1201, 1230}, // 1872
            {6, 129, 227, 328, 427, 526, 625, 724, 823, 922, 1021, 1120, 1220, 1318}, // 1873
            {0, 217, 318, 416, 516, 614, 714, 812, 911, 1010, 1109, 1209, 1308}, // 1874
            {0, 206, 308, 406, 505, 604, 703, 801, 831, 929, 1029, 1128, 1228}, // 1875
            {5, 126, 225, 326, 424, 523, 622, 721, 819, 918, 1017, 1116, 1216, 1314}, // 1876
            {0, 213, 315, 414, 513, 611, 711, 809, 907, 1007, 1105, 1205, 1303}, // 1877
            {0, 202, 304, 403, 502, 601, 630, 730, 828, 926, 1026, 1124, 1224}, // 1878
            {3, 122, 221, 323, 421, 521, 620, 719, 818, 916, 1015, 1114, 1213, 1312}, // 1879
            {0, 210, 311, 409, 509, 608, 707, 806, 905, 1004, 1103, 1202, 1231}, // 1880
            {7, 130, 228, 330, 428, 528, 626, 726, 825, 923, 1023, 1122, 1221, 1320}, // 1881
            {0, 218, 319, 418, 517, 616, 715, 814, 912, 1012, 1111, 1210, 1309}, // 1882
            {0, 208, 309, 407, 507, 605, 704, 803, 901, 1001, 1031, 1130, 1229}, // 1883
            {5, 128, 227, 327, 425, 525, 623, 722, 821, 919, 1019, 1118, 1217, 1316}, // 1884
            {0, 215, 317, 415, 514, 613, 712, 810, 909, 1008, 1107, 1206, 1305}, // 1885
            {0, 204, 306, 404, 504, 602, 702, 731, 829, 928, 1027, 1126, 1225}, // 1886
            {4, 124, 223, 325, 423, 523, 621, 721, 819, 917, 1017, 1115, 1215, 1313}, // 1887
            {0, 212, 313, 411, 511, 610, 709, 808, 906, 1005, 1104, 1203, 1302}, // 1888
            {12, 131, 303, 331, 430, 530, 628, 728, 826, 925, 1024, 1123, 1222, 1321}, // 1889
            {0, 219, 321, 419, 519, 617, 717, 816, 914, 1014, 1112, 1212, 1310}, // 1890
            {0, 209, 310, 409, 508, 607, 706, 805, 903, 1003, 1102, 1201, 1231}, // 1891
            {6, 130, 228, 328, 427, 526, 624, 724, 822, 921, 1021, 1119, 1219, 1318}, // 1892
            {0, 217, 318, 416, 516, 614, 713, 812, 910, 1010, 1108, 1208, 1307}, // 1893
            {0, 206, 307, 406, 505, 604, 703, 801, 831, 929, 1029, 1127, 1227}, // 1894
            {5, 126, 225, 326, 425, 524, 623, 722, 820, 919, 1018, 1117, 1216, 1315}, // 1895
            {0, 214, 314, 413, 513, 611, 711, 809, 907, 1007, 1105, 1205, 1303}, // 1896
            {0, 202, 303, 402, 502, 531, 630, 730, 828, 926, 1026, 1124, 1224}, // 1897
            {3, 122, 221, 322, 421, 520, 619, 719, 817, 916, 1015, 1114, 1213, 1312}, // 1898
            {0, 210, 312, 410, 510, 608, 708, 806, 905, 1005, 1103, 1203, 1301}, // 1899
            {8, 131, 301, 331, 429, 528, 627, 726, 825, 924, 1023, 1122, 1222, 1320}, // 1900
            {0, 219, 320, 419, 518, 616, 716, 814, 913, 1012, 1111, 1211, 1310}, // 1901
            {0, 208, 310, 408, 508, 606, 705, 804, 902, 1002, 1031, 1130, 1230}, // 1902
            {5, 129, 227, 329, 427, 527, 625, 724, 823, 921, 1020, 1119, 1219, 1317}, // 1903
            {0, 216, 317, 416, 515, 614, 713, 811, 910, 1009, 1107, 1207, 1306}, // 1904
            {0, 204, 306, 405, 504, 603, 703, 801, 830, 929, 1028, 1127, 1226}, // 1905
            {4, 125, 223, 325, 424, 523, 622, 721, 820, 918, 1018, 1116, 1216, 1314}, // 1906
            {0, 213, 314, 413, 512, 611, 710, 809, 908, 1007, 1106, 1205, 1304}, // 1907
            {0, 202, 303, 401, 430, 530, 629, 728, 827, 925, 1025, 1124, 1223}, // 1908
            {2, 122, 220, 322, 420, 519, 618, 717, 816, 914, 1014, 1113, 1213, 1311}, // 1909
            {0, 210, 311, 410, 509, 607, 707, 805, 904, 1003, 1102, 1202, 1301}, // 1910
            {6, 130, 301, 330, 429, 528, 626, 726, 824, 922, 1022, 1121, 1220, 1319}, // 1911
            {0, 218, 319, 417, 517, 615, 714, 813, 911, 1010, 1109, 1209, 1307}, // 1912
            {0, 206, 308, 407, 506, 605, 704, 802, 901, 930, 1029, 1128, 1227}, // 1913
            {5, 126, 225, 327, 425, 525, 623, 723, 821, 920, 1019, 1117, 1217, 1315}, // 1914
            {0, 214, 316, 414, 514, 613, 712, 811, 909, 1009, 1107, 1207, 1305}, // 1915
            {0, 203, 304, 403, 502, 601, 630, 730, 829, 927, 1027, 1125, 1225}, // 1916
            {2, 123, 222, 323, 421, 521, 619, 719, 818, 916, 1016, 1115, 1214, 1313}, // 1917
            {0, 211, 313, 411, 510, 609, 708, 807, 905, 1005, 1104, 1203, 1302}, // 1918
            {7, 201, 302, 401, 430, 529, 628, 727, 825, 924, 1024, 1122, 1222, 1321}, // 1919
            {0, 220, 320, 419, 518, 616, 716, 814, 912, 1012, 1110, 1210, 1309}, // 1920
            {0, 208, 310, 408, 508, 606, 705, 804, 902, 1001, 1031, 1129, 1229}, // 1921
            {5, 128, 227, 328, 427, 527, 625, 724, 823, 921, 1020, 1119, 1218, 1317}, // 1922
            {0, 216, 317, 416, 516, 614, 714, 812, 911, 1010, 1108, 1208, 1306}, // 1923
            {0, 205, 305, 404, 504, 602, 702, 801, 830, 929, 1028, 1127, 1226}, // 1924
            {4, 124, 223, 324, 423, 522, 621, 721, 819, 918, 1018, 1116, 1216, 1314}, // 1925
            {0, 213, 314, 412, 512, 610, 710, 808, 907, 1007, 1105, 1205, 1304}, // 1926
            {0, 202, 304, 402, 501, 531, 629, 729, 827, 926, 1025, 1124, 1224}, // 1927
            {2, 123, 221, 322, 420, 519, 618, 717, 815, 914, 1013, 1112, 1212, 1311}, // 1928
            {0, 210, 311, 410, 509, 607, 707, 805, 903, 1003, 1101, 1201, 1231}, // 1929
            {6, 130, 228, 330, 429, 528, 626, 726, 824, 922, 1022, 1120, 1220, 1319}, // 1930
            {0, 217, 319, 418, 517, 616, 715, 814, 912, 1011, 1110, 1209, 1308}, // 1931
            {0, 206, 307, 406, 506, 604, 704, 802, 901, 930, 1029, 1128, 1227}, // 1932
            {5, 126, 224, 326, 425, 524, 623, 722, 821, 920, 1019, 1118, 1217, 1315}, // 1933
            {0, 214, 315, 414, 513, 612, 712, 810, 909, 1008, 1107, 1207, 1305}, // 1934
            {0, 204, 305, 403, 503, 601, 701, 730, 829, 928, 1027, 1126, 1226}, // 1935
            {3, 124, 223, 323, 421, 521, 619, 718, 817, 916, 1015, 1114, 1214, 1313}, // 1936
            {0, 211, 313, 411, 510, 609, 708, 806, 905, 1004, 1103, 1203, 1302}, // 1937
            {7, 131, 302, 401, 430, 529, 628, 727, 825, 924, 1023, 1122, 1222, 1320}, // 1938
            {0, 219, 321, 420, 519, 617, 717, 815, 913, 1013, 1111, 1211, 1309}, // 1939
            {0, 208, 309, 408, 507, 606, 705, 804, 902, 1001, 1031, 1129, 1229}, // 1940
            {6, 127, 226, 328, 426, 526, 625, 724, 823, 921, 1020, 1119, 1218, 1317}, // 1941
            {0, 215, 317, 415, 515, 614, 713, 812, 910, 1010, 1108, 1208, 1306}, // 1942
            {0, 205, 306, 405, 504, 603, 702, 801, 831, 929, 1029, 1127, 1227}, // 1943
            {4, 125, 224, 324, 423, 522, 621, 720, 819, 917, 1017, 1116, 1215, 1314}, // 1944
            {0, 213, 314, 412, 512, 610, 709, 808, 906, 1006, 1105, 1205, 1303}, // 1945
            {0, 202, 304, 402, 501, 531, 629, 728, 827, 925, 1025, 1124, 1223}, // 1946
            {2, 122, 221, 323, 421, 520, 619, 718, 816, 915, 1014, 1113, 1212, 1311}, // 1947
            {0, 210, 311, 409, 509, 607, 707, 805, 903, 1003, 1101, 1201, 1230}, // 1948
            {7, 129, 228, 329, 428, 528, 626, 726, 824, 922, 1022, 1120, 1220, 1318}, // 1949
            {0, 217, 318, 417, 517, 615, 715, 814, 912, 1011, 1110, 1209, 1308}, // 1950
            {0, 206, 308, 406, 506, 605, 704, 803, 901, 1001, 1030, 1129, 1228}, // 1951
            {5, 127, 225, 326, 424, 524, 622, 722, 820, 919, 1019, 1117, 1217, 1315}, // 1952
            {0, 214, 315, 414, 513, 611, 711, 810, 908, 1008, 1107, 1206, 1305}, // 1953
            {0, 203, 305, 403, 503, 601, 630, 730, 828, 927, 1027, 1125, 1225}, // 1954
            {3, 124, 222, 324, 422, 522, 620, 719, 818, 916, 1016, 1114, 1214, 1313}, // 1955
            {0, 212, 312, 411, 510, 609, 708, 806, 905, 1004, 1103, 1203, 1301}, // 1956
            {8, 131, 302, 331, 430, 529, 628, 727, 825, 924, 1023, 1122, 1221, 1320}, // 1957
            {0, 218, 320, 419, 519, 617, 717, 815, 913, 1013, 1111, 1211, 1309}, // 1958
            {0, 208, 309, 408, 508, 606, 706, 804, 903, 1002, 1101, 1130, 1230}, // 1959
            {6, 128, 227, 327, 426, 525, 624, 724, 822, 921, 1020, 1119, 1218, 1317}, // 1960
            {0, 215, 317, 415, 515, 613, 713, 811, 910, 1010, 1108, 1208, 1306}, // 1961
            {0, 205, 306, 405, 504, 602, 702, 731, 830, 929, 1028, 1127, 1227}, // 1962
            {4, 125, 224, 325, 424, 523, 621, 721, 819, 918, 1017, 1116, 1216, 1315}, // 1963
            {0, 213, 314, 412, 512, 610, 709, 808, 906, 1006, 1104, 1204, 1303}, // 1964
            {0, 202, 303, 402, 501, 531, 629, 728, 827, 925, 1024, 1123, 1223}, // 1965
            {3, 121, 220, 322, 421, 520, 619, 718, 816, 915, 1014, 1112, 1212, 1311}, // 1966
            {0, 209, 311, 410, 509, 608, 708, 806, 904, 1004, 1102, 1202, 1231}, // 1967
            {7, 130, 228, 329, 427, 527, 626, 725, 824, 922, 1022, 1120, 1220, 1318}, // 1968
            {0, 217, 318, 417, 516, 615, 714, 813, 912, 1011, 1110, 1209, 1308}, // 1969
            {0, 206, 308, 406, 505, 604, 703, 802, 901, 930, 1030, 1129, 1228}, // 1970
            {5, 127, 225, 327, 425, 524, 623, 722, 821, 919, 1019, 1118, 1218, 1316}, // 1971
            {0, 215, 315, 414, 513, 611, 711, 809, 908, 1007, 1106, 1206, 1304}, // 1972
            {0, 203, 305, 403, 503, 601, 630, 730, 828, 926, 1026, 1125, 1224}, // 1973
            {4, 123, 222, 324, 422, 522, 620, 719, 818, 916, 1015, 1114, 1214, 1312}, // 1974
            {0, 211, 313, 412, 511, 610, 709, 807, 906, 1005, 1103, 1203, 1301}, // 1975
            {8, 131, 301, 331, 429, 529, 627, 727, 825, 924, 1023, 1121, 1221, 1319}, // 1976
            {0, 218, 320, 418, 518, 617, 716, 815, 913, 1013, 1111, 1211, 1309}, // 1977
            {0, 207, 309, 407, 507, 606, 705, 804, 902, 1002, 1101, 1130, 1230}, // 1978
            {6, 128, 227, 328, 426, 526, 624, 724, 823, 921, 1021, 1120, 1219, 1318}, // 1979
            {0, 216, 317, 415, 514, 613, 712, 811, 909, 1009, 1108, 1207, 1306}, // 1980
            {0, 205, 306, 405, 504, 602, 702, 731, 829, 928, 1028, 1126, 1226}, // 1981
            {4, 125, 224, 325, 424, 523, 621, 721, 819, 917, 1017, 1115, 1215, 1314}, // 1982
            {0, 213, 315, 413, 513, 611, 710, 809, 907, 1006, 1105, 1204, 1303}, // 1983
            {10, 202, 303, 401, 501, 531, 629, 728, 827, 925, 1024, 1123, 1222, 1321}, // 1984
            {0, 220, 321, 420, 520, 618, 718, 816, 915, 1014, 1112, 1212, 1310}, // 1985
            {0, 209, 310, 409, 509, 607, 707, 806, 904, 1004, 1102, 1202, 1231}, // 1986
            {6, 129, 228, 329, 428, 527, 626, 726, 824, 923, 1023, 1121, 1221, 1319}, // 1987
            {0, 217, 318, 416, 516, 614, 714, 812, 911, 1011, 1109, 1209, 1308}, // 1988
            {0, 206, 308, 406, 505, 604, 703, 802, 831, 930, 1029, 1128, 1228}, // 1989
            {5, 127, 225, 327, 425, 524, 623, 722, 820, 919, 1018, 1117, 1217, 1316}, // 1990
            {0, 215, 316, 415, 514, 612, 712, 810, 908, 1008, 1106, 1206, 1305}, // 1991
            {0, 204, 304, 403, 503, 601, 630, 730, 828, 926, 1026, 1124, 1224}, // 1992
            {3, 123, 221, 323, 422, 521, 620, 719, 818, 916, 1015, 1114, 1213, 1312}, // 1993
            {0, 210, 312, 411, 511, 609, 709, 807, 906, 1005, 1103, 1203, 1301}, // 1994
            {8, 131, 301, 331, 430, 529, 628, 727, 826, 925, 1024, 1122, 1222, 1320}, // 1995
            {0, 219, 319, 418, 517, 616, 715, 814, 912, 1012, 1111, 1211, 1309}, // 1996
            {0, 207, 309, 407, 507, 605, 705, 803, 902, 1002, 1031, 1130, 1230}, // 1997
            {5, 128, 227, 328, 426, 526, 624, 723, 822, 921, 1020, 1119, 1219, 1317}, // 1998
            {0, 216, 318, 416, 515, 614, 713, 811, 910, 1009, 1108, 1208, 1307}, // 1999
            {0, 205, 306, 405, 504, 602, 702, 731, 829, 928, 1027, 1126, 1226}, // 2000
            {4, 124, 223, 325, 423, 523, 621, 721, 819, 917, 1017, 1115, 1215, 1313}, // 2001
            {0, 212, 314, 413, 512, 611, 710, 809, 907, 1006, 1105, 1204, 1303}, // 2002
            {0, 201, 303, 402, 501, 531, 630, 729, 828, 926, 1025, 1124, 1223}, // 2003
            {2, 122, 220, 321, 419, 519, 618, 717, 816, 914, 1014, 1112, 1212, 1310}, // 2004
            {0, 209, 310, 409, 508, 607, 706, 805, 904, 1003, 1102, 1201, 1231}, // 2005
            {7, 129, 228, 329, 428, 527, 626, 725, 824, 922, 1022, 1121, 1220, 1319}, // 2006
            {0, 218, 319, 417, 517, 615, 714, 813, 911, 1011, 1110, 1210, 1308}, // 2007
            {0, 207, 308, 406, 505, 604, 703, 801, 831, 929, 1029, 1128, 1227}, // 2008
            {5, 126, 225, 327, 425, 524, 623, 722, 820, 919, 1018, 1117, 1216, 1315}, // 2009
            {0, 214, 316, 414, 514, 612, 712, 810, 908, 1008, 1106, 1206, 1304}, // 2010
            {0, 203, 305, 403, 503, 602, 701, 731, 829, 927, 1027, 1125, 1225}, // 2011
            {4, 123, 222, 322, 421, 521, 619, 719, 817, 916, 1015, 1114, 1213, 1312}, // 2012
            {0, 210, 312, 410, 510, 608, 708, 807, 905, 1005, 1103, 1203, 1301}, // 2013
            {9, 131, 301, 331, 429, 529, 627, 727, 825, 924, 1024, 1122, 1222, 1320}, // 2014
            {0, 219, 320, 419, 518, 616, 716, 814, 913, 1013, 1112, 1211, 1310}, // 2015
            {0, 208, 309, 407, 507, 605, 704, 803, 901, 1001, 1031, 1129, 1229}, // 2016
            {6, 128, 226, 328, 426, 526, 624, 723, 822, 920, 1020, 1118, 1218, 1317}, // 2017
            {0, 216, 317, 416, 515, 614, 713, 811, 910, 1009, 1108, 1207, 1306}, // 2018
            {0, 205, 307, 405, 505, 603, 703, 801, 830, 929, 1028, 1126, 1226}, // 2019
            {4, 125, 223, 324, 423, 523, 621, 721, 819, 917, 1017, 1115, 1215, 1313}, // 2020
            {0, 212, 313, 412, 512, 610, 710, 808, 907, 1006, 1105, 1204, 1303}, // 2021
            {0, 201, 303, 401, 501, 530, 629, 729, 827, 926, 1025, 1124, 1223}, // 2022
            {2, 122, 220, 322, 420, 519, 618, 718, 816, 915, 1015, 1113, 1213, 1311}, // 2023
            {0, 210, 310, 409, 508, 606, 706, 804, 903, 1003, 1101, 1201, 1231}, // 2024
            {6, 129, 228, 329, 428, 527, 625, 725, 823, 922, 1021, 1120, 1220, 1319}, // 2025
            {0, 217, 319, 417, 517, 615, 714, 813, 911, 1010, 1109, 1209, 1308}, // 2026
            {0, 206, 308, 407, 506, 605, 704, 802, 901, 930, 1029, 1128, 1228}, // 2027
            {5, 126, 225, 326, 425, 524, 623, 722, 820, 919, 1018, 1116, 1216, 1315}, // 2028
            {0, 213, 315, 414, 513, 612, 711, 810, 908, 1008, 1106, 1205, 1304}, // 2029
            {0, 203, 304, 403, 502, 601, 701, 730, 829, 927, 1027, 1125, 1225}, // 2030
            {3, 123, 221, 323, 422, 521, 620, 719, 818, 917, 1016, 1115, 1214, 1313}, // 2031
            {0, 211, 312, 410, 509, 608, 707, 806, 905, 1004, 1103, 1203, 1301}, // 2032
            {7, 131, 301, 331, 429, 528, 627, 726, 825, 923, 1023, 1122, 1222, 1320}, // 2033
            {0, 219, 320, 419, 518, 616, 716, 814, 913, 1012, 1111, 1211, 1309}, // 2034
            {0, 208, 310, 408, 508, 606, 705, 804, 902, 1001, 1031, 1130, 1229}, // 2035
            {6, 128, 227, 328, 426, 526, 624, 723, 822, 920, 1019, 1118, 1217, 1316}, // 2036
            {0, 215, 317, 416, 515, 614, 713, 811, 910, 1009, 1107, 1207, 1305}, // 2037
            {0, 204, 306, 405, 504, 603, 702, 801, 830, 929, 1028, 1126, 1226}, // 2038
            {5, 124, 223, 325, 423, 523, 622, 721, 820, 918, 1018, 1116, 1216, 1314}, // 2039
            {0, 212, 313, 411, 511, 610, 709, 808, 906, 1006, 1105, 1204, 1303}, // 2040
            {0, 201, 302, 401, 430, 530, 628, 728, 827, 925, 1025, 1124, 1223}, // 2041
            {2, 122, 220, 322, 420, 519, 618, 717, 816, 914, 1014, 1113, 1212, 1311}, // 2042
            {0, 210, 311, 410, 509, 607, 707, 805, 903, 1003, 1102, 1201, 1231}, // 2043
            {7, 130, 229, 329, 428, 527, 625, 725, 823, 921, 1021, 1119, 1219, 1318}, // 2044
            {0, 217, 319, 417, 517, 615, 714, 813, 911, 1010, 1109, 1208, 1307}, // 2045
            {0, 206, 308, 406, 506, 604, 704, 802, 901, 930, 1029, 1128, 1227}, // 2046
            {5, 126, 225, 326, 425, 525, 623, 723, 821, 920, 1019, 1117, 1217, 1315}, // 2047
            {0, 214, 314, 413, 513, 611, 711, 810, 908, 1008, 1106, 1205, 1304}, // 2048
            {0, 202, 304, 402, 502, 531, 630, 730, 828, 927, 1027, 1125, 1225}, // 2049
            {3, 123, 221, 323, 421, 521, 619, 719, 817, 916, 1016, 1114, 1214, 1313}, // 2050
            {0, 211, 313, 411, 510, 609, 708, 806, 905, 1005, 1103, 1203, 1302}, // 2051
            {8, 201, 301, 331, 429, 528, 627, 726, 824, 923, 1022, 1121, 1221, 1320}, // 2052
            {0, 219, 320, 419, 518, 616, 716, 814, 912, 1012, 1110, 1210, 1309}, // 2053
            {0, 208, 309, 408, 508, 606, 705, 804, 902, 1001, 1031, 1129, 1229}, // 2054
            {6, 128, 226, 328, 427, 526, 625, 724, 823, 921, 1020, 1119, 1218, 1317}, // 2055
            {0, 215, 316, 415, 515, 613, 713, 811, 910, 1009, 1107, 1207, 1305}, // 2056
            {0, 204, 305, 404, 504, 602, 702, 731, 830, 929, 1028, 1126, 1226}, // 2057
            {4, 124, 223, 324, 423, 522, 621, 720, 819, 918, 1017, 1116, 1216, 1314}, // 2058
            {0, 212, 314, 412, 512, 610, 710, 808, 907, 1006, 1105, 1205, 1304}, // 2059
            {0, 202, 303, 401, 501, 530, 628, 727, 826, 924, 1024, 1123, 1223}, // 2060
            {3, 121, 220, 322, 420, 519, 618, 717, 815, 914, 1013, 1112, 1212, 1311}, // 2061
            {0, 209, 311, 410, 509, 607, 707, 805, 903, 1003, 1101, 1201, 1231}, // 2062
            {7, 129, 228, 330, 428, 528, 626, 726, 824, 922, 1022, 1120, 1220, 1318}, // 2063
            {0, 217, 318, 417, 516, 615, 714, 813, 911, 1010, 1109, 1208, 1307}, // 2064
            {0, 205, 307, 406, 505, 604, 704, 802, 901, 930, 1029, 1128, 1227}, // 2065
            {5, 126, 224, 326, 424, 524, 623, 722, 821, 919, 1019, 1117, 1217, 1315}, // 2066
            {0, 214, 315, 414, 513, 612, 711, 810, 909, 1008, 1107, 1206, 1305}, // 2067
            {0, 203, 304, 402, 502, 531, 629, 729, 828, 926, 1026, 1125, 1224}, // 2068
            {4, 123, 221, 323, 421, 521, 619, 718, 817, 915, 1015, 1114, 1214, 1312}, // 2069
            {0, 211, 312, 411, 510, 609, 708, 806, 905, 1004, 1103, 1203, 1301}, // 2070
            {8, 131, 302, 331, 430, 529, 628, 727, 825, 924, 1023, 1122, 1221, 1320}, // 2071
            {0, 219, 320, 418, 518, 616, 716, 814, 912, 1012, 1110, 1210, 1308}, // 2072
            {0, 207, 309, 407, 507, 606, 705, 804, 902, 1001, 1031, 1129, 1229}, // 2073
            {6, 127, 226, 327, 426, 526, 624, 724, 822, 921, 1020, 1119, 1218, 1317}, // 2074
            {0, 215, 317, 415, 515, 613, 713, 812, 910, 1010, 1108, 1208, 1306}, // 2075
            {0, 205, 305, 404, 503, 602, 701, 731, 829, 928, 1028, 1126, 1226}, // 2076
            {4, 124, 223, 324, 423, 522, 620, 720, 818, 917, 1017, 1116, 1215, 1314}, // 2077
            {0, 212, 314, 412, 512, 610, 709, 808, 906, 1006, 1105, 1204, 1303}, // 2078
            {0, 202, 303, 402, 501, 531, 629, 728, 827, 925, 1025, 1123, 1223}, // 2079
            {3, 122, 221, 321, 420, 519, 618, 717, 815, 914, 1013, 1111, 1211, 1310}, // 2080
            {0, 209, 310, 409, 509, 607, 707, 805, 903, 1003, 1101, 1130, 1230}, // 2081
            {7, 129, 227, 329, 428, 528, 626, 725, 824, 922, 1022, 1120, 1219, 1318}, // 2082
            {0, 217, 318, 417, 517, 615, 715, 813, 912, 1011, 1110, 1209, 1308}, // 2083
            {0, 206, 307, 405, 505, 603, 703, 802, 831, 930, 1029, 1128, 1227}, // 2084
            {5, 126, 224, 326, 424, 523, 622, 722, 820, 919, 1019, 1117, 1217, 1315}, // 2085
            {0, 214, 315, 414, 513, 611, 711, 809, 908, 1008, 1106, 1206, 1305}, // 2086
            {0, 203, 305, 403, 503, 601, 630, 730, 828, 927, 1026, 1125, 1225}, // 2087
            {4, 124, 222, 323, 421, 521, 619, 718, 817, 915, 1014, 1113, 1213, 1312}, // 2088
            {0, 210, 312, 411, 510, 609, 708, 806, 904, 1004, 1102, 1202, 1301}, // 2089
            {8, 130, 301, 331, 430, 529, 628, 727, 825, 924, 1023, 1121, 1221, 1320}, // 2090
            {0, 218, 320, 419, 518, 617, 716, 815, 913, 1013, 1111, 1210, 1309}, // 2091
            {0, 207, 308, 407, 506, 605, 705, 803, 902, 1001, 1031, 1129, 1229}, // 2092
            {6, 127, 225, 327, 426, 525, 624, 723, 822, 921, 1020, 1119, 1218, 1317}, // 2093
            {0, 215, 316, 415, 514, 613, 712, 811, 910, 1009, 1108, 1208, 1306}, // 2094
            {0, 205, 306, 405, 504, 602, 702, 731, 830, 928, 1028, 1127, 1227}, // 2095
            {4, 125, 224, 324, 423, 522, 620, 720, 818, 916, 1016, 1115, 1215, 1313}, // 2096
            {0, 212, 314, 412, 512, 610, 709, 808, 906, 1005, 1104, 1204, 1302}, // 2097
            {0, 201, 303, 402, 501, 531, 629, 728, 826, 925, 1024, 1123, 1222}, // 2098
            {2, 121, 220, 322, 420, 520, 619, 718, 816, 915, 1014, 1112, 1212, 1310}, // 2099
            {0, 209, 311, 410, 509, 608, 707, 806, 904, 1004, 1102, 1201, 1231}, //2100
            {7, 129, 228, 330, 428, 528, 626, 726, 825, 923, 1023, 1121, 1220, 1319}, //2101
            {0, 217, 319, 417, 517, 616, 715, 814, 912, 1012, 1111, 1210, 1309}, //2102
            {0, 207, 308, 407, 506, 605, 704, 803, 901, 1001, 1031, 1130, 1229}, //2103
            {5, 128, 226, 327, 425, 524, 623, 722, 821, 919, 1019, 1118, 1217, 1316}, //2104
            {0, 215, 316, 415, 514, 612, 712, 810, 908, 1008, 1107, 1206, 1305}, //2105
            {0, 204, 306, 404, 504, 602, 701, 731, 829, 927, 1027, 1125, 1225}, //2106
            {4, 124, 223, 325, 423, 523, 621, 720, 819, 917, 1016, 1115, 1214, 1313}, //2107
            {0, 212, 313, 411, 511, 609, 709, 807, 906, 1005, 1103, 1203, 1301}, //2108
            {9, 131, 302, 331, 430, 530, 628, 728, 826, 925, 1024, 1122, 1222, 1320}, //2109
            {0, 219, 320, 419, 519, 617, 717, 816, 914, 1014, 1112, 1211, 1310}, //2110
            {0, 208, 310, 408, 508, 606, 706, 805, 903, 1003, 1101, 1201, 1231}, //2111
            {6, 129, 227, 328, 426, 526, 624, 724, 822, 921, 1021, 1119, 1219, 1318}, //2112
            {0, 216, 318, 416, 515, 614, 713, 811, 910, 1010, 1108, 1208, 1307}, //2113
            {0, 206, 307, 406, 505, 603, 703, 801, 830, 929, 1028, 1127, 1227}, //2114
            {4, 126, 225, 326, 425, 524, 622, 722, 820, 918, 1018, 1116, 1216, 1315}, //2115
            {0, 214, 314, 413, 512, 611, 710, 809, 907, 1006, 1105, 1204, 1303}, //2116
            {0, 202, 303, 402, 502, 531, 630, 729, 828, 926, 1025, 1124, 1223}, //2117
            {3, 122, 220, 322, 421, 520, 619, 719, 817, 916, 1015, 1113, 1213, 1311}, //2118
            {0, 210, 311, 410, 509, 608, 708, 806, 905, 1004, 1103, 1202, 1301}, //2119
            {7, 130, 229, 329, 428, 527, 626, 725, 824, 923, 1022, 1121, 1220, 1319}, //2120
            {0, 217, 319, 417, 517, 615, 715, 813, 912, 1011, 1110, 1210, 1309}, //2121
            {0, 207, 308, 407, 506, 605, 704, 802, 901, 930, 1030, 1129, 1229}, //2122
            {5, 127, 226, 328, 426, 525, 624, 723, 821, 920, 1019, 1118, 1218, 1317}, //2123
            {0, 215, 316, 414, 514, 612, 712, 810, 908, 1008, 1106, 1206, 1305}, //2124
            {0, 203, 305, 404, 503, 602, 701, 731, 829, 927, 1027, 1125, 1225}, //2125
            {4, 123, 222, 324, 423, 522, 621, 720, 819, 917, 1016, 1115, 1214, 1313}, //2126
            {0, 211, 313, 412, 511, 610, 710, 808, 906, 1006, 1104, 1204, 1302}, //2127
            {11, 201, 301, 331, 429, 529, 628, 727, 826, 924, 1024, 1122, 1222, 1320}, //2128
            {0, 219, 320, 419, 518, 617, 716, 815, 914, 1013, 1112, 1211, 1310}, //2129
            {0, 208, 310, 408, 508, 606, 705, 804, 903, 1002, 1101, 1201, 1230}, //2130
            {6, 129, 227, 329, 427, 527, 625, 724, 823, 921, 1021, 1120, 1220, 1318}, //2131
            {0, 217, 317, 416, 515, 614, 713, 811, 910, 1009, 1108, 1208, 1306}, //2132
            {0, 205, 307, 405, 505, 603, 703, 801, 830, 928, 1028, 1127, 1226}, //2133
            {5, 125, 224, 326, 424, 524, 622, 722, 820, 918, 1018, 1116, 1216, 1314}, //2134
            {0, 213, 315, 413, 513, 612, 711, 809, 908, 1007, 1106, 1205, 1304}, //2135
            {0, 202, 303, 401, 501, 531, 629, 729, 827, 926, 1025, 1124, 1223}, //2136
            {2, 122, 220, 322, 420, 520, 618, 718, 817, 915, 1015, 1113, 1213, 1311}, //2137
            {0, 210, 311, 410, 509, 608, 707, 806, 904, 1004, 1103, 1202, 1301}, //2138
            {7, 130, 301, 330, 429, 528, 626, 726, 824, 923, 1023, 1122, 1221, 1320}, //2139
            {0, 218, 319, 417, 517, 615, 714, 813, 911, 1011, 1110, 1209, 1308}, //2140
            {0, 207, 308, 407, 506, 605, 704, 802, 901, 930, 1030, 1128, 1228}, //2141
            {5, 127, 226, 327, 426, 525, 624, 723, 821, 919, 1019, 1117, 1217, 1316}, //2142
            {0, 215, 316, 415, 515, 613, 713, 811, 909, 1008, 1107, 1206, 1305}, //2143
            {0, 204, 304, 403, 503, 602, 701, 730, 829, 927, 1027, 1125, 1224}, //2144
            {4, 123, 222, 323, 422, 522, 620, 720, 818, 917, 1016, 1115, 1214, 1313}, //2145
            {0, 211, 312, 411, 511, 609, 709, 807, 906, 1006, 1104, 1204, 1302}, //2146
            {0, 201, 302, 331, 430, 529, 628, 728, 826, 925, 1025, 1123, 1223}, //2147
            {1, 121, 220, 320, 419, 518, 616, 716, 814, 913, 1013, 1111, 1211, 1310}, //2148
            {0, 208, 310, 408, 508, 606, 705, 804, 902, 1002, 1031, 1130, 1230}, //2149
            {6, 129, 227, 329, 427, 527, 625, 724, 822, 921, 1020, 1119, 1219, 1318}, //2150
    };

    /**
     * 日期各个部分的枚举
     * 与Calendar相应值对应
     *
     * @author Kimi Liu
     * @version 5.8.2
     * @since JDK 1.8+
     */
    public enum DateField {

        /**
         * 世纪
         *
         * @see Calendar#ERA
         */
        ERA(Calendar.ERA),
        /**
         * 年
         *
         * @see Calendar#YEAR
         */
        YEAR(Calendar.YEAR),
        /**
         * 月
         *
         * @see Calendar#MONTH
         */
        MONTH(Calendar.MONTH),
        /**
         * 一年中第几周
         *
         * @see Calendar#WEEK_OF_YEAR
         */
        WEEK_OF_YEAR(Calendar.WEEK_OF_YEAR),
        /**
         * 一月中第几周
         *
         * @see Calendar#WEEK_OF_MONTH
         */
        WEEK_OF_MONTH(Calendar.WEEK_OF_MONTH),
        /**
         * 一月中的第几天
         *
         * @see Calendar#DAY_OF_MONTH
         */
        DAY_OF_MONTH(Calendar.DAY_OF_MONTH),
        /**
         * 一年中的第几天
         *
         * @see Calendar#DAY_OF_YEAR
         */
        DAY_OF_YEAR(Calendar.DAY_OF_YEAR),
        /**
         * 周几,1表示周日,2表示周一
         *
         * @see Calendar#DAY_OF_WEEK
         */
        DAY_OF_WEEK(Calendar.DAY_OF_WEEK),
        /**
         * 天所在的周是这个月的第几周
         *
         * @see Calendar#DAY_OF_WEEK_IN_MONTH
         */
        DAY_OF_WEEK_IN_MONTH(Calendar.DAY_OF_WEEK_IN_MONTH),
        /**
         * 上午或者下午
         *
         * @see Calendar#AM_PM
         */
        AM_PM(Calendar.AM_PM),
        /**
         * 小时,用于12小时制
         *
         * @see Calendar#HOUR
         */
        HOUR(Calendar.HOUR),
        /**
         * 小时,用于24小时制
         *
         * @see Calendar#HOUR
         */
        HOUR_OF_DAY(Calendar.HOUR_OF_DAY),
        /**
         * 分钟
         *
         * @see Calendar#MINUTE
         */
        MINUTE(Calendar.MINUTE),
        /**
         * 秒
         *
         * @see Calendar#SECOND
         */
        SECOND(Calendar.SECOND),
        /**
         * 毫秒
         *
         * @see Calendar#MILLISECOND
         */
        MILLISECOND(Calendar.MILLISECOND);

        private int value;

        DateField(int value) {
            this.value = value;
        }

        /**
         * 将 {@link Calendar}相关值转换为DatePart枚举对象
         *
         * @param calendarPartIntValue Calendar中关于Week的int值
         * @return {@link DateField}
         */
        public static DateField of(int calendarPartIntValue) {
            switch (calendarPartIntValue) {
                case Calendar.ERA:
                    return ERA;
                case Calendar.YEAR:
                    return YEAR;
                case Calendar.MONTH:
                    return MONTH;
                case Calendar.WEEK_OF_YEAR:
                    return WEEK_OF_YEAR;
                case Calendar.WEEK_OF_MONTH:
                    return WEEK_OF_MONTH;
                case Calendar.DAY_OF_MONTH:
                    return DAY_OF_MONTH;
                case Calendar.DAY_OF_YEAR:
                    return DAY_OF_YEAR;
                case Calendar.DAY_OF_WEEK:
                    return DAY_OF_WEEK;
                case Calendar.DAY_OF_WEEK_IN_MONTH:
                    return DAY_OF_WEEK_IN_MONTH;
                case Calendar.AM_PM:
                    return AM_PM;
                case Calendar.HOUR:
                    return HOUR;
                case Calendar.HOUR_OF_DAY:
                    return HOUR_OF_DAY;
                case Calendar.MINUTE:
                    return MINUTE;
                case Calendar.SECOND:
                    return SECOND;
                case Calendar.MILLISECOND:
                    return MILLISECOND;
                default:
                    return null;
            }
        }

        public int getValue() {
            return this.value;
        }

    }

    /**
     * 日期时间单位,每个单位都是以毫秒为基数
     *
     * @author Kimi Liu
     * @version 5.8.2
     * @since JDK 1.8+
     */
    public enum Unit {

        /**
         * 一毫秒
         */
        MS(1),
        /**
         * 一秒的毫秒数
         */
        SECOND(1000),
        /**
         * 一分钟的毫秒数
         */
        MINUTE(SECOND.getMillis() * 60),
        /**
         * 一小时的毫秒数
         */
        HOUR(MINUTE.getMillis() * 60),
        /**
         * 一天的毫秒数
         */
        DAY(HOUR.getMillis() * 24),
        /**
         * 一周的毫秒数
         */
        WEEK(DAY.getMillis() * 7);

        private long millis;

        Unit(long millis) {
            this.millis = millis;
        }

        /**
         * @return 单位对应的毫秒数
         */
        public long getMillis() {
            return this.millis;
        }
    }

    /**
     * 月份枚举
     * 与Calendar中的月份int值对应
     *
     * @author Kimi Liu
     * @version 5.8.2
     * @see Calendar#JANUARY
     * @see Calendar#FEBRUARY
     * @see Calendar#MARCH
     * @see Calendar#APRIL
     * @see Calendar#MAY
     * @see Calendar#JUNE
     * @see Calendar#JULY
     * @see Calendar#AUGUST
     * @see Calendar#SEPTEMBER
     * @see Calendar#OCTOBER
     * @see Calendar#NOVEMBER
     * @see Calendar#DECEMBER
     * @see Calendar#UNDECIMBER
     * @since JDK 1.8+
     */
    public enum Month {

        /**
         * 一月
         */
        JANUARY(Calendar.JANUARY),
        /**
         * 二月
         */
        FEBRUARY(Calendar.FEBRUARY),
        /**
         * 三月
         */
        MARCH(Calendar.MARCH),
        /**
         * 四月
         */
        APRIL(Calendar.APRIL),
        /**
         * 五月
         */
        MAY(Calendar.MAY),
        /**
         * 六月
         */
        JUNE(Calendar.JUNE),
        /**
         * 七月
         */
        JULY(Calendar.JULY),
        /**
         * 八月
         */
        AUGUST(Calendar.AUGUST),
        /**
         * 九月
         */
        SEPTEMBER(Calendar.SEPTEMBER),
        /**
         * 十月
         */
        OCTOBER(Calendar.OCTOBER),
        /**
         * 十一月
         */
        NOVEMBER(Calendar.NOVEMBER),
        /**
         * 十二月
         */
        DECEMBER(Calendar.DECEMBER),
        /**
         * 十三月,仅用于农历
         */
        UNDECIMBER(Calendar.UNDECIMBER);

        private int value;

        Month(int value) {
            this.value = value;
        }

        /**
         * 将 {@link Calendar}月份相关值转换为Month枚举对象
         *
         * @param calendarMonthIntValue Calendar中关于Month的int值
         * @return {@link Month}
         * @see Calendar#JANUARY
         * @see Calendar#FEBRUARY
         * @see Calendar#MARCH
         * @see Calendar#APRIL
         * @see Calendar#MAY
         * @see Calendar#JUNE
         * @see Calendar#JULY
         * @see Calendar#AUGUST
         * @see Calendar#SEPTEMBER
         * @see Calendar#OCTOBER
         * @see Calendar#NOVEMBER
         * @see Calendar#DECEMBER
         * @see Calendar#UNDECIMBER
         */
        public static Month of(int calendarMonthIntValue) {
            switch (calendarMonthIntValue) {
                case Calendar.JANUARY:
                    return JANUARY;
                case Calendar.FEBRUARY:
                    return FEBRUARY;
                case Calendar.MARCH:
                    return MARCH;
                case Calendar.APRIL:
                    return APRIL;
                case Calendar.MAY:
                    return MAY;
                case Calendar.JUNE:
                    return JUNE;
                case Calendar.JULY:
                    return JULY;
                case Calendar.AUGUST:
                    return AUGUST;
                case Calendar.SEPTEMBER:
                    return SEPTEMBER;
                case Calendar.OCTOBER:
                    return OCTOBER;
                case Calendar.NOVEMBER:
                    return NOVEMBER;
                case Calendar.DECEMBER:
                    return DECEMBER;
                case Calendar.UNDECIMBER:
                    return UNDECIMBER;
                default:
                    return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    /**
     * 季度枚举
     *
     * @author Kimi Liu
     * @version 5.8.2
     * @since JDK 1.8+
     */
    public enum Quarter {

        /**
         * 第一季度
         */
        Q1(1),
        /**
         * 第二季度
         */
        Q2(2),
        /**
         * 第三季度
         */
        Q3(3),
        /**
         * 第四季度
         */
        Q4(4);

        private int value;

        Quarter(int value) {
            this.value = value;
        }

        /**
         * 将 季度int转换为Season枚举对象
         *
         * @param intValue 季度int表示
         * @return {@link Quarter}
         * @see #Q1
         * @see #Q2
         * @see #Q3
         * @see #Q4
         */
        public static Quarter of(int intValue) {
            switch (intValue) {
                case 1:
                    return Q1;
                case 2:
                    return Q2;
                case 3:
                    return Q3;
                case 4:
                    return Q4;
                default:
                    return null;
            }
        }

        public int getValue() {
            return this.value;
        }
    }

    /**
     * 星期枚举
     * 与Calendar中的星期int值对应
     *
     * @author Kimi Liu
     * @version 5.8.2
     * @see #SUNDAY
     * @see #MONDAY
     * @see #TUESDAY
     * @see #WEDNESDAY
     * @see #THURSDAY
     * @see #FRIDAY
     * @see #SATURDAY
     * @since JDK 1.8+
     */
    public enum Week {

        /**
         * 周日
         */
        SUNDAY(Calendar.SUNDAY),
        /**
         * 周一
         */
        MONDAY(Calendar.MONDAY),
        /**
         * 周二
         */
        TUESDAY(Calendar.TUESDAY),
        /**
         * 周三
         */
        WEDNESDAY(Calendar.WEDNESDAY),
        /**
         * 周四
         */
        THURSDAY(Calendar.THURSDAY),
        /**
         * 周五
         */
        FRIDAY(Calendar.FRIDAY),
        /**
         * 周六
         */
        SATURDAY(Calendar.SATURDAY);

        /**
         * 星期对应{@link Calendar} 中的Week值
         */
        private int value;

        /**
         * 构造
         *
         * @param value 星期对应{@link Calendar} 中的Week值
         */
        Week(int value) {
            this.value = value;
        }

        /**
         * 将 {@link Calendar}星期相关值转换为Week枚举对象
         *
         * @param calendarWeekIntValue Calendar中关于Week的int值
         * @return {@link Week}
         * @see #SUNDAY
         * @see #MONDAY
         * @see #TUESDAY
         * @see #WEDNESDAY
         * @see #THURSDAY
         * @see #FRIDAY
         * @see #SATURDAY
         */
        public static Week of(int calendarWeekIntValue) {
            switch (calendarWeekIntValue) {
                case Calendar.SUNDAY:
                    return SUNDAY;
                case Calendar.MONDAY:
                    return MONDAY;
                case Calendar.TUESDAY:
                    return TUESDAY;
                case Calendar.WEDNESDAY:
                    return WEDNESDAY;
                case Calendar.THURSDAY:
                    return THURSDAY;
                case Calendar.FRIDAY:
                    return FRIDAY;
                case Calendar.SATURDAY:
                    return SATURDAY;
                default:
                    return null;
            }
        }

        /**
         * 获得星期对应{@link Calendar} 中的Week值
         *
         * @return 星期对应{@link Calendar} 中的Week值
         */
        public int getValue() {
            return this.value;
        }

        /**
         * 转换为中文名
         *
         * @return 星期的中文名
         * @since 3.3.0
         */
        public String toChinese() {
            return toChinese("星期");
        }

        /**
         * 转换为中文名
         *
         * @param weekNamePre 表示星期的前缀,例如前缀为“星期”,则返回结果为“星期一”；前缀为”周“,结果为“周一”
         * @return 星期的中文名
         */
        public String toChinese(String weekNamePre) {
            switch (this) {
                case SUNDAY:
                    return weekNamePre + "日";
                case MONDAY:
                    return weekNamePre + "一";
                case TUESDAY:
                    return weekNamePre + "二";
                case WEDNESDAY:
                    return weekNamePre + "三";
                case THURSDAY:
                    return weekNamePre + "四";
                case FRIDAY:
                    return weekNamePre + "五";
                case SATURDAY:
                    return weekNamePre + "六";
                default:
                    return null;
            }
        }

    }

    /**
     * 格式化等级枚举
     */
    public enum Level {

        /**
         * 天
         */
        DAY("天"),
        /**
         * 小时
         */
        HOUR("小时"),
        /**
         * 分钟
         */
        MINUTE("分"),
        /**
         * 秒
         */
        SECOND("秒"),
        /**
         * 毫秒
         */
        MILLSECOND("毫秒");

        /**
         * 级别名称
         */
        public String name;

        /**
         * 构造
         *
         * @param name 级别名称
         */
        Level(String name) {
            this.name = name;
        }

        /**
         * 获取级别名称
         *
         * @return 级别名称
         */
        public String getName() {
            return this.name;
        }
    }

    /**
     * 修改类型
     */
    public enum ModifyType {
        /**
         * 取指定日期短的起始值.
         */
        TRUNCATE,

        /**
         * 指定日期属性按照四舍五入处理
         */
        ROUND,

        /**
         * 指定日期属性按照进一法处理
         */
        CEILING
    }

}
