/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.Validator;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.RandomUtils;
import org.aoju.bus.core.utils.StringUtils;

public class NetUtils {
    public static final String LOCAL_IP = "127.0.0.1";
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;

    public static String longToIpv4(long longIP) {
        StringBuilder sb = new StringBuilder();
        sb.append(longIP >>> 24);
        sb.append(".");
        sb.append((longIP & 0xFFFFFFL) >>> 16);
        sb.append(".");
        sb.append((longIP & 0xFFFFL) >>> 8);
        sb.append(".");
        sb.append(longIP & 0xFFL);
        return sb.toString();
    }

    public static long ipv4ToLong(String strIP) {
        if (Validator.isIpv4(strIP)) {
            long[] ip = new long[4];
            int position1 = strIP.indexOf(".");
            int position2 = strIP.indexOf(".", position1 + 1);
            int position3 = strIP.indexOf(".", position2 + 1);
            ip[0] = Long.parseLong(strIP.substring(0, position1));
            ip[1] = Long.parseLong(strIP.substring(position1 + 1, position2));
            ip[2] = Long.parseLong(strIP.substring(position2 + 1, position3));
            ip[3] = Long.parseLong(strIP.substring(position3 + 1));
            return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
        }
        return 0L;
    }

    public static boolean isUsableLocalPort(int port) {
        Throwable throwable;
        if (!NetUtils.isValidPort(port)) {
            return false;
        }
        try {
            throwable = null;
            try (ServerSocket ss = new ServerSocket(port);){
                ss.setReuseAddress(true);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ignored) {
            return false;
        }
        try {
            throwable = null;
            try (DatagramSocket ds = new DatagramSocket(port);){
                ds.setReuseAddress(true);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException ignored) {
            return false;
        }
        return false;
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static int getUsableLocalPort() {
        return NetUtils.getUsableLocalPort(1024);
    }

    public static int getUsableLocalPort(int minPort) {
        return NetUtils.getUsableLocalPort(minPort, 65535);
    }

    public static int getUsableLocalPort(int minPort, int maxPort) {
        for (int i = minPort; i <= maxPort; ++i) {
            if (!NetUtils.isUsableLocalPort(RandomUtils.randomInt(minPort, maxPort + 1))) continue;
            return i;
        }
        throw new InstrumentException("Could not find an available port in the range [{" + minPort + "}, {" + maxPort + "}] after {" + (maxPort - minPort) + "} attempts");
    }

    public static TreeSet<Integer> getUsableLocalPorts(int numRequested, int minPort, int maxPort) {
        TreeSet<Integer> availablePorts = new TreeSet<Integer>();
        int attemptCount = 0;
        while (++attemptCount <= numRequested + 100 && availablePorts.size() < numRequested) {
            availablePorts.add(NetUtils.getUsableLocalPort(minPort, maxPort));
        }
        if (availablePorts.size() != numRequested) {
            throw new InstrumentException("Could not find {" + numRequested + "} available  ports in the range [{" + minPort + "}, {" + maxPort + "}]");
        }
        return availablePorts;
    }

    public static boolean isInnerIP(String ipAddress) {
        long ipNum = NetUtils.ipv4ToLong(ipAddress);
        long aBegin = NetUtils.ipv4ToLong("10.0.0.0");
        long aEnd = NetUtils.ipv4ToLong("10.255.255.255");
        long bBegin = NetUtils.ipv4ToLong("172.16.0.0");
        long bEnd = NetUtils.ipv4ToLong("172.31.255.255");
        long cBegin = NetUtils.ipv4ToLong("192.168.0.0");
        long cEnd = NetUtils.ipv4ToLong("192.168.255.255");
        boolean isInnerIp = NetUtils.isInner(ipNum, aBegin, aEnd) || NetUtils.isInner(ipNum, bBegin, bEnd) || NetUtils.isInner(ipNum, cBegin, cEnd) || ipAddress.equals(LOCAL_IP);
        return isInnerIp;
    }

    public static String toAbsoluteUrl(String absoluteBasePath, String relativePath) {
        try {
            URL absoluteUrl = new URL(absoluteBasePath);
            return new URL(absoluteUrl, relativePath).toString();
        }
        catch (Exception e) {
            throw new InstrumentException("To absolute url [{" + relativePath + "}] base [{" + absoluteBasePath + "}] error!");
        }
    }

    public static String hideIpPart(String ip) {
        return new StringBuffer(ip.length()).append(ip, 0, ip.lastIndexOf(".") + 1).append("*").toString();
    }

    public static String hideIpPart(long ip) {
        return NetUtils.hideIpPart(NetUtils.longToIpv4(ip));
    }

    public static InetSocketAddress buildInetSocketAddress(String host, int defaultPort) {
        int port;
        String destHost;
        int index;
        if (StringUtils.isBlank(host)) {
            host = LOCAL_IP;
        }
        if ((index = host.indexOf(":")) != -1) {
            destHost = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            destHost = host;
            port = defaultPort;
        }
        return new InetSocketAddress(destHost, port);
    }

    public static String getIpByHost(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException e) {
            return hostName;
        }
    }

    public static Collection<NetworkInterface> getNetworkInterfaces() {
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        return CollUtils.addAll(new ArrayList(), networkInterfaces);
    }

    public static LinkedHashSet<String> localIpv4s() {
        LinkedHashSet<InetAddress> localAddressList = NetUtils.localAddressList(t -> t instanceof Inet4Address);
        return NetUtils.toIpList(localAddressList);
    }

    public static LinkedHashSet<String> localIpv6s() {
        LinkedHashSet<InetAddress> localAddressList = NetUtils.localAddressList(t -> t instanceof Inet6Address);
        return NetUtils.toIpList(localAddressList);
    }

    public static LinkedHashSet<String> toIpList(Set<InetAddress> addressList) {
        LinkedHashSet<String> ipSet = new LinkedHashSet<String>();
        for (InetAddress address : addressList) {
            ipSet.add(address.getHostAddress());
        }
        return ipSet;
    }

    public static LinkedHashSet<String> localIps() {
        LinkedHashSet<InetAddress> localAddressList = NetUtils.localAddressList(null);
        return NetUtils.toIpList(localAddressList);
    }

    public static LinkedHashSet<InetAddress> localAddressList(Filter<InetAddress> addressFilter) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new InstrumentException(e);
        }
        if (networkInterfaces == null) {
            throw new InstrumentException("Get network interface error!");
        }
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || null != addressFilter && !addressFilter.accept(inetAddress)) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }

    public static String getLocalhostStr() {
        InetAddress localhost = NetUtils.getLocalhost();
        if (null != localhost) {
            return localhost.getHostAddress();
        }
        return null;
    }

    public static InetAddress getLocalhost() {
        LinkedHashSet<InetAddress> localAddressList = NetUtils.localAddressList(address -> false == address.isLoopbackAddress() && false == address.isSiteLocalAddress() && address instanceof Inet4Address);
        if (CollUtils.isNotEmpty(localAddressList)) {
            return CollUtils.get(localAddressList, 0);
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static String getLocalMacAddress() {
        return NetUtils.getMacAddress(NetUtils.getLocalhost());
    }

    public static String getMacAddress(InetAddress inetAddress) {
        return NetUtils.getMacAddress(inetAddress, "-");
    }

    public static String getMacAddress(InetAddress inetAddress, String separator) {
        byte[] mac;
        if (null == inetAddress) {
            return null;
        }
        try {
            mac = NetworkInterface.getByInetAddress(inetAddress).getHardwareAddress();
        }
        catch (SocketException e) {
            throw new InstrumentException(e);
        }
        if (null != mac) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                String s;
                if (i != 0) {
                    sb.append(separator);
                }
                sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
            }
            return sb.toString();
        }
        return null;
    }

    public static InetSocketAddress createAddress(String host, int port) {
        if (StringUtils.isBlank(host)) {
            return new InetSocketAddress(port);
        }
        return new InetSocketAddress(host, port);
    }

    public static void netCat(String host, int port, boolean isBlock, ByteBuffer data) throws InstrumentException {
        try (SocketChannel channel = SocketChannel.open(NetUtils.createAddress(host, port));){
            channel.configureBlocking(isBlock);
            channel.write(data);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void netCat(String host, int port, byte[] data) throws InstrumentException {
        OutputStream out = null;
        try (Socket socket = new Socket(host, port);){
            out = socket.getOutputStream();
            out.write(data);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoUtils.close(out);
                throw throwable;
            }
        }
        IoUtils.close(out);
    }

    public static boolean isInRange(String ip, String cidr) {
        String cidrIp;
        String[] cidrIps;
        int cidrIpAddr;
        int type;
        int mask;
        String[] ips = StringUtils.splitToArray(ip, 46);
        int ipAddr = Integer.parseInt(ips[0]) << 24 | Integer.parseInt(ips[1]) << 16 | Integer.parseInt(ips[2]) << 8 | Integer.parseInt(ips[3]);
        return (ipAddr & (mask = -1 << 32 - (type = Integer.parseInt(cidr.replaceAll(".*/", ""))))) == ((cidrIpAddr = Integer.parseInt((cidrIps = (cidrIp = cidr.replaceAll("/.*", "")).split("\\."))[0]) << 24 | Integer.parseInt(cidrIps[1]) << 16 | Integer.parseInt(cidrIps[2]) << 8 | Integer.parseInt(cidrIps[3])) & mask);
    }

    public static String idnToASCII(String unicode) {
        return IDN.toASCII(unicode);
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (NetUtils.isUnknow(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknow(String checkString) {
        return StringUtils.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static boolean containIp(String ip, String ipRuleConfig) {
        return NetUtils.checkContainIp(ip, NetUtils.getAllowIpList(ipRuleConfig));
    }

    private static Set<String> getAllowIpList(String allowIp) {
        HashSet<String> ipList = new HashSet<String>();
        for (String allow : allowIp.replaceAll("\\s", "").split(";")) {
            if (allow.contains("*")) {
                String[] ips = allow.split("\\.");
                String[] from = new String[]{"0", "0", "0", "0"};
                String[] end = new String[]{"255", "255", "255", "255"};
                List<Object> tem = new ArrayList();
                for (int i = 0; i < ips.length; ++i) {
                    if (ips[i].contains("*")) {
                        tem = NetUtils.complete(ips[i]);
                        from[i] = null;
                        end[i] = null;
                        continue;
                    }
                    from[i] = ips[i];
                    end[i] = ips[i];
                }
                StringBuilder fromIP = new StringBuilder();
                StringBuilder endIP = new StringBuilder();
                for (int i = 0; i < 4; ++i) {
                    if (from[i] != null) {
                        fromIP.append(from[i]).append(".");
                        endIP.append(end[i]).append(".");
                        continue;
                    }
                    fromIP.append("[*].");
                    endIP.append("[*].");
                }
                fromIP.deleteCharAt(fromIP.length() - 1);
                endIP.deleteCharAt(endIP.length() - 1);
                for (String string : tem) {
                    String ip = fromIP.toString().replace("[*]", string.split(";")[0]) + "-" + endIP.toString().replace("[*]", string.split(";")[1]);
                    if (!NetUtils.validate(ip)) continue;
                    ipList.add(ip);
                }
                continue;
            }
            if (!NetUtils.validate(allow)) continue;
            ipList.add(allow);
        }
        return ipList;
    }

    private static boolean checkContainIp(String ip, Set<String> ipList) {
        if (ipList.isEmpty() || ipList.contains(ip)) {
            return true;
        }
        for (String allow : ipList) {
            if (!allow.contains("-")) continue;
            String[] from = allow.split("-")[0].split("\\.");
            String[] end = allow.split("-")[1].split("\\.");
            String[] tag = ip.split("\\.");
            boolean check = true;
            for (int i = 0; i < 4; ++i) {
                int s = Integer.valueOf(from[i]);
                int t = Integer.valueOf(tag[i]);
                int e = Integer.valueOf(end[i]);
                if (s <= t && t <= e) continue;
                check = false;
                break;
            }
            if (!check) continue;
            return true;
        }
        return false;
    }

    private static List<String> complete(String arg) {
        ArrayList<String> com = new ArrayList<String>();
        if (arg.length() == 1) {
            com.add("0;255");
        } else if (arg.length() == 2) {
            String s2;
            String s1 = NetUtils.complete(arg, 1);
            if (s1 != null) {
                com.add(s1);
            }
            if ((s2 = NetUtils.complete(arg, 2)) != null) {
                com.add(s2);
            }
        } else {
            String s1 = NetUtils.complete(arg, 1);
            if (s1 != null) {
                com.add(s1);
            }
        }
        return com;
    }

    private static String complete(String arg, int length) {
        String end;
        String from;
        if (length == 1) {
            from = arg.replace("*", "0");
            end = arg.replace("*", "9");
        } else {
            from = arg.replace("*", "00");
            end = arg.replace("*", "99");
        }
        if (Integer.valueOf(from) > 255) {
            return null;
        }
        if (Integer.valueOf(end) > 255) {
            end = "255";
        }
        return from + ";" + end;
    }

    private static boolean validate(String ip) {
        for (String s : ip.split("-")) {
            if (RegEx.IPV4.matcher(s).matches()) continue;
            return false;
        }
        return true;
    }

    private static boolean isInner(long userIp, long begin, long end) {
        return userIp >= begin && userIp <= end;
    }

    public static boolean ping(String ip) {
        return NetUtils.ping(ip, 200);
    }

    public static boolean ping(String ip, int timeout) {
        try {
            return InetAddress.getByName(ip).isReachable(timeout);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

