/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.aoju.bus.core.annotation.Binding;

@Binding
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
public @interface Named {
    public String value() default "";

    public static class Names
    implements Named,
    Serializable {
        private final String value;

        public Names(String value) {
            this.value = Names.checkNotNull(value, "name");
        }

        public static <T> T checkNotNull(T reference, Object errorMessage) {
            if (reference == null) {
                throw new NullPointerException(String.valueOf(errorMessage));
            }
            return reference;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Named)) {
                return false;
            }
            Named other = (Named)o;
            return this.value.equals(other.value());
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Named.class;
        }
    }
}

