/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compare;

import java.io.Serializable;
import java.util.Comparator;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.ObjectUtils;

public class PropertyCompare<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String property;
    private final boolean isNullGreater;

    public PropertyCompare(String property) {
        this(property, true);
    }

    public PropertyCompare(String property, boolean isNullGreater) {
        this.property = property;
        this.isNullGreater = isNullGreater;
    }

    @Override
    public int compare(T o1, T o2) {
        Comparable v2;
        Comparable v1;
        if (o1 == o2) {
            return 0;
        }
        if (null == o1) {
            return this.isNullGreater ? 1 : -1;
        }
        if (null == o2) {
            return this.isNullGreater ? -1 : 1;
        }
        try {
            v1 = (Comparable)BeanUtils.getProperty(o1, this.property);
            v2 = (Comparable)BeanUtils.getProperty(o2, this.property);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        return this.compare(o1, o2, v1, v2);
    }

    private int compare(T o1, T o2, Comparable fieldValue1, Comparable fieldValue2) {
        int result = ObjectUtils.compare(fieldValue1, fieldValue2, this.isNullGreater);
        if (0 == result) {
            result = ObjectUtils.compare(o1, o2, this.isNullGreater);
        }
        return result;
    }
}

