/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.utils.BooleanUtils;
import org.aoju.bus.core.utils.NumberUtils;
import org.aoju.bus.core.utils.StringUtils;

public class NumberConverter
extends AbstractConverter<Number> {
    private final Class<? extends Number> targetType;

    public NumberConverter() {
        this.targetType = Number.class;
    }

    public NumberConverter(Class<? extends Number> clazz) {
        this.targetType = null == clazz ? Number.class : clazz;
    }

    @Override
    protected Number convertInternal(Object value) {
        Class<? extends Number> targetType = this.targetType;
        if (Byte.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            if (value instanceof Boolean) {
                return BooleanUtils.toByteObj((Boolean)value);
            }
            String valueStr = this.convertToStr(value);
            return StringUtils.isBlank(valueStr) ? null : Byte.valueOf(valueStr);
        }
        if (Short.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof Boolean) {
                return BooleanUtils.toShortObj((Boolean)value);
            }
            String valueStr = this.convertToStr(value);
            return StringUtils.isBlank(valueStr) ? null : Short.valueOf(valueStr);
        }
        if (Integer.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof Boolean) {
                return BooleanUtils.toInteger((Boolean)value);
            }
            String valueStr = this.convertToStr(value);
            return StringUtils.isBlank(valueStr) ? null : Integer.valueOf(NumberUtils.parseInt(valueStr));
        }
        if (AtomicInteger.class == targetType) {
            AtomicInteger intValue = new AtomicInteger();
            if (value instanceof Number) {
                intValue.set(((Number)value).intValue());
            } else if (value instanceof Boolean) {
                intValue.set(BooleanUtils.toInt((Boolean)value));
            }
            String valueStr = this.convertToStr(value);
            if (StringUtils.isBlank(valueStr)) {
                return null;
            }
            intValue.set(NumberUtils.parseInt(valueStr));
            return intValue;
        }
        if (Long.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof Boolean) {
                return BooleanUtils.toLongObj((Boolean)value);
            }
            String valueStr = this.convertToStr(value);
            return StringUtils.isBlank(valueStr) ? null : Long.valueOf(NumberUtils.parseLong(valueStr));
        }
        if (AtomicLong.class == targetType) {
            AtomicLong longValue = new AtomicLong();
            if (value instanceof Number) {
                longValue.set(((Number)value).longValue());
            } else if (value instanceof Boolean) {
                longValue.set(BooleanUtils.toLong((Boolean)value));
            }
            String valueStr = this.convertToStr(value);
            if (StringUtils.isBlank(valueStr)) {
                return null;
            }
            longValue.set(NumberUtils.parseLong(valueStr));
            return longValue;
        }
        if (Float.class == targetType) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (value instanceof Boolean) {
                return BooleanUtils.toFloatObj((Boolean)value);
            }
            String valueStr = this.convertToStr(value);
            return StringUtils.isBlank(valueStr) ? null : Float.valueOf(valueStr);
        }
        if (Double.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof Boolean) {
                return BooleanUtils.toDoubleObj((Boolean)value);
            }
            String valueStr = this.convertToStr(value);
            return StringUtils.isBlank(valueStr) ? null : Double.valueOf(valueStr);
        }
        if (BigDecimal.class == targetType) {
            return this.toBigDecimal(value);
        }
        if (BigInteger.class == targetType) {
            return this.toBigInteger(value);
        }
        if (Number.class == targetType) {
            if (value instanceof Number) {
                return (Number)value;
            }
            if (value instanceof Boolean) {
                return BooleanUtils.toInteger((Boolean)value);
            }
            String valueStr = this.convertToStr(value);
            return StringUtils.isBlank(valueStr) ? (Number)null : (Number)NumberUtils.parseNumber(valueStr);
        }
        throw new UnsupportedOperationException(StringUtils.format("Unsupport Number type: {}", this.targetType.getName()));
    }

    private BigDecimal toBigDecimal(Object value) {
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Boolean) {
            return new BigDecimal((Boolean)value != false ? 1 : 0);
        }
        String valueStr = this.convertToStr(value);
        if (StringUtils.isBlank(valueStr)) {
            return null;
        }
        return new BigDecimal(valueStr);
    }

    private BigInteger toBigInteger(Object value) {
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        if (value instanceof Boolean) {
            return BigInteger.valueOf((Boolean)value != false ? 1L : 0L);
        }
        String valueStr = this.convertToStr(value);
        if (StringUtils.isBlank(valueStr)) {
            return null;
        }
        return new BigInteger(valueStr);
    }

    @Override
    protected String convertToStr(Object value) {
        return StringUtils.trim(super.convertToStr(value));
    }

    @Override
    public Class<Number> getTargetType() {
        return this.targetType;
    }
}

