/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.aoju.bus.core.io.Buffer;
import org.aoju.bus.core.io.ByteString;
import org.aoju.bus.core.io.FileOperator;
import org.aoju.bus.core.io.Source;
import org.aoju.bus.core.io.Timeout;
import org.aoju.bus.core.utils.IoUtils;

final class RelayBuffer {
    static final ByteString PREFIX_CLEAN = ByteString.encodeUtf8("Httpd cache v1\n");
    static final ByteString PREFIX_DIRTY = ByteString.encodeUtf8("Httpd DIRTY :(\n");
    private static final int SOURCE_UPSTREAM = 1;
    private static final int SOURCE_FILE = 2;
    private static final long FILE_HEADER_SIZE = 32L;
    final Buffer upstreamBuffer = new Buffer();
    final Buffer buffer = new Buffer();
    final long bufferMaxSize;
    private final ByteString metadata;
    RandomAccessFile file;
    Thread upstreamReader;
    Source upstream;
    long upstreamPos;
    boolean complete;
    int sourceCount;

    private RelayBuffer(RandomAccessFile file, Source upstream, long upstreamPos, ByteString metadata, long bufferMaxSize) {
        this.file = file;
        this.upstream = upstream;
        this.complete = upstream == null;
        this.upstreamPos = upstreamPos;
        this.metadata = metadata;
        this.bufferMaxSize = bufferMaxSize;
    }

    public static RelayBuffer edit(File file, Source upstream, ByteString metadata, long bufferMaxSize) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        RelayBuffer result = new RelayBuffer(randomAccessFile, upstream, 0L, metadata, bufferMaxSize);
        randomAccessFile.setLength(0L);
        result.writeHeader(PREFIX_DIRTY, -1L, -1L);
        return result;
    }

    public static RelayBuffer read(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        FileOperator fileOperator = new FileOperator(randomAccessFile.getChannel());
        Buffer header = new Buffer();
        fileOperator.read(0L, header, 32L);
        ByteString prefix = header.readByteString(PREFIX_CLEAN.size());
        if (!prefix.equals(PREFIX_CLEAN)) {
            throw new IOException("unreadable cache file");
        }
        long upstreamSize = header.readLong();
        long metadataSize = header.readLong();
        Buffer metadataBuffer = new Buffer();
        fileOperator.read(32L + upstreamSize, metadataBuffer, metadataSize);
        ByteString metadata = metadataBuffer.readByteString();
        return new RelayBuffer(randomAccessFile, null, upstreamSize, metadata, 0L);
    }

    private void writeHeader(ByteString prefix, long upstreamSize, long metadataSize) throws IOException {
        Buffer header = new Buffer();
        header.write(prefix);
        header.writeLong(upstreamSize);
        header.writeLong(metadataSize);
        if (header.size() != 32L) {
            throw new IllegalArgumentException();
        }
        FileOperator fileOperator = new FileOperator(this.file.getChannel());
        fileOperator.write(0L, header, 32L);
    }

    private void writeMetadata(long upstreamSize) throws IOException {
        Buffer metadataBuffer = new Buffer();
        metadataBuffer.write(this.metadata);
        FileOperator fileOperator = new FileOperator(this.file.getChannel());
        fileOperator.write(32L + upstreamSize, metadataBuffer, this.metadata.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(long upstreamSize) throws IOException {
        this.writeMetadata(upstreamSize);
        this.file.getChannel().force(false);
        this.writeHeader(PREFIX_CLEAN, upstreamSize, this.metadata.size());
        this.file.getChannel().force(false);
        RelayBuffer relayBuffer = this;
        synchronized (relayBuffer) {
            this.complete = true;
        }
        IoUtils.close(this.upstream);
        this.upstream = null;
    }

    boolean isClosed() {
        return this.file == null;
    }

    public ByteString metadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source newSource() {
        RelayBuffer relayBuffer = this;
        synchronized (relayBuffer) {
            if (this.file == null) {
                return null;
            }
            ++this.sourceCount;
        }
        return new RelaySource();
    }

    class RelaySource
    implements Source {
        private final Timeout timeout = new Timeout();
        private FileOperator fileOperator;
        private long sourcePos;

        RelaySource() {
            this.fileOperator = new FileOperator(RelayBuffer.this.file.getChannel());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(Buffer sink, long byteCount) throws IOException {
            int source;
            long upstreamPos;
            block27: {
                if (this.fileOperator == null) {
                    throw new IllegalStateException("closed");
                }
                RelayBuffer relayBuffer = RelayBuffer.this;
                synchronized (relayBuffer) {
                    while (this.sourcePos == (upstreamPos = RelayBuffer.this.upstreamPos)) {
                        if (RelayBuffer.this.complete) {
                            return -1L;
                        }
                        if (RelayBuffer.this.upstreamReader != null) {
                            this.timeout.waitUntilNotified(RelayBuffer.this);
                            continue;
                        }
                        RelayBuffer.this.upstreamReader = Thread.currentThread();
                        source = 1;
                        break block27;
                    }
                    long bufferPos = upstreamPos - RelayBuffer.this.buffer.size();
                    if (this.sourcePos < bufferPos) {
                        source = 2;
                        break block27;
                    }
                    long bytesToRead = Math.min(byteCount, upstreamPos - this.sourcePos);
                    RelayBuffer.this.buffer.copyTo(sink, this.sourcePos - bufferPos, bytesToRead);
                    this.sourcePos += bytesToRead;
                    return bytesToRead;
                }
            }
            if (source == 2) {
                long bytesToRead = Math.min(byteCount, upstreamPos - this.sourcePos);
                this.fileOperator.read(32L + this.sourcePos, sink, bytesToRead);
                this.sourcePos += bytesToRead;
                return bytesToRead;
            }
            try {
                long upstreamBytesRead = RelayBuffer.this.upstream.read(RelayBuffer.this.upstreamBuffer, RelayBuffer.this.bufferMaxSize);
                if (upstreamBytesRead == -1L) {
                    RelayBuffer.this.commit(upstreamPos);
                    long l = -1L;
                    return l;
                }
                long bytesRead = Math.min(upstreamBytesRead, byteCount);
                RelayBuffer.this.upstreamBuffer.copyTo(sink, 0L, bytesRead);
                this.sourcePos += bytesRead;
                this.fileOperator.write(32L + upstreamPos, RelayBuffer.this.upstreamBuffer.clone(), upstreamBytesRead);
                RelayBuffer relayBuffer = RelayBuffer.this;
                synchronized (relayBuffer) {
                    RelayBuffer.this.buffer.write(RelayBuffer.this.upstreamBuffer, upstreamBytesRead);
                    if (RelayBuffer.this.buffer.size() > RelayBuffer.this.bufferMaxSize) {
                        RelayBuffer.this.buffer.skip(RelayBuffer.this.buffer.size() - RelayBuffer.this.bufferMaxSize);
                    }
                    RelayBuffer.this.upstreamPos += upstreamBytesRead;
                }
                long l = bytesRead;
                return l;
            }
            finally {
                RelayBuffer relayBuffer = RelayBuffer.this;
                synchronized (relayBuffer) {
                    RelayBuffer.this.upstreamReader = null;
                    RelayBuffer.this.notifyAll();
                }
            }
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.fileOperator == null) {
                return;
            }
            this.fileOperator = null;
            RandomAccessFile fileToClose = null;
            RelayBuffer relayBuffer = RelayBuffer.this;
            synchronized (relayBuffer) {
                --RelayBuffer.this.sourceCount;
                if (RelayBuffer.this.sourceCount == 0) {
                    fileToClose = RelayBuffer.this.file;
                    RelayBuffer.this.file = null;
                }
            }
            if (fileToClose != null) {
                IoUtils.close(fileToClose);
            }
        }
    }
}

