/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.file;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aoju.bus.core.io.LineHandler;
import org.aoju.bus.core.io.file.FileWrapper;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.CharsetUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;

public class FileReader
extends FileWrapper {
    public FileReader(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public FileReader(File file, String charset) {
        this(file, CharsetUtils.charset(charset));
    }

    public FileReader(String filePath, Charset charset) {
        this(FileUtils.file(filePath), charset);
    }

    public FileReader(String filePath, String charset) {
        this(FileUtils.file(filePath), CharsetUtils.charset(charset));
    }

    public FileReader(File file) {
        this(file, DEFAULT_CHARSET);
    }

    public FileReader(String filePath) {
        this(filePath, DEFAULT_CHARSET);
    }

    public static FileReader create(File file, Charset charset) {
        return new FileReader(file, charset);
    }

    public static FileReader create(File file) {
        return new FileReader(file);
    }

    public byte[] readBytes() throws InstrumentException {
        long len = this.file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new InstrumentException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)len];
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.file);
            int readLength = in.read(bytes);
            if ((long)readLength < len) {
                throw new IOException(StringUtils.format("File length is [{}] but read [{}]!", len, readLength));
            }
        }
        catch (Exception e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoUtils.close(in);
                throw throwable;
            }
        }
        IoUtils.close(in);
        return bytes;
    }

    public String readString() throws InstrumentException {
        return new String(this.readBytes(), this.charset);
    }

    public <T extends Collection<String>> T readLines(T collection) throws InstrumentException {
        T t;
        BufferedReader reader = null;
        try {
            String line;
            reader = FileUtils.getReader(this.file, this.charset);
            while ((line = reader.readLine()) != null) {
                collection.add((String)line);
            }
            t = collection;
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoUtils.close(reader);
                throw throwable;
            }
        }
        IoUtils.close(reader);
        return t;
    }

    public void readLines(LineHandler lineHandler) throws InstrumentException {
        BufferedReader reader = null;
        try {
            reader = FileUtils.getReader(this.file, this.charset);
            IoUtils.readLines((Reader)reader, lineHandler);
        }
        catch (Throwable throwable) {
            IoUtils.close(reader);
            throw throwable;
        }
        IoUtils.close(reader);
    }

    public List<String> readLines() throws InstrumentException {
        return this.readLines(new ArrayList());
    }

    public <T> T read(ReaderHandler<T> readerHandler) throws InstrumentException {
        T result;
        BufferedReader reader = null;
        try {
            reader = FileUtils.getReader(this.file, this.charset);
            result = readerHandler.handle(reader);
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoUtils.close(reader);
                throw throwable;
            }
        }
        IoUtils.close(reader);
        return result;
    }

    public BufferedReader getReader() throws InstrumentException {
        return IoUtils.getReader((InputStream)this.getInputStream(), this.charset);
    }

    public BufferedInputStream getInputStream() throws InstrumentException {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long writeToStream(OutputStream out) throws InstrumentException {
        try (FileInputStream in = new FileInputStream(this.file);){
            long l = IoUtils.copy((InputStream)in, out);
            return l;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    private void checkFile() throws InstrumentException {
        if (!this.file.exists()) {
            throw new InstrumentException("File not exist : " + this.file);
        }
        if (!this.file.isFile()) {
            throw new InstrumentException("Not a file :" + this.file);
        }
    }

    public static interface ReaderHandler<T> {
        public T handle(BufferedReader var1) throws IOException;
    }
}

