/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.NumberUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.RandomUtils;
import org.aoju.bus.core.utils.StringUtils;

public class ImageUtils {
    public static void scale(File srcImageFile, File destImageFile, float scale) {
        ImageUtils.scale((Image)ImageUtils.read(srcImageFile), destImageFile, scale);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, float scale) {
        ImageUtils.scale((Image)ImageUtils.read(srcStream), destStream, scale);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, float scale) {
        ImageUtils.scale((Image)ImageUtils.read(srcStream), destStream, scale);
    }

    public static void scale(Image srcImage, File destFile, float scale) throws InstrumentException {
        org.aoju.bus.core.image.Image.from(srcImage).setTargetImageType(FileUtils.extName(destFile)).scale(scale).write(destFile);
    }

    public static void scale(Image srcImage, OutputStream out, float scale) throws InstrumentException {
        ImageUtils.scale(srcImage, ImageUtils.getImageOutputStream(out), scale);
    }

    public static void scale(Image srcImage, ImageOutputStream destImageStream, float scale) throws InstrumentException {
        ImageUtils.writeJpg(ImageUtils.scale(srcImage, scale), destImageStream);
    }

    public static Image scale(Image srcImage, float scale) {
        return org.aoju.bus.core.image.Image.from(srcImage).scale(scale).getImg();
    }

    public static Image scale(Image srcImage, int width, int height) {
        return org.aoju.bus.core.image.Image.from(srcImage).scale(width, height).getImg();
    }

    public static void scale(File srcImageFile, File destImageFile, int width, int height, Color fixedColor) throws InstrumentException {
        ImageUtils.write(ImageUtils.scale(ImageUtils.read(srcImageFile), width, height, fixedColor), destImageFile);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, int width, int height, Color fixedColor) throws InstrumentException {
        ImageUtils.scale(ImageUtils.read(srcStream), ImageUtils.getImageOutputStream(destStream), width, height, fixedColor);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, int width, int height, Color fixedColor) throws InstrumentException {
        ImageUtils.scale(ImageUtils.read(srcStream), destStream, width, height, fixedColor);
    }

    public static void scale(Image srcImage, ImageOutputStream destImageStream, int width, int height, Color fixedColor) throws InstrumentException {
        ImageUtils.writeJpg(ImageUtils.scale(srcImage, width, height, fixedColor), destImageStream);
    }

    public static Image scale(Image srcImage, int width, int height, Color fixedColor) {
        return org.aoju.bus.core.image.Image.from(srcImage).scale(width, height, fixedColor).getImg();
    }

    public static void cut(File srcImgFile, File destImgFile, Rectangle rectangle) {
        ImageUtils.cut((Image)ImageUtils.read(srcImgFile), destImgFile, rectangle);
    }

    public static void cut(InputStream srcStream, OutputStream destStream, Rectangle rectangle) {
        ImageUtils.cut((Image)ImageUtils.read(srcStream), destStream, rectangle);
    }

    public static void cut(ImageInputStream srcStream, ImageOutputStream destStream, Rectangle rectangle) {
        ImageUtils.cut((Image)ImageUtils.read(srcStream), destStream, rectangle);
    }

    public static void cut(Image srcImage, File destFile, Rectangle rectangle) throws InstrumentException {
        ImageUtils.write(ImageUtils.cut(srcImage, rectangle), destFile);
    }

    public static void cut(Image srcImage, OutputStream out, Rectangle rectangle) throws InstrumentException {
        ImageUtils.cut(srcImage, ImageUtils.getImageOutputStream(out), rectangle);
    }

    public static void cut(Image srcImage, ImageOutputStream destImageStream, Rectangle rectangle) throws InstrumentException {
        ImageUtils.writeJpg(ImageUtils.cut(srcImage, rectangle), destImageStream);
    }

    public static Image cut(Image srcImage, Rectangle rectangle) {
        return org.aoju.bus.core.image.Image.from(srcImage).setPositionBaseCentre(false).cut(rectangle).getImg();
    }

    public static Image cut(Image srcImage, int x, int y) {
        return ImageUtils.cut(srcImage, x, y, -1);
    }

    public static Image cut(Image srcImage, int x, int y, int radius) {
        return org.aoju.bus.core.image.Image.from(srcImage).cut(x, y, radius).getImg();
    }

    public static void slice(File srcImageFile, File descDir, int destWidth, int destHeight) {
        ImageUtils.slice(ImageUtils.read(srcImageFile), descDir, destWidth, destHeight);
    }

    public static void slice(Image srcImage, File descDir, int destWidth, int destHeight) {
        if (destWidth <= 0) {
            destWidth = 200;
        }
        if (destHeight <= 0) {
            destHeight = 150;
        }
        int srcWidth = srcImage.getHeight(null);
        int srcHeight = srcImage.getWidth(null);
        try {
            if (srcWidth > destWidth && srcHeight > destHeight) {
                int cols = 0;
                int rows = 0;
                cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor(srcWidth / destWidth) + 1;
                rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor(srcHeight / destHeight) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        Image tag = ImageUtils.cut(srcImage, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                        ImageIO.write(ImageUtils.toRenderedImage(tag), "jpeg", new File(descDir, "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void sliceByRowsAndCols(File srcImageFile, File destDir, int rows, int cols) {
        try {
            ImageUtils.sliceByRowsAndCols(ImageIO.read(srcImageFile), destDir, rows, cols);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void sliceByRowsAndCols(Image srcImage, File destDir, int rows, int cols) {
        if (!destDir.exists()) {
            FileUtils.mkdir(destDir);
        } else if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination Dir must be a Directory !");
        }
        try {
            if (rows <= 0 || rows > 20) {
                rows = 2;
            }
            if (cols <= 0 || cols > 20) {
                cols = 2;
            }
            BufferedImage bi = ImageUtils.toBufferedImage(srcImage);
            int srcWidth = ((Image)bi).getWidth(null);
            int srcHeight = ((Image)bi).getHeight(null);
            int destWidth = NumberUtils.partValue(srcWidth, cols);
            int destHeight = NumberUtils.partValue(srcHeight, rows);
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    Image tag = ImageUtils.cut(bi, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                    ImageIO.write(ImageUtils.toRenderedImage(tag), "jpeg", new File(destDir, "_r" + i + "_c" + j + ".jpg"));
                }
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File srcImageFile, File destImageFile) {
        Assert.notNull(srcImageFile);
        Assert.notNull(destImageFile);
        Assert.isFalse(srcImageFile.equals(destImageFile), "Src file is equals to dest file!", new Object[0]);
        String srcExtName = FileUtils.extName(srcImageFile);
        String destExtName = FileUtils.extName(destImageFile);
        if (StringUtils.equalsIgnoreCase(srcExtName, destExtName)) {
            FileUtils.copy(srcImageFile, destImageFile, true);
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageUtils.getImageOutputStream(destImageFile);
            ImageUtils.convert(ImageUtils.read(srcImageFile), destExtName, imageOutputStream, StringUtils.equalsIgnoreCase("png", srcExtName));
        }
        finally {
            IoUtils.close(imageOutputStream);
        }
    }

    public static void convert(InputStream srcStream, String formatName, OutputStream destStream) {
        ImageUtils.write((Image)ImageUtils.read(srcStream), formatName, ImageUtils.getImageOutputStream(destStream));
    }

    public static void convert(Image srcImage, String formatName, ImageOutputStream destImageStream, boolean isSrcPng) {
        try {
            ImageIO.write((RenderedImage)(isSrcPng ? ImageUtils.copyImage(srcImage, 1) : ImageUtils.toBufferedImage(srcImage)), formatName, destImageStream);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void gray(File srcImageFile, File destImageFile) {
        ImageUtils.gray((Image)ImageUtils.read(srcImageFile), destImageFile);
    }

    public static void gray(InputStream srcStream, OutputStream destStream) {
        ImageUtils.gray((Image)ImageUtils.read(srcStream), ImageUtils.getImageOutputStream(destStream));
    }

    public static void gray(ImageInputStream srcStream, ImageOutputStream destStream) {
        ImageUtils.gray((Image)ImageUtils.read(srcStream), destStream);
    }

    public static void gray(Image srcImage, File outFile) {
        ImageUtils.write(ImageUtils.gray(srcImage), outFile);
    }

    public static void gray(Image srcImage, OutputStream out) {
        ImageUtils.gray(srcImage, ImageUtils.getImageOutputStream(out));
    }

    public static void gray(Image srcImage, ImageOutputStream destImageStream) throws InstrumentException {
        ImageUtils.writeJpg(ImageUtils.gray(srcImage), destImageStream);
    }

    public static Image gray(Image srcImage) {
        return org.aoju.bus.core.image.Image.from(srcImage).gray().getImg();
    }

    public static void binary(File srcImageFile, File destImageFile) {
        ImageUtils.binary(ImageUtils.read(srcImageFile), destImageFile);
    }

    public static void binary(InputStream srcStream, OutputStream destStream, String imageType) {
        ImageUtils.binary((Image)ImageUtils.read(srcStream), ImageUtils.getImageOutputStream(destStream), imageType);
    }

    public static void binary(ImageInputStream srcStream, ImageOutputStream destStream, String imageType) {
        ImageUtils.binary((Image)ImageUtils.read(srcStream), destStream, imageType);
    }

    public static void binary(Image srcImage, File outFile) {
        ImageUtils.write(ImageUtils.binary(srcImage), outFile);
    }

    public static void binary(Image srcImage, OutputStream out, String imageType) {
        ImageUtils.binary(srcImage, ImageUtils.getImageOutputStream(out), imageType);
    }

    public static void binary(Image srcImage, ImageOutputStream destImageStream, String imageType) throws InstrumentException {
        ImageUtils.write(ImageUtils.binary(srcImage), imageType, destImageStream);
    }

    public static Image binary(Image srcImage) {
        return org.aoju.bus.core.image.Image.from(srcImage).binary().getImg();
    }

    public static void pressText(File imageFile, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageUtils.pressText((Image)ImageUtils.read(imageFile), destFile, pressText, color, font, x, y, alpha);
    }

    public static void pressText(InputStream srcStream, OutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageUtils.pressText((Image)ImageUtils.read(srcStream), ImageUtils.getImageOutputStream(destStream), pressText, color, font, x, y, alpha);
    }

    public static void pressText(ImageInputStream srcStream, ImageOutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageUtils.pressText((Image)ImageUtils.read(srcStream), destStream, pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) throws InstrumentException {
        ImageUtils.write(ImageUtils.pressText(srcImage, pressText, color, font, x, y, alpha), destFile);
    }

    public static void pressText(Image srcImage, OutputStream to, String pressText, Color color, Font font, int x, int y, float alpha) throws InstrumentException {
        ImageUtils.pressText(srcImage, ImageUtils.getImageOutputStream(to), pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, ImageOutputStream destImageStream, String pressText, Color color, Font font, int x, int y, float alpha) throws InstrumentException {
        ImageUtils.writeJpg(ImageUtils.pressText(srcImage, pressText, color, font, x, y, alpha), destImageStream);
    }

    public static Image pressText(Image srcImage, String pressText, Color color, Font font, int x, int y, float alpha) {
        return org.aoju.bus.core.image.Image.from(srcImage).pressText(pressText, color, font, x, y, alpha).getImg();
    }

    public static void pressImage(File srcImageFile, File destImageFile, Image pressImage, int x, int y, float alpha) {
        ImageUtils.pressImage((Image)ImageUtils.read(srcImageFile), destImageFile, pressImage, x, y, alpha);
    }

    public static void pressImage(InputStream srcStream, OutputStream destStream, Image pressImage, int x, int y, float alpha) {
        ImageUtils.pressImage((Image)ImageUtils.read(srcStream), ImageUtils.getImageOutputStream(destStream), pressImage, x, y, alpha);
    }

    public static void pressImage(ImageInputStream srcStream, ImageOutputStream destStream, Image pressImage, int x, int y, float alpha) throws InstrumentException {
        ImageUtils.pressImage((Image)ImageUtils.read(srcStream), destStream, pressImage, x, y, alpha);
    }

    public static void pressImage(Image srcImage, File outFile, Image pressImage, int x, int y, float alpha) throws InstrumentException {
        ImageUtils.write(ImageUtils.pressImage(srcImage, pressImage, x, y, alpha), outFile);
    }

    public static void pressImage(Image srcImage, OutputStream out, Image pressImage, int x, int y, float alpha) throws InstrumentException {
        ImageUtils.pressImage(srcImage, ImageUtils.getImageOutputStream(out), pressImage, x, y, alpha);
    }

    public static void pressImage(Image srcImage, ImageOutputStream destImageStream, Image pressImage, int x, int y, float alpha) throws InstrumentException {
        ImageUtils.writeJpg(ImageUtils.pressImage(srcImage, pressImage, x, y, alpha), destImageStream);
    }

    public static Image pressImage(Image srcImage, Image pressImage, int x, int y, float alpha) {
        return org.aoju.bus.core.image.Image.from(srcImage).pressImage(pressImage, x, y, alpha).getImg();
    }

    public static Image pressImage(Image srcImage, Image pressImage, Rectangle rectangle, float alpha) {
        return org.aoju.bus.core.image.Image.from(srcImage).pressImage(pressImage, rectangle, alpha).getImg();
    }

    public static void rotate(File imageFile, int degree, File outFile) throws InstrumentException {
        ImageUtils.rotate((Image)ImageUtils.read(imageFile), degree, outFile);
    }

    public static void rotate(Image image, int degree, File outFile) throws InstrumentException {
        ImageUtils.write(ImageUtils.rotate(image, degree), outFile);
    }

    public static void rotate(Image image, int degree, OutputStream out) throws InstrumentException {
        ImageUtils.writeJpg(ImageUtils.rotate(image, degree), ImageUtils.getImageOutputStream(out));
    }

    public static void rotate(Image image, int degree, ImageOutputStream out) throws InstrumentException {
        ImageUtils.writeJpg(ImageUtils.rotate(image, degree), out);
    }

    public static Image rotate(Image image, int degree) {
        return org.aoju.bus.core.image.Image.from(image).rotate(degree).getImg();
    }

    public static void flip(File imageFile, File outFile) throws InstrumentException {
        ImageUtils.flip((Image)ImageUtils.read(imageFile), outFile);
    }

    public static void flip(Image image, File outFile) throws InstrumentException {
        ImageUtils.write(ImageUtils.flip(image), outFile);
    }

    public static void flip(Image image, OutputStream out) throws InstrumentException {
        ImageUtils.flip(image, ImageUtils.getImageOutputStream(out));
    }

    public static void flip(Image image, ImageOutputStream out) throws InstrumentException {
        ImageUtils.writeJpg(ImageUtils.flip(image), out);
    }

    public static Image flip(Image image) {
        return org.aoju.bus.core.image.Image.from(image).flip().getImg();
    }

    public static void compress(File imageFile, File outFile, float quality) throws InstrumentException {
        org.aoju.bus.core.image.Image.from(imageFile).setQuality(quality).write(outFile);
    }

    public static RenderedImage toRenderedImage(Image image) {
        if (image instanceof RenderedImage) {
            return (RenderedImage)((Object)image);
        }
        return ImageUtils.copyImage(image, 1);
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        return ImageUtils.copyImage(image, 1);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType) {
        BufferedImage bufferedImage;
        if (!imageType.equalsIgnoreCase("png")) {
            if (image instanceof BufferedImage) {
                bufferedImage = (BufferedImage)image;
                if (1 != bufferedImage.getType()) {
                    bufferedImage = ImageUtils.copyImage(image, 1);
                }
            } else {
                bufferedImage = ImageUtils.copyImage(image, 1);
            }
        } else {
            bufferedImage = ImageUtils.toBufferedImage(image);
        }
        return bufferedImage;
    }

    public static BufferedImage copyImage(Image image, int imageType) {
        return ImageUtils.copyImage(image, imageType, null);
    }

    public static BufferedImage copyImage(Image image, int imageType, Color backgroundColor) {
        BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), imageType);
        Graphics2D bGr = org.aoju.bus.core.image.Graphics.createGraphics(bimage, backgroundColor);
        bGr.drawImage(image, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage toImage(String base64) throws InstrumentException {
        return ImageUtils.toImage(Base64.decode(base64));
    }

    public static BufferedImage toImage(byte[] imageBytes) throws InstrumentException {
        return ImageUtils.read(new ByteArrayInputStream(imageBytes));
    }

    public static ByteArrayInputStream toStream(Image image, String imageType) {
        return IoUtils.toStream(ImageUtils.toBytes(image, imageType));
    }

    public static String toBase64(Image image, String imageType) {
        return Base64.encode(ImageUtils.toBytes(image, imageType));
    }

    public static byte[] toBytes(Image image, String imageType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtils.write(image, imageType, out);
        return out.toByteArray();
    }

    public static void createImage(String str, Font font, Color backgroundColor, Color fontColor, ImageOutputStream out) {
        ImageUtils.writePng((Image)ImageUtils.createImage(str, font, backgroundColor, fontColor, 2), out);
    }

    public static BufferedImage createImage(String str, Font font, Color backgroundColor, Color fontColor, int imageType) {
        Rectangle2D r = ImageUtils.getRectangle(str, font);
        int unitHeight = (int)Math.floor(r.getHeight());
        int width = (int)Math.round(r.getWidth()) + 1;
        int height = unitHeight + 3;
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics g = image.getGraphics();
        if (null != backgroundColor) {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, width, height);
        }
        g.setColor(ObjectUtils.defaultIfNull(fontColor, Color.BLACK));
        g.setFont(font);
        g.drawString(str, 0, font.getSize());
        g.dispose();
        return image;
    }

    public static Rectangle2D getRectangle(String str, Font font) {
        return font.getStringBounds(str, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
    }

    public static Font createFont(File fontFile) {
        try {
            return Font.createFont(0, fontFile);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontFile);
            }
            catch (Exception e1) {
                throw new InstrumentException(e);
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static Font createFont(InputStream fontStream) {
        try {
            return Font.createFont(0, fontStream);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontStream);
            }
            catch (Exception e1) {
                throw new InstrumentException(e1);
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        return org.aoju.bus.core.image.Graphics.createGraphics(image, color);
    }

    public static void writeJpg(Image image, ImageOutputStream destImageStream) throws InstrumentException {
        ImageUtils.write(image, "jpg", destImageStream);
    }

    public static void writePng(Image image, ImageOutputStream destImageStream) throws InstrumentException {
        ImageUtils.write(image, "png", destImageStream);
    }

    public static void writeJpg(Image image, OutputStream out) throws InstrumentException {
        ImageUtils.write(image, "jpg", out);
    }

    public static void writePng(Image image, OutputStream out) throws InstrumentException {
        ImageUtils.write(image, "png", out);
    }

    public static void write(Image image, String imageType, OutputStream out) throws InstrumentException {
        ImageUtils.write(image, imageType, ImageUtils.getImageOutputStream(out));
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream) throws InstrumentException {
        return ImageUtils.write(image, imageType, destImageStream, 1.0f);
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality) throws InstrumentException {
        if (StringUtils.isBlank(imageType)) {
            imageType = "jpg";
        }
        ImageWriter writer = ImageUtils.getWriter(image, imageType);
        return ImageUtils.write((Image)ImageUtils.toBufferedImage(image, imageType), writer, destImageStream, quality);
    }

    public static void write(Image image, File targetFile) throws InstrumentException {
        ImageOutputStream out = null;
        try {
            out = ImageUtils.getImageOutputStream(targetFile);
            ImageUtils.write(image, FileUtils.extName(targetFile), out);
        }
        finally {
            IoUtils.close(out);
        }
    }

    public static boolean write(Image image, ImageWriter writer, ImageOutputStream output, float quality) {
        if (writer == null) {
            return false;
        }
        writer.setOutput(output);
        RenderedImage renderedImage = ImageUtils.toRenderedImage(image);
        ImageWriteParam imgWriteParams = null;
        if (quality > 0.0f && quality < 1.0f && (imgWriteParams = writer.getDefaultWriteParam()).canWriteCompressed()) {
            imgWriteParams.setCompressionMode(2);
            imgWriteParams.setCompressionQuality(quality);
            ColorModel colorModel = renderedImage.getColorModel();
            imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        }
        try {
            if (null != imgWriteParams) {
                writer.write(null, new IIOImage(renderedImage, null, null), imgWriteParams);
            } else {
                writer.write(renderedImage);
            }
            output.flush();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            writer.dispose();
        }
        return true;
    }

    public static ImageReader getReader(String type) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(type);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static BufferedImage read(String imageFilePath) {
        return ImageUtils.read(FileUtils.file(imageFilePath));
    }

    public static BufferedImage read(File imageFile) {
        try {
            return ImageIO.read(imageFile);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedImage read(Resource resource) {
        return ImageUtils.read(resource.getStream());
    }

    public static BufferedImage read(InputStream imageStream) {
        try {
            return ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedImage read(ImageInputStream imageStream) {
        try {
            return ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedImage read(URL imageUrl) {
        try {
            return ImageIO.read(imageUrl);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static ImageOutputStream getImageOutputStream(OutputStream out) throws InstrumentException {
        try {
            return ImageIO.createImageOutputStream(out);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static ImageOutputStream getImageOutputStream(File outFile) throws InstrumentException {
        try {
            return ImageIO.createImageOutputStream(outFile);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static ImageInputStream getImageInputStream(InputStream in) throws InstrumentException {
        try {
            return ImageIO.createImageInputStream(in);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static ImageWriter getWriter(Image image, String formatName) {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(ImageUtils.toRenderedImage(image));
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, formatName);
        return iter.hasNext() ? iter.next() : null;
    }

    public static ImageWriter getWriter(String formatName) {
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (null == writer && (iter = ImageIO.getImageWritersBySuffix(formatName)).hasNext()) {
            writer = iter.next();
        }
        return writer;
    }

    public static String toHex(Color color) {
        String R = Integer.toHexString(color.getRed());
        R = R.length() < 2 ? '0' + R : R;
        String G = Integer.toHexString(color.getGreen());
        G = G.length() < 2 ? '0' + G : G;
        String B = Integer.toHexString(color.getBlue());
        B = B.length() < 2 ? '0' + B : B;
        return '#' + R + G + B;
    }

    public static Color hexToColor(String hex) {
        return ImageUtils.getColor(Integer.parseInt(StringUtils.removePrefix("#", hex), 16));
    }

    public static Color getColor(int rgb) {
        return new Color(rgb);
    }

    public static Color getColor(String colorName) {
        if (StringUtils.isBlank(colorName)) {
            return null;
        }
        if ("BLACK".equals(colorName = colorName.toUpperCase())) {
            return Color.BLACK;
        }
        if ("WHITE".equals(colorName)) {
            return Color.WHITE;
        }
        if ("LIGHTGRAY".equals(colorName) || "LIGHT_GRAY".equals(colorName)) {
            return Color.LIGHT_GRAY;
        }
        if ("GRAY".equals(colorName)) {
            return Color.GRAY;
        }
        if ("DARK_GRAY".equals(colorName) || "DARK_GRAY".equals(colorName)) {
            return Color.DARK_GRAY;
        }
        if ("RED".equals(colorName)) {
            return Color.RED;
        }
        if ("PINK".equals(colorName)) {
            return Color.PINK;
        }
        if ("ORANGE".equals(colorName)) {
            return Color.ORANGE;
        }
        if ("YELLOW".equals(colorName)) {
            return Color.YELLOW;
        }
        if ("GREEN".equals(colorName)) {
            return Color.GREEN;
        }
        if ("MAGENTA".equals(colorName)) {
            return Color.MAGENTA;
        }
        if ("CYAN".equals(colorName)) {
            return Color.CYAN;
        }
        if ("BLUE".equals(colorName)) {
            return Color.BLUE;
        }
        if ("DARKGOLD".equals(colorName)) {
            return ImageUtils.hexToColor("#9e7e67");
        }
        if ("LIGHTGOLD".equals(colorName)) {
            return ImageUtils.hexToColor("#ac9c85");
        }
        if (StringUtils.startWith((CharSequence)colorName, '#')) {
            return ImageUtils.hexToColor(colorName);
        }
        if (StringUtils.startWith((CharSequence)colorName, '$')) {
            return ImageUtils.hexToColor("#" + colorName.substring(1));
        }
        List<String> rgb = StringUtils.split(colorName, ',');
        if (3 == rgb.size()) {
            Integer b;
            Integer g;
            Integer r = Convert.toInt(rgb.get(0));
            if (!ArrayUtils.hasNull(r, g = Convert.toInt(rgb.get(1)), b = Convert.toInt(rgb.get(2)))) {
                return new Color(r, g, b);
            }
        } else {
            return null;
        }
        return null;
    }

    public static Color randomColor() {
        return ImageUtils.randomColor(null);
    }

    public static Color randomColor(Random random) {
        if (null == random) {
            random = RandomUtils.getRandom();
        }
        return new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255));
    }
}

