/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.map.TableMap;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.IterUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.ResourceUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.TextUtils;

public class UriUtils {
    private String scheme;
    private String host;
    private int port = -1;
    private Path path;
    private Query query;
    private String fragment;
    private Charset charset;

    public UriUtils() {
        this.charset = org.aoju.bus.core.lang.Charset.UTF_8;
    }

    public UriUtils(String scheme, String host, int port, Path path, Query query, String fragment, Charset charset) {
        this.charset = charset;
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
        this.setFragment(fragment);
    }

    public static UriUtils create() {
        return new UriUtils();
    }

    public static UriUtils of(String url, Charset charset) {
        Assert.notBlank(url, "Url must be not blank!", new Object[0]);
        return UriUtils.of(UriUtils.url(url.trim()), charset);
    }

    public static UriUtils of(URI uri, Charset charset) {
        return UriUtils.of(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getRawQuery(), uri.getFragment(), charset);
    }

    public static UriUtils of(URL url, Charset charset) {
        return UriUtils.of(url.getProtocol(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef(), charset);
    }

    public static UriUtils of(String scheme, String host, int port, String path, String query, String fragment, Charset charset) {
        return UriUtils.of(scheme, host, port, Path.of(path, charset), Query.of(query, charset), fragment, charset);
    }

    public static UriUtils of(String scheme, String host, int port, Path path, Query query, String fragment, Charset charset) {
        return new UriUtils(scheme, host, port, path, query, fragment, charset);
    }

    public static URL url(String url) {
        return UriUtils.url(url, null);
    }

    public static URL url(String url, URLStreamHandler handler) {
        Assert.notNull(url, "URL must not be null", new Object[0]);
        if (url.startsWith("classpath:")) {
            url = url.substring("classpath:".length());
            return ClassUtils.getClassLoader().getResource(url);
        }
        try {
            return new URL(null, url, handler);
        }
        catch (MalformedURLException e) {
            try {
                return new File(url).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new InstrumentException(e);
            }
        }
    }

    public static URL toUrlForHttp(String urlStr) {
        return UriUtils.toUrlForHttp(urlStr, null);
    }

    public static URL toUrlForHttp(String urlStr, URLStreamHandler handler) {
        Assert.notBlank(urlStr, "Url is blank !", new Object[0]);
        urlStr = StringUtils.cleanBlank(urlStr);
        return UriUtils.url(urlStr, handler);
    }

    public static URL getURL(String pathBaseClassLoader) {
        return ResourceUtils.getResource(pathBaseClassLoader);
    }

    public static URL getURL(File file) {
        Assert.notNull(file, "File is null !", new Object[0]);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new InstrumentException("Error occured when get URL!");
        }
    }

    public static URL[] getURL(File ... files) {
        URL[] urls = new URL[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new InstrumentException("Error occured when get URL!");
        }
        return urls;
    }

    public static URL getURL(String path, Class<?> clazz) {
        return ResourceUtils.getResource(path, clazz);
    }

    public static String formatUrl(String url) {
        return UriUtils.normalize(url);
    }

    public static String complateUrl(String baseUrl, String relativePath) {
        if (StringUtils.isBlank(baseUrl = UriUtils.formatUrl(baseUrl))) {
            return null;
        }
        try {
            URL absoluteUrl = new URL(baseUrl);
            URL parseUrl = new URL(absoluteUrl, relativePath);
            return parseUrl.toString();
        }
        catch (MalformedURLException e) {
            throw new InstrumentException(e);
        }
    }

    public static String encode(String url) throws InstrumentException {
        return UriUtils.encode(url, "UTF-8");
    }

    public static String encodeAll(String url) {
        return UriUtils.encodeAll(url, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static String encodeAll(String url, Charset charset) {
        try {
            return URLEncoder.encode(url, charset.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new InstrumentException(e);
        }
    }

    public static String getPath(String uriStr) {
        URI uri;
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new InstrumentException(e);
        }
        return uri.getPath();
    }

    public static String getDecodedPath(URL url) {
        if (null == url) {
            return null;
        }
        String path = null;
        try {
            path = UriUtils.toURI(url).getPath();
        }
        catch (InstrumentException instrumentException) {
            // empty catch block
        }
        return null != path ? path : url.getPath();
    }

    public static URI toURI(URL url) throws InstrumentException {
        if (null == url) {
            return null;
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new InstrumentException(e);
        }
    }

    public static URI toURI(String location) throws InstrumentException {
        try {
            return new URI(location.replace(" ", "%20"));
        }
        catch (URISyntaxException e) {
            throw new InstrumentException(e);
        }
    }

    public static boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return "file".equals(protocol) || "vfsfile".equals(protocol) || "vfs".equals(protocol);
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return "jar".equals(protocol) || "zip".equals(protocol) || "vfszip".equals(protocol) || "wsjar".equals(protocol);
    }

    public static boolean isJarFileURL(URL url) {
        return "file".equals(url.getProtocol()) && url.getPath().toLowerCase().endsWith(".jar");
    }

    public static InputStream getStream(URL url) {
        Assert.notNull(url);
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedReader getReader(URL url, Charset charset) {
        return IoUtils.getReader(UriUtils.getStream(url), charset);
    }

    public static JarFile getJarFile(URL url) {
        try {
            JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
            return urlConnection.getJarFile();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static String normalize(String url) {
        return UriUtils.normalize(url, false);
    }

    public static String normalize(String url, boolean isEncode) {
        String body;
        String protocol;
        if (StringUtils.isBlank(url)) {
            return url;
        }
        int sepIndex = url.indexOf("://");
        if (sepIndex > 0) {
            protocol = StringUtils.subPre(url, sepIndex + 3);
            body = StringUtils.subSuf(url, sepIndex + 3);
        } else {
            protocol = "http://";
            body = url;
        }
        int paramsSepIndex = StringUtils.indexOf(body, '?');
        String params = null;
        if (paramsSepIndex > 0) {
            params = StringUtils.subSuf(body, paramsSepIndex);
            body = StringUtils.subPre(body, paramsSepIndex);
        }
        if (StringUtils.isNotEmpty(body)) {
            body = body.replaceAll("^[\\\\/]+", "");
            body = body.replace("\\", "/").replaceAll("//+", "/");
        }
        int pathSepIndex = StringUtils.indexOf(body, '/');
        String domain = body;
        String path = null;
        if (pathSepIndex > 0) {
            domain = StringUtils.subPre(body, pathSepIndex);
            path = StringUtils.subSuf(body, pathSepIndex);
        }
        if (isEncode) {
            path = UriUtils.encode(path);
        }
        return protocol + domain + StringUtils.nullToEmpty(path) + StringUtils.nullToEmpty(params);
    }

    public static String encodeScheme(String scheme, String encoding) {
        return UriUtils.encode(scheme, encoding, Type.SCHEME);
    }

    public static String encodeScheme(String scheme, Charset charset) {
        return UriUtils.encode(scheme, charset, Type.SCHEME);
    }

    public static String encodeAuthority(String authority, String encoding) {
        return UriUtils.encode(authority, encoding, Type.AUTHORITY);
    }

    public static String encodeAuthority(String authority, Charset charset) {
        return UriUtils.encode(authority, charset, Type.AUTHORITY);
    }

    public static String encodeUserInfo(String userInfo, String encoding) {
        return UriUtils.encode(userInfo, encoding, Type.USER_INFO);
    }

    public static String encodeUserInfo(String userInfo, Charset charset) {
        return UriUtils.encode(userInfo, charset, Type.USER_INFO);
    }

    public static String encodeHost(String host, String encoding) {
        return UriUtils.encode(host, encoding, Type.HOST_IPV4);
    }

    public static String encodeHost(String host, Charset charset) {
        return UriUtils.encode(host, charset, Type.HOST_IPV4);
    }

    public static String encodePort(String port, String encoding) {
        return UriUtils.encode(port, encoding, Type.PORT);
    }

    public static String encodePort(String port, Charset charset) {
        return UriUtils.encode(port, charset, Type.PORT);
    }

    public static String encodePath(String path, String encoding) {
        return UriUtils.encode(path, encoding, Type.PATH);
    }

    public static String encodePath(String path, Charset charset) {
        return UriUtils.encode(path, charset, Type.PATH);
    }

    public static String encodePathSegment(String segment, String encoding) {
        return UriUtils.encode(segment, encoding, Type.PATH_SEGMENT);
    }

    public static String encodePathSegment(String segment, Charset charset) {
        return UriUtils.encode(segment, charset, Type.PATH_SEGMENT);
    }

    public static String encodeQuery(String url) {
        return UriUtils.encodeQuery(url, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static String encodeQuery(String query, String encoding) {
        return UriUtils.encode(query, encoding, Type.QUERY);
    }

    public static String encodeQuery(String query, Charset charset) {
        return UriUtils.encode(query, charset, Type.QUERY);
    }

    public static String encodeQueryParam(String queryParam, String encoding) {
        return UriUtils.encode(queryParam, encoding, Type.QUERY_PARAM);
    }

    public static String encodeQueryParam(String queryParam, Charset charset) {
        return UriUtils.encode(queryParam, charset, Type.QUERY_PARAM);
    }

    public static String encodeFragment(String fragment, String encoding) {
        return UriUtils.encode(fragment, encoding, Type.FRAGMENT);
    }

    public static String encodeFragment(String fragment, Charset charset) {
        return UriUtils.encode(fragment, charset, Type.FRAGMENT);
    }

    public static String encode(String source, String encoding) {
        return UriUtils.encode(source, encoding, Type.URI);
    }

    public static String encode(String source, Charset charset) {
        return UriUtils.encode(source, charset, Type.URI);
    }

    public static Map<String, String> encodeUriVariables(Map<String, ?> uriVariables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(uriVariables.size());
        for (Map.Entry<String, ?> entry : uriVariables.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String stringValue = value != null ? value.toString() : "";
            result.put(key, UriUtils.encode(stringValue, Charset.forName("UTF-8")));
        }
        return result;
    }

    public static Object[] encodeUriVariables(Object ... uriVariables) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object value : uriVariables) {
            String stringValue = value != null ? value.toString() : "";
            result.add(UriUtils.encode(stringValue, org.aoju.bus.core.lang.Charset.UTF_8));
        }
        return result.toArray();
    }

    private static String encode(String scheme, String encoding, Type type) {
        return UriUtils.encodeUriComponent(scheme, encoding, type);
    }

    private static String encode(String scheme, Charset charset, Type type) {
        return UriUtils.encodeUriComponent(scheme, charset, type);
    }

    static String encodeUriComponent(String source, String encoding, Type type) {
        return UriUtils.encodeUriComponent(source, Charset.forName(encoding), type);
    }

    static String encodeUriComponent(String source, Charset charset, Type type) {
        byte[] bytes;
        if (source == null || source.length() <= 0) {
            return source;
        }
        if (charset == null) {
            throw new IllegalArgumentException("Charset must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        try {
            bytes = source.getBytes(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);
        boolean changed = false;
        for (byte b : bytes) {
            if (b < 0) {
                b = (byte)(b + 256);
            }
            if (type.isAllowed(b)) {
                bos.write(b);
                continue;
            }
            bos.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            bos.write(hex1);
            bos.write(hex2);
            changed = true;
        }
        try {
            return changed ? new String(bos.toByteArray(), charset.name()) : source;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String uriDecode(String source, Charset charset) {
        int length = source.length();
        if (length == 0) {
            return source;
        }
        if (charset == null) {
            throw new IllegalArgumentException("Charset must not be null");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source.charAt(i + 1);
                    char hex2 = source.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u == -1 || l == -1) {
                        throw new IllegalArgumentException("Invalid encoded sequence " + source.substring(i));
                    }
                    bos.write((char)((u << 4) + l));
                    i += 2;
                    changed = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence " + source.substring(i));
            }
            bos.write(ch);
        }
        try {
            return changed ? new String(bos.toByteArray(), charset.name()) : source;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String decode(String url) {
        return UriUtils.decode(url, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static String decode(String source, String encoding) {
        return UriUtils.uriDecode(source, Charset.forName(encoding));
    }

    public static String decode(String source, Charset charset) {
        return UriUtils.uriDecode(source, charset);
    }

    public static String extractFileExtension(String path) {
        int begin;
        int paramIndex;
        int extIndex;
        int end = path.indexOf(63);
        int fragmentIndex = path.indexOf(35);
        if (fragmentIndex != -1 && (end == -1 || fragmentIndex < end)) {
            end = fragmentIndex;
        }
        if (end == -1) {
            end = path.length();
        }
        if ((extIndex = path.lastIndexOf(46, end = (paramIndex = path.indexOf(59, begin = path.lastIndexOf(47, end) + 1)) != -1 && paramIndex < end ? paramIndex : end)) != -1 && extIndex > begin) {
            return path.substring(extIndex + 1, end);
        }
        return null;
    }

    public static String encodeVal(String paramsStr, Charset charset) {
        String paramPart;
        if (StringUtils.isBlank(paramsStr)) {
            return "";
        }
        String urlPart = null;
        int pathEndPos = paramsStr.indexOf(63);
        if (pathEndPos > -1) {
            urlPart = StringUtils.subPre(paramsStr, pathEndPos);
            paramPart = StringUtils.subSuf(paramsStr, pathEndPos + 1);
            if (StringUtils.isBlank(paramPart)) {
                return urlPart;
            }
        } else {
            paramPart = paramsStr;
        }
        paramPart = UriUtils.normalize(paramPart, charset);
        return StringUtils.isBlank(urlPart) ? paramPart : urlPart + "?" + paramPart;
    }

    public static String normalize(String paramPart, Charset charset) {
        int lastIndex;
        int i;
        TextUtils builder = TextUtils.create(paramPart.length() + 16);
        int len = paramPart.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = paramPart.charAt(i);
            if (c == '=') {
                if (null != name) continue;
                name = pos == i ? "" : paramPart.substring(pos, i);
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (pos != i) {
                if (null == name) {
                    name = paramPart.substring(pos, i);
                    builder.append(UriUtils.encodeQuery(name, charset)).append('=');
                } else {
                    builder.append(UriUtils.encodeQuery(name, charset)).append('=').append(UriUtils.encodeQuery(paramPart.substring(pos, i), charset)).append('&');
                }
                name = null;
            }
            pos = i + 1;
        }
        if (null != name) {
            builder.append(UriUtils.encodeQuery(name, charset)).append('=');
        }
        if (pos != i) {
            if (null == name && pos > 0) {
                builder.append('=');
            }
            builder.append(UriUtils.encodeQuery(paramPart.substring(pos, i), charset));
        }
        if ('&' == builder.charAt(lastIndex = builder.length() - 1)) {
            builder.delTo(lastIndex);
        }
        return builder.toString();
    }

    public static String decodeMap(Map<String, ?> paramMap, Charset charset) {
        if (CollUtils.isEmpty(paramMap)) {
            return "";
        }
        if (null == charset) {
            charset = org.aoju.bus.core.lang.Charset.UTF_8;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, ?> item : paramMap.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            String key = item.getKey();
            Object value = item.getValue();
            if (value instanceof Iterable) {
                value = CollUtils.join((Iterable)value, (CharSequence)",");
            } else if (value instanceof Iterator) {
                value = CollUtils.join((Iterator)value, (CharSequence)",");
            }
            String valueStr = Convert.toString(value);
            if (!StringUtils.isNotEmpty(key)) continue;
            sb.append(UriUtils.encodeAll(key, charset)).append("=");
            if (!StringUtils.isNotEmpty(valueStr)) continue;
            sb.append(UriUtils.encodeAll(valueStr, charset));
        }
        return sb.toString();
    }

    public static Map<String, String> decodeVal(String params, String charset) {
        Map<String, List<String>> paramsMap = UriUtils.decodeObj(params, charset);
        HashMap<String, String> result = MapUtils.newHashMap(paramsMap.size());
        for (Map.Entry<String, List<String>> entry : paramsMap.entrySet()) {
            List<String> list = entry.getValue();
            result.put(entry.getKey(), CollUtils.isEmpty(list) ? null : list.get(0));
        }
        return result;
    }

    public static Map<String, List<String>> decodeObj(String params, String charset) {
        int i;
        if (StringUtils.isBlank(params)) {
            return Collections.emptyMap();
        }
        int pathEndPos = params.indexOf(63);
        if (pathEndPos > -1) {
            params = StringUtils.subSuf(params, pathEndPos + 1);
        }
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        int len = params.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = params.charAt(i);
            if (c == '=') {
                if (null == name) {
                    name = params.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (null == name && pos != i) {
                UriUtils.addParam(map, params.substring(pos, i), "", charset);
            } else if (name != null) {
                UriUtils.addParam(map, name, params.substring(pos, i), charset);
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                UriUtils.addParam(map, params.substring(pos, i), "", charset);
            } else {
                UriUtils.addParam(map, name, params.substring(pos, i), charset);
            }
        } else if (name != null) {
            UriUtils.addParam(map, name, "", charset);
        }
        return map;
    }

    public static String withForm(String url, Map<String, Object> form, Charset charset, boolean isEncodeParams) {
        if (isEncodeParams && StringUtils.contains((CharSequence)url, '?')) {
            url = UriUtils.encodeVal(url, charset);
        }
        return UriUtils.withForm(url, UriUtils.decodeMap(form, charset), charset, false);
    }

    public static String withForm(String url, String queryString, Charset charset, boolean isEncode) {
        if (StringUtils.isBlank(queryString)) {
            if (StringUtils.contains((CharSequence)url, '?')) {
                return isEncode ? UriUtils.encodeVal(url, charset) : url;
            }
            return url;
        }
        TextUtils textUtils = TextUtils.create(url.length() + queryString.length() + 16);
        int qmIndex = url.indexOf(63);
        if (qmIndex > 0) {
            textUtils.append(isEncode ? UriUtils.encodeVal(url, charset) : url);
            if (!StringUtils.endWith((CharSequence)url, '&')) {
                textUtils.append('&');
            }
        } else {
            textUtils.append(url);
            if (qmIndex < 0) {
                textUtils.append('?');
            }
        }
        textUtils.append(isEncode ? UriUtils.encodeVal(queryString, charset) : queryString);
        return textUtils.toString();
    }

    private static void addParam(Map<String, List<String>> params, String name, String value, String charset) {
        name = UriUtils.decode(name, charset);
        value = UriUtils.decode(value, charset);
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
    }

    public static URI getHost(URL url) {
        if (null == url) {
            return null;
        }
        try {
            return new URI(url.getProtocol(), url.getHost(), null, null);
        }
        catch (URISyntaxException e) {
            throw new InstrumentException(e);
        }
    }

    public static String toURL(String mimeType, String encoding, String data) {
        return UriUtils.toURL(mimeType, null, encoding, data);
    }

    public static String toURL(String mimeType, Charset charset, String encoding, String data) {
        StringBuilder builder = StringUtils.builder("data:");
        if (StringUtils.isNotBlank(mimeType)) {
            builder.append(mimeType);
        }
        if (null != charset) {
            builder.append(";charset=").append(charset.name());
        }
        if (StringUtils.isNotBlank(encoding)) {
            builder.append(';').append(encoding);
        }
        builder.append(',').append(data);
        return builder.toString();
    }

    public String getScheme() {
        return this.scheme;
    }

    public UriUtils setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getSchemeWithDefault() {
        return StringUtils.emptyToDefault(this.scheme, "http");
    }

    public String getHost() {
        return this.host;
    }

    public UriUtils setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public UriUtils setPort(int port) {
        this.port = port;
        return this;
    }

    public String getAuthority() {
        return this.port < 0 ? this.host : this.host + ":" + this.port;
    }

    public Path getPath() {
        return this.path;
    }

    public UriUtils setPath(Path path) {
        this.path = path;
        return this;
    }

    public String getPathStr() {
        return null == this.path ? "/" : this.path.build(this.charset);
    }

    public UriUtils addPath(String segment) {
        if (StringUtils.isBlank(segment)) {
            return this;
        }
        if (null == this.path) {
            this.path = new Path();
        }
        this.path.add(segment);
        return this;
    }

    public UriUtils appendPath(CharSequence segment) {
        if (StringUtils.isEmpty(segment)) {
            return this;
        }
        if (this.path == null) {
            this.path = new Path();
        }
        this.path.add(segment);
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    public UriUtils setQuery(Query query) {
        this.query = query;
        return this;
    }

    public String getQueryStr() {
        return null == this.query ? null : this.query.build(this.charset);
    }

    public UriUtils addQuery(String key, String value) {
        if (StringUtils.isEmpty(key)) {
            return this;
        }
        if (this.query == null) {
            this.query = new Query();
        }
        this.query.add(key, value);
        return this;
    }

    public String getFragment() {
        return this.fragment;
    }

    public UriUtils setFragment(String fragment) {
        if (StringUtils.isEmpty(fragment)) {
            this.fragment = null;
        }
        this.fragment = StringUtils.removePrefix(fragment, "#");
        return this;
    }

    public String getFragmentEncoded() {
        return UriUtils.encodeAll(this.fragment, this.charset);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public UriUtils setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public String build() {
        return this.toURL().toString();
    }

    public URL toURL() {
        return this.toURL(null);
    }

    public URL toURL(URLStreamHandler handler) {
        StringBuilder fileBuilder = new StringBuilder();
        fileBuilder.append(StringUtils.blankToDefault(this.getPathStr(), "/"));
        String query = this.getQueryStr();
        if (StringUtils.isNotBlank(query)) {
            fileBuilder.append('?').append(query);
        }
        if (StringUtils.isNotBlank(this.fragment)) {
            fileBuilder.append('#').append(this.getFragmentEncoded());
        }
        try {
            return new URL(this.getSchemeWithDefault(), this.host, this.port, fileBuilder.toString(), handler);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URI toURI() {
        try {
            return new URI(this.getSchemeWithDefault(), this.getAuthority(), this.getPathStr(), this.getQueryStr(), this.getFragmentEncoded());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String toString() {
        return this.build();
    }

    public static class Query {
        private final TableMap<CharSequence, CharSequence> query;

        public Query() {
            this(null);
        }

        public Query(Map<? extends CharSequence, ?> queryMap) {
            if (MapUtils.isNotEmpty(queryMap)) {
                this.query = new TableMap(queryMap.size());
                this.addAll(queryMap);
            } else {
                this.query = new TableMap(16);
            }
        }

        public static Query of(Map<? extends CharSequence, ?> queryMap) {
            return new Query(queryMap);
        }

        public static Query of(String queryStr, Charset charset) {
            Query Query2 = new Query();
            Query2.parse(queryStr, charset);
            return Query2;
        }

        private static String toStr(Object value) {
            String result = value instanceof Iterable ? CollUtils.join((Iterable)value, (CharSequence)",") : (value instanceof Iterator ? IterUtils.join((Iterator)value, (CharSequence)",") : Convert.toString(value));
            return result;
        }

        public Query add(CharSequence key, Object value) {
            this.query.put(key, Query.toStr(value));
            return this;
        }

        public Query addAll(Map<? extends CharSequence, ?> queryMap) {
            if (MapUtils.isNotEmpty(queryMap)) {
                queryMap.forEach(this::add);
            }
            return this;
        }

        public Query parse(String queryStr, Charset charset) {
            int i;
            if (StringUtils.isBlank(queryStr)) {
                return this;
            }
            int pathEndPos = queryStr.indexOf(63);
            if (pathEndPos > -1 && StringUtils.isBlank(queryStr = StringUtils.subSuf(queryStr, pathEndPos + 1))) {
                return this;
            }
            int len = queryStr.length();
            String name = null;
            int pos = 0;
            block4: for (i = 0; i < len; ++i) {
                char c = queryStr.charAt(i);
                switch (c) {
                    case '=': {
                        if (null != name) continue block4;
                        name = queryStr.substring(pos, i);
                        pos = i + 1;
                        continue block4;
                    }
                    case '&': {
                        this.addParam(name, queryStr.substring(pos, i), charset);
                        name = null;
                        if (i + 4 < len && "&amp;".equals(queryStr.substring(i + 1, i + 5))) {
                            i += 4;
                        }
                        pos = i + 1;
                    }
                }
            }
            this.addParam(name, queryStr.substring(pos, i), charset);
            return this;
        }

        public Map<CharSequence, CharSequence> getQueryMap() {
            return MapUtils.unmodifiable(this.query);
        }

        public CharSequence get(CharSequence key) {
            if (MapUtils.isEmpty(this.query)) {
                return null;
            }
            return this.query.get(key);
        }

        public String build(Charset charset) {
            if (MapUtils.isEmpty(this.query)) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (Map.Entry<CharSequence, CharSequence> entry : this.query) {
                CharSequence key;
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append("&");
                }
                if (!StringUtils.isNotEmpty(key = entry.getKey())) continue;
                sb.append(UriUtils.encodeAll(StringUtils.toString(key), charset)).append("=");
                CharSequence value = entry.getValue();
                if (!StringUtils.isNotEmpty(value)) continue;
                sb.append(UriUtils.encodeAll(StringUtils.toString(value), charset));
            }
            return sb.toString();
        }

        public String toString() {
            return this.build(null);
        }

        private void addParam(String key, String value, Charset charset) {
            if (null != key) {
                String actualKey = UriUtils.decode(key, charset);
                this.query.put(actualKey, StringUtils.nullToEmpty(UriUtils.decode(value, charset)));
            } else if (null != value) {
                this.query.put(UriUtils.decode(value, charset), "");
            }
        }
    }

    public static class Path {
        private List<String> segments;
        private boolean withEngTag;

        public static Path of(String pathStr, Charset charset) {
            Path Path2 = new Path();
            Path2.parse(pathStr, charset);
            return Path2;
        }

        private static String fixSegment(CharSequence segment) {
            if (StringUtils.isEmpty(segment) || "/".contentEquals(segment)) {
                return null;
            }
            String segmentStr = StringUtils.toString(segment);
            segmentStr = StringUtils.trim(segmentStr);
            segmentStr = StringUtils.removePrefix(segmentStr, "/");
            segmentStr = StringUtils.removeSuffix(segmentStr, "/");
            segmentStr = StringUtils.trim(segmentStr);
            return segmentStr;
        }

        public Path setWithEndTag(boolean withEngTag) {
            this.withEngTag = withEngTag;
            return this;
        }

        public List<String> getSegments() {
            return this.segments;
        }

        public String getSegment(int index) {
            if (null == this.segments || index >= this.segments.size()) {
                return null;
            }
            return this.segments.get(index);
        }

        public Path add(CharSequence segment) {
            this.add(segment, false);
            return this;
        }

        public Path addBefore(CharSequence segment) {
            this.add(segment, true);
            return this;
        }

        public Path parse(String path, Charset charset) {
            Path Path2 = new Path();
            if (StringUtils.isNotEmpty(path)) {
                if (StringUtils.endWith((CharSequence)(path = path.trim()), '/')) {
                    this.withEngTag = true;
                }
                StringTokenizer tokenizer = new StringTokenizer(path, "/");
                while (tokenizer.hasMoreTokens()) {
                    this.add(UriUtils.decode(tokenizer.nextToken(), charset));
                }
            }
            return Path2;
        }

        public String build(Charset charset) {
            if (CollUtils.isEmpty(this.segments)) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            for (String segment : this.segments) {
                builder.append('/').append(UriUtils.encodeAll(segment, charset));
            }
            if (this.withEngTag || StringUtils.isEmpty(builder)) {
                builder.append('/');
            }
            return builder.toString();
        }

        public String toString() {
            return this.build(null);
        }

        private void add(CharSequence segment, boolean before) {
            String seg = Path.fixSegment(segment);
            if (null == seg) {
                return;
            }
            if (this.segments == null) {
                this.segments = new LinkedList<String>();
            }
            if (before) {
                this.segments.add(0, seg);
            } else {
                this.segments.add(seg);
            }
        }
    }

    public static enum Type {
        SCHEME{

            @Override
            public boolean isAllowed(int c) {
                return this.isAlpha(c) || this.isDigit(c) || 43 == c || 45 == c || 46 == c;
            }
        }
        ,
        AUTHORITY{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c || 64 == c;
            }
        }
        ,
        USER_INFO{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c;
            }
        }
        ,
        HOST_IPV4{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c);
            }
        }
        ,
        HOST_IPV6{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 91 == c || 93 == c || 58 == c;
            }
        }
        ,
        PORT{

            @Override
            public boolean isAllowed(int c) {
                return this.isDigit(c);
            }
        }
        ,
        PATH{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c;
            }
        }
        ,
        PATH_SEGMENT{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c);
            }
        }
        ,
        QUERY{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        QUERY_PARAM{

            @Override
            public boolean isAllowed(int c) {
                if (61 == c || 38 == c) {
                    return false;
                }
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        FRAGMENT{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        URI{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c);
            }
        };


        public abstract boolean isAllowed(int var1);

        protected boolean isAlpha(int c) {
            return c >= 97 && c <= 122 || c >= 65 && c <= 90;
        }

        protected boolean isDigit(int c) {
            return c >= 48 && c <= 57;
        }

        protected boolean isGenericDelimiter(int c) {
            return 58 == c || 47 == c || 63 == c || 35 == c || 91 == c || 93 == c || 64 == c;
        }

        protected boolean isSubDelimiter(int c) {
            return 33 == c || 36 == c || 38 == c || 39 == c || 40 == c || 41 == c || 42 == c || 43 == c || 44 == c || 59 == c || 61 == c;
        }

        protected boolean isReserved(int c) {
            return this.isGenericDelimiter(c) || this.isSubDelimiter(c);
        }

        protected boolean isUnreserved(int c) {
            return this.isAlpha(c) || this.isDigit(c) || 45 == c || 46 == c || 95 == c || 126 == c;
        }

        protected boolean isPchar(int c) {
            return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c || 64 == c;
        }
    }
}

