/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.IoUtils;

public interface Resource {
    public String getName();

    public URL getUrl();

    public InputStream getStream();

    public BufferedReader getReader(Charset var1);

    public String readString(Charset var1) throws InstrumentException;

    public byte[] readBytes() throws InstrumentException;

    default public void writeTo(OutputStream out) throws InstrumentException {
        try (InputStream in = this.getStream();){
            IoUtils.copy(in, out);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }
}

