/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.DateUtils;
import org.aoju.bus.core.utils.MathUtils;
import org.aoju.bus.core.utils.StringUtils;

public class RandomUtils {
    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static Random getRandom(boolean isSecure) {
        return isSecure ? RandomUtils.getSecureRandom() : RandomUtils.getRandom();
    }

    public static SecureRandom getSecureRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstrumentException(e);
        }
    }

    public static SecureRandom getSecureRandom(byte[] seed) {
        return null == seed ? new SecureRandom() : new SecureRandom(seed);
    }

    public static int randomInt(int min, int max) {
        return RandomUtils.getRandom().nextInt(min, max);
    }

    public static int randomInt() {
        return RandomUtils.getRandom().nextInt();
    }

    public static int randomInt(int limit) {
        return RandomUtils.getRandom().nextInt(limit);
    }

    public static long randomLong(long min, long max) {
        return RandomUtils.getRandom().nextLong(min, max);
    }

    public static long randomLong() {
        return RandomUtils.getRandom().nextLong();
    }

    public static long randomLong(long limit) {
        return RandomUtils.getRandom().nextLong(limit);
    }

    public static double randomDouble(double min, double max) {
        return RandomUtils.getRandom().nextDouble(min, max);
    }

    public static double randomDouble(double min, double max, int scale, RoundingMode roundingMode) {
        return MathUtils.round(RandomUtils.randomDouble(min, max), scale, roundingMode).doubleValue();
    }

    public static double randomDouble() {
        return RandomUtils.getRandom().nextDouble();
    }

    public static double randomDouble(int scale, RoundingMode roundingMode) {
        return MathUtils.round(RandomUtils.randomDouble(), scale, roundingMode).doubleValue();
    }

    public static double randomDouble(double limit) {
        return RandomUtils.getRandom().nextDouble(limit);
    }

    public static double randomDouble(double limit, int scale, RoundingMode roundingMode) {
        return MathUtils.round(RandomUtils.randomDouble(limit), scale, roundingMode).doubleValue();
    }

    public static BigDecimal randomBigDecimal() {
        return MathUtils.toBigDecimal(RandomUtils.getRandom().nextDouble());
    }

    public static BigDecimal randomBigDecimal(BigDecimal limit) {
        return MathUtils.toBigDecimal(RandomUtils.getRandom().nextDouble(limit.doubleValue()));
    }

    public static BigDecimal randomBigDecimal(BigDecimal min, BigDecimal max) {
        return MathUtils.toBigDecimal(RandomUtils.getRandom().nextDouble(min.doubleValue(), max.doubleValue()));
    }

    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        RandomUtils.getRandom().nextBytes(bytes);
        return bytes;
    }

    public static <T> T randomEle(List<T> list) {
        return RandomUtils.randomEle(list, list.size());
    }

    public static <T> T randomEle(List<T> list, int limit) {
        return list.get(RandomUtils.randomInt(limit));
    }

    public static <T> T randomEle(T[] array) {
        return RandomUtils.randomEle(array, array.length);
    }

    public static <T> T randomEle(T[] array, int limit) {
        return array[RandomUtils.randomInt(limit)];
    }

    public static <T> List<T> randomEles(List<T> list, int count) {
        ArrayList<T> result = new ArrayList<T>(count);
        int limit = list.size();
        while (result.size() < count) {
            result.add(RandomUtils.randomEle(list, limit));
        }
        return result;
    }

    public static <T> List<T> randomEleList(List<T> source, int count) {
        if (count >= source.size()) {
            return source;
        }
        int[] randomList = ArrayUtils.sub(RandomUtils.randomInts(source.size()), 0, count);
        ArrayList<T> result = new ArrayList<T>();
        for (int e : randomList) {
            result.add(source.get(e));
        }
        return result;
    }

    public static <T> Set<T> randomEleSet(Collection<T> collection, int count) {
        ArrayList<T> source = new ArrayList<T>(new HashSet<T>(collection));
        if (count > source.size()) {
            throw new IllegalArgumentException("Count is larger than collection distinct size !");
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(count);
        int limit = collection.size();
        while (result.size() < count) {
            result.add(RandomUtils.randomEle(source, limit));
        }
        return result;
    }

    public static String randomString(int length) {
        return RandomUtils.randomString("abcdefghijklmnopqrstuvwxyz0123456789", length);
    }

    public static String randomStringUpper(int length) {
        return RandomUtils.randomString("abcdefghijklmnopqrstuvwxyz0123456789", length).toUpperCase();
    }

    public static int[] randomInts(int length) {
        int[] list = ArrayUtils.range(length);
        for (int i = 0; i < length; ++i) {
            int random = RandomUtils.randomInt(i, length);
            ArrayUtils.swap(list, i, random);
        }
        return list;
    }

    public static String randomNumbers(int length) {
        return RandomUtils.randomString("0123456789", length);
    }

    public static String randomString(String str, int length) {
        if (StringUtils.isEmpty(str)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length);
        if (length < 1) {
            length = 1;
        }
        int baseLength = str.length();
        for (int i = 0; i < length; ++i) {
            int number = RandomUtils.randomInt(baseLength);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static int randomNumber() {
        return RandomUtils.randomChar("0123456789");
    }

    public static char randomChar() {
        return RandomUtils.randomChar("abcdefghijklmnopqrstuvwxyz0123456789");
    }

    public static char randomChar(String baseString) {
        return baseString.charAt(RandomUtils.getRandom().nextInt(baseString.length()));
    }

    public static Color randomColor() {
        ThreadLocalRandom random = RandomUtils.getRandom();
        return new Color(((Random)random).nextInt(255), ((Random)random).nextInt(255), ((Random)random).nextInt(255));
    }

    public static DateTime randomDay(int min, int max) {
        return RandomUtils.randomDate(DateUtils.date(), Fields.DateField.DAY_OF_YEAR, min, max);
    }

    public static DateTime randomDate(Date baseDate, Fields.DateField dateField, int min, int max) {
        if (null == baseDate) {
            baseDate = DateUtils.date();
        }
        return DateUtils.offset(baseDate, dateField, RandomUtils.randomInt(min, max));
    }

    public static boolean randomBoolean() {
        return 0 == RandomUtils.randomInt(2);
    }
}

