/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.BooleanKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.StringKit;

public class PrimitiveConverter
extends AbstractConverter<Object> {
    private final Class<?> targetType;

    public PrimitiveConverter(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("PrimitiveConverter not allow null target type!");
        }
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException("[" + clazz + "] is not a primitive class!");
        }
        this.targetType = clazz;
    }

    @Override
    protected Object convertInternal(Object value) {
        try {
            if (Byte.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                if (value instanceof Boolean) {
                    return BooleanKit.toByte((Boolean)value);
                }
                String valueStr = this.convertToStr(value);
                if (StringKit.isBlank(valueStr)) {
                    return 0;
                }
                return Byte.parseByte(valueStr);
            }
            if (Short.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                if (value instanceof Boolean) {
                    return BooleanKit.toShort((Boolean)value);
                }
                String valueStr = this.convertToStr(value);
                if (StringKit.isBlank(valueStr)) {
                    return 0;
                }
                return Short.parseShort(valueStr);
            }
            if (Integer.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                if (value instanceof Boolean) {
                    return BooleanKit.toInt((Boolean)value);
                }
                String valueStr = this.convertToStr(value);
                if (StringKit.isBlank(valueStr)) {
                    return 0;
                }
                return MathKit.parseInt(valueStr);
            }
            if (Long.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                if (value instanceof Boolean) {
                    return BooleanKit.toLong((Boolean)value);
                }
                String valueStr = this.convertToStr(value);
                if (StringKit.isBlank(valueStr)) {
                    return 0;
                }
                return MathKit.parseLong(valueStr);
            }
            if (Float.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                if (value instanceof Boolean) {
                    return Float.valueOf(BooleanKit.toFloat((Boolean)value));
                }
                String valueStr = this.convertToStr(value);
                if (StringKit.isBlank(valueStr)) {
                    return 0;
                }
                return Float.valueOf(Float.parseFloat(valueStr));
            }
            if (Double.TYPE == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                if (value instanceof Boolean) {
                    return BooleanKit.toDouble((Boolean)value);
                }
                String valueStr = this.convertToStr(value);
                if (StringKit.isBlank(valueStr)) {
                    return 0;
                }
                return Double.parseDouble(valueStr);
            }
            if (Character.TYPE == this.targetType) {
                if (value instanceof Character) {
                    return Character.valueOf(((Character)value).charValue());
                }
                if (value instanceof Boolean) {
                    return Character.valueOf(BooleanKit.toChar((Boolean)value));
                }
                String valueStr = this.convertToStr(value);
                if (StringKit.isBlank(valueStr)) {
                    return 0;
                }
                return Character.valueOf(valueStr.charAt(0));
            }
            if (Boolean.TYPE == this.targetType) {
                if (value instanceof Boolean) {
                    return (boolean)((Boolean)value);
                }
                String valueStr = this.convertToStr(value);
                return BooleanKit.toBoolean(valueStr);
            }
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        return 0;
    }

    @Override
    protected String convertToStr(Object value) {
        return StringKit.trim(super.convertToStr(value));
    }

    @Override
    public Class<Object> getTargetType() {
        return this.targetType;
    }
}

